/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tests;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ClassAssert;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterConfig;

public class DatabaseAdapterTestUtils {
    public static <T extends DatabaseAdapterConfig> void assertAdjustableConfigConvention(Class<T> configClass, Class<? extends T> adjustableConfigClass) {
        Assertions.assertThat(adjustableConfigClass).isInterface();
        ((ClassAssert)Assertions.assertThat(configClass).isInterface()).isAssignableFrom(new Class[]{adjustableConfigClass});
        List missingMethods = Stream.of(configClass.getDeclaredMethods()).filter(method -> method.getName().startsWith("get")).map(method -> {
            String expectedSetterName = method.getName().replaceFirst("get", "with");
            String expectedParamName = expectedSetterName.replaceFirst("with", "");
            expectedParamName = expectedParamName.substring(0, 1).toLowerCase(Locale.ROOT) + expectedParamName.substring(1);
            String expectedMethodCode = adjustableConfigClass.getSimpleName() + " " + expectedSetterName + "(" + method.getReturnType().getSimpleName() + " " + expectedParamName + ");";
            try {
                Method setter = adjustableConfigClass.getDeclaredMethod(expectedSetterName, method.getReturnType());
                if (setter.getParameters().length == 1 && setter.getParameters()[0].getName().equals(expectedParamName)) {
                    return Optional.empty();
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return Optional.of(expectedMethodCode);
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (!missingMethods.isEmpty()) {
            org.junit.jupiter.api.Assertions.fail((String)("By convention " + adjustableConfigClass.getSimpleName() + " is missing the following methods:\n" + String.join((CharSequence)"\n", missingMethods)));
        }
    }
}

