/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tests;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.ReferenceRetryFailureException;
import org.projectnessie.versioned.persist.adapter.CommitParams;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitParams;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.persist.adapter.spi.DatabaseAdapterMetrics;
import org.projectnessie.versioned.store.DefaultStoreWorker;
import org.projectnessie.versioned.testworker.OnRefOnly;

public abstract class AbstractConcurrency {
    private final DatabaseAdapter databaseAdapter;

    protected AbstractConcurrency(DatabaseAdapter databaseAdapter) {
        this.databaseAdapter = databaseAdapter;
    }

    static Stream<Variation> concurrencyVariations() {
        return Stream.of(Boolean.FALSE, Boolean.TRUE).flatMap(singleBranch -> Stream.of(Integer.valueOf(3)).map(tables -> new Variation((boolean)singleBranch, (int)tables)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"concurrencyVariations"})
    void concurrency(Variation variation) throws Exception {
        new ArrayList<MeterRegistry>(Metrics.globalRegistry.getRegistries()).forEach(arg_0 -> ((CompositeMeterRegistry)Metrics.globalRegistry).remove(arg_0));
        Metrics.globalRegistry.add((MeterRegistry)new SimpleMeterRegistry());
        ExecutorService executor = Executors.newFixedThreadPool(variation.threads);
        AtomicInteger commitsOK = new AtomicInteger();
        AtomicInteger retryFailures = new AtomicInteger();
        AtomicBoolean stopFlag = new AtomicBoolean();
        ArrayList<Runnable> tasks = new ArrayList<Runnable>(variation.threads);
        HashMap<ContentKey, ContentId> keyToContentId = new HashMap<ContentKey, ContentId>();
        ConcurrentHashMap<BranchName, Map<ContentKey, ByteString>> onRefStates = new ConcurrentHashMap<BranchName, Map<ContentKey, ByteString>>();
        try {
            CountDownLatch startLatch = new CountDownLatch(1);
            HashMap<BranchName, Set> keysPerBranch = new HashMap<BranchName, Set>();
            for (int i = 0; i < variation.threads; ++i) {
                BranchName branch = BranchName.of((String)("concurrency-" + (variation.singleBranch ? "shared" : Integer.valueOf(i))));
                ArrayList<ContentKey> keys = new ArrayList<ContentKey>(variation.tables);
                for (int k = 0; k < variation.tables; ++k) {
                    String variationKey = Integer.toString(i);
                    ContentKey key = ContentKey.of((String[])new String[]{"some-key-" + (String)variationKey + "-table-" + k});
                    keys.add(key);
                    keyToContentId.put(key, ContentId.of((String)String.format("%s-table-%d", variationKey, k)));
                    keysPerBranch.computeIfAbsent(branch, x -> new HashSet()).add(key);
                }
                tasks.add(() -> {
                    try {
                        Assertions.assertThat((boolean)startLatch.await(2L, TimeUnit.SECONDS)).isTrue();
                        int commit = 0;
                        while (!stopFlag.get()) {
                            ImmutableCommitParams.Builder commitAttempt = ImmutableCommitParams.builder();
                            for (int ki = 0; ki < keys.size(); ++ki) {
                                ContentKey key = (ContentKey)keys.get(ki);
                                ContentId contentId = (ContentId)keyToContentId.get(key);
                                OnRefOnly c = OnRefOnly.onRef((String)"", (String)contentId.getId());
                                commitAttempt.addPuts(KeyWithBytes.of((ContentKey)((ContentKey)keys.get(ki)), (ContentId)contentId, (byte)DefaultStoreWorker.payloadForContent((Content)c), (ByteString)DefaultStoreWorker.instance().toStoreOnReferenceState((Content)c)));
                            }
                            try {
                                commitAttempt.toBranch(branch).commitMetaSerialized(ByteString.copyFromUtf8((String)("commit #" + commit + " to " + branch.getName() + " something " + ThreadLocalRandom.current().nextLong())));
                                this.commitAndRecord(onRefStates, branch, commitAttempt);
                                commitsOK.incrementAndGet();
                            }
                            catch (ReferenceRetryFailureException retry) {
                                retryFailures.incrementAndGet();
                            }
                            ++commit;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                });
            }
            for (Map.Entry branchKeys : keysPerBranch.entrySet()) {
                BranchName branch = (BranchName)branchKeys.getKey();
                this.databaseAdapter.create((NamedRef)branch, this.databaseAdapter.hashOnReference((NamedRef)BranchName.of((String)"main"), Optional.empty()));
                ImmutableCommitParams.Builder commitAttempt = ImmutableCommitParams.builder().toBranch((BranchName)branchKeys.getKey()).commitMetaSerialized(ByteString.copyFromUtf8((String)("initial commit for " + branch.getName())));
                for (ContentKey k : (Set)branchKeys.getValue()) {
                    ContentId contentId = (ContentId)keyToContentId.get(k);
                    OnRefOnly c = OnRefOnly.onRef((String)"", (String)contentId.getId());
                    commitAttempt.addPuts(KeyWithBytes.of((ContentKey)k, (ContentId)contentId, (byte)DefaultStoreWorker.payloadForContent((Content)c), (ByteString)DefaultStoreWorker.instance().toStoreOnReferenceState((Content)c)));
                }
                this.commitAndRecord(onRefStates, branch, commitAttempt);
            }
            CompletableFuture<Void> combinedFuture = CompletableFuture.allOf((CompletableFuture[])tasks.stream().map(r -> CompletableFuture.runAsync(r, executor)).toArray(CompletableFuture[]::new));
            startLatch.countDown();
            Thread.sleep(2000L);
            stopFlag.set(true);
            combinedFuture.get(30L, TimeUnit.SECONDS);
            for (Map.Entry branchKeys : keysPerBranch.entrySet()) {
                BranchName branch = (BranchName)branchKeys.getKey();
                Hash hash = this.databaseAdapter.hashOnReference((NamedRef)branch, Optional.empty());
                ArrayList keys = new ArrayList((Collection)branchKeys.getValue());
                this.databaseAdapter.values(hash, keys, KeyFilterPredicate.ALLOW_ALL);
            }
            stopFlag.set(true);
            executor.shutdownNow();
        }
        catch (Throwable throwable) {
            stopFlag.set(true);
            executor.shutdownNow();
            Assertions.assertThat((boolean)executor.awaitTermination(30L, TimeUnit.SECONDS)).isTrue();
            System.out.printf("AbstractConcurrency.concurrency - %s : Commits OK: %s  Retry-Failures: %s%n", variation, commitsOK, retryFailures);
            System.out.printf("AbstractConcurrency.concurrency - %s : try-loop success: count: %6d  retries: %6d  total-time-millis: %d%n", variation, (long)DatabaseAdapterMetrics.tryLoopCounts((String)"success").count(), (long)DatabaseAdapterMetrics.tryLoopRetries((String)"success").count(), (long)DatabaseAdapterMetrics.tryLoopDuration((String)"success").totalTime(TimeUnit.MILLISECONDS));
            System.out.printf("AbstractConcurrency.concurrency - %s : try-loop failure: count: %6d  retries: %6d  total-time-millis: %d%n", variation, (long)DatabaseAdapterMetrics.tryLoopCounts((String)"fail").count(), (long)DatabaseAdapterMetrics.tryLoopRetries((String)"fail").count(), (long)DatabaseAdapterMetrics.tryLoopDuration((String)"fail").totalTime(TimeUnit.MILLISECONDS));
            new ArrayList<MeterRegistry>(Metrics.globalRegistry.getRegistries()).forEach(arg_0 -> ((CompositeMeterRegistry)Metrics.globalRegistry).remove(arg_0));
            throw throwable;
        }
        Assertions.assertThat((boolean)executor.awaitTermination(30L, TimeUnit.SECONDS)).isTrue();
        System.out.printf("AbstractConcurrency.concurrency - %s : Commits OK: %s  Retry-Failures: %s%n", variation, commitsOK, retryFailures);
        System.out.printf("AbstractConcurrency.concurrency - %s : try-loop success: count: %6d  retries: %6d  total-time-millis: %d%n", variation, (long)DatabaseAdapterMetrics.tryLoopCounts((String)"success").count(), (long)DatabaseAdapterMetrics.tryLoopRetries((String)"success").count(), (long)DatabaseAdapterMetrics.tryLoopDuration((String)"success").totalTime(TimeUnit.MILLISECONDS));
        System.out.printf("AbstractConcurrency.concurrency - %s : try-loop failure: count: %6d  retries: %6d  total-time-millis: %d%n", variation, (long)DatabaseAdapterMetrics.tryLoopCounts((String)"fail").count(), (long)DatabaseAdapterMetrics.tryLoopRetries((String)"fail").count(), (long)DatabaseAdapterMetrics.tryLoopDuration((String)"fail").totalTime(TimeUnit.MILLISECONDS));
        new ArrayList<MeterRegistry>(Metrics.globalRegistry.getRegistries()).forEach(arg_0 -> ((CompositeMeterRegistry)Metrics.globalRegistry).remove(arg_0));
    }

    private void commitAndRecord(Map<BranchName, Map<ContentKey, ByteString>> onRefStates, BranchName branch, ImmutableCommitParams.Builder commitAttempt) throws ReferenceConflictException, ReferenceNotFoundException {
        ImmutableCommitParams c = commitAttempt.build();
        this.databaseAdapter.commit((CommitParams)c);
        Map onRef = onRefStates.computeIfAbsent(branch, b -> new ConcurrentHashMap());
        c.getPuts().forEach(kwb -> onRef.put(kwb.getKey(), kwb.getValue()));
    }

    static class Variation {
        final int threads = Math.max(4, Runtime.getRuntime().availableProcessors());
        final boolean singleBranch;
        final int tables;

        Variation(boolean singleBranch, int tables) {
            this.singleBranch = singleBranch;
            this.tables = tables;
        }

        public String toString() {
            return "threads=" + this.threads + ", singleBranch=" + this.singleBranch + ", tables=" + this.tables;
        }
    }
}

