/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tests;

import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.persist.adapter.CommitParams;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.Difference;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitParams;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.store.DefaultStoreWorker;
import org.projectnessie.versioned.testworker.OnRefOnly;

public abstract class AbstractDiff {
    private final DatabaseAdapter databaseAdapter;

    protected AbstractDiff(DatabaseAdapter databaseAdapter) {
        this.databaseAdapter = databaseAdapter;
    }

    @Test
    void diff() throws Exception {
        int c;
        Stream diff;
        BranchName main = BranchName.of((String)"main");
        BranchName branch = BranchName.of((String)"branch");
        Hash initialHash = this.databaseAdapter.create((NamedRef)branch, this.databaseAdapter.hashOnReference((NamedRef)main, Optional.empty()));
        Hash[] commits = new Hash[3];
        for (int i = 0; i < commits.length; ++i) {
            ImmutableCommitParams.Builder commit = ImmutableCommitParams.builder().toBranch(branch).commitMetaSerialized(ByteString.copyFromUtf8((String)("commit " + i)));
            for (int k2 = 0; k2 < 3; ++k2) {
                OnRefOnly c2 = OnRefOnly.onRef((String)("on-ref " + i + " for " + k2), (String)("cid-" + i + "-" + k2));
                commit.addPuts(KeyWithBytes.of((ContentKey)ContentKey.of((String[])new String[]{"key-" + k2}), (ContentId)ContentId.of((String)("C" + k2)), (byte)DefaultStoreWorker.payloadForContent((Content)c2), (ByteString)DefaultStoreWorker.instance().toStoreOnReferenceState((Content)c2)));
            }
            commits[i] = this.databaseAdapter.commit((CommitParams)commit.build());
        }
        try (Stream diff2 = this.databaseAdapter.diff(this.databaseAdapter.hashOnReference((NamedRef)main, Optional.empty()), this.databaseAdapter.hashOnReference((NamedRef)branch, Optional.of(initialHash)), KeyFilterPredicate.ALLOW_ALL);){
            Assertions.assertThat((Stream)diff2).isEmpty();
        }
        int i = 0;
        while (i < commits.length) {
            diff = this.databaseAdapter.diff(this.databaseAdapter.hashOnReference((NamedRef)main, Optional.empty()), this.databaseAdapter.hashOnReference((NamedRef)branch, Optional.of(commits[i])), KeyFilterPredicate.ALLOW_ALL);
            try {
                c = i++;
                Assertions.assertThat((Stream)diff).containsExactlyInAnyOrderElementsOf((Iterable)IntStream.range(0, 3).mapToObj(k -> {
                    OnRefOnly content = OnRefOnly.onRef((String)("on-ref " + c + " for " + k), (String)("cid-" + c + "-" + k));
                    return Difference.of((byte)DefaultStoreWorker.payloadForContent((Content)content), (ContentKey)ContentKey.of((String[])new String[]{"key-" + k}), Optional.empty(), Optional.empty(), Optional.of(DefaultStoreWorker.instance().toStoreOnReferenceState((Content)content)));
                }).collect(Collectors.toList()));
            }
            finally {
                if (diff != null) {
                    diff.close();
                }
            }
        }
        i = 0;
        while (i < commits.length) {
            diff = this.databaseAdapter.diff(this.databaseAdapter.hashOnReference((NamedRef)branch, Optional.of(commits[i])), this.databaseAdapter.hashOnReference((NamedRef)main, Optional.empty()), KeyFilterPredicate.ALLOW_ALL);
            try {
                c = i++;
                Assertions.assertThat((Stream)diff).containsExactlyInAnyOrderElementsOf((Iterable)IntStream.range(0, 3).mapToObj(k -> {
                    OnRefOnly content = OnRefOnly.onRef((String)("on-ref " + c + " for " + k), (String)("cid-" + c + "-" + k));
                    return Difference.of((byte)DefaultStoreWorker.payloadForContent((Content)content), (ContentKey)ContentKey.of((String[])new String[]{"key-" + k}), Optional.empty(), Optional.of(DefaultStoreWorker.instance().toStoreOnReferenceState((Content)content)), Optional.empty());
                }).collect(Collectors.toList()));
            }
            finally {
                if (diff != null) {
                    diff.close();
                }
            }
        }
        i = 1;
        while (i < commits.length) {
            diff = this.databaseAdapter.diff(this.databaseAdapter.hashOnReference((NamedRef)branch, Optional.of(commits[i - 1])), this.databaseAdapter.hashOnReference((NamedRef)branch, Optional.of(commits[i])), KeyFilterPredicate.ALLOW_ALL);
            try {
                c = i++;
                Assertions.assertThat((Stream)diff).containsExactlyInAnyOrderElementsOf((Iterable)IntStream.range(0, 3).mapToObj(k -> {
                    OnRefOnly from = OnRefOnly.onRef((String)("on-ref " + (c - 1) + " for " + k), (String)("cid-" + (c - 1) + "-" + k));
                    OnRefOnly to = OnRefOnly.onRef((String)("on-ref " + c + " for " + k), (String)("cid-" + c + "-" + k));
                    return Difference.of((byte)DefaultStoreWorker.payloadForContent((Content)from), (ContentKey)ContentKey.of((String[])new String[]{"key-" + k}), Optional.empty(), Optional.of(DefaultStoreWorker.instance().toStoreOnReferenceState((Content)from)), Optional.of(DefaultStoreWorker.instance().toStoreOnReferenceState((Content)to)));
                }).collect(Collectors.toList()));
            }
            finally {
                if (diff != null) {
                    diff.close();
                }
            }
        }
    }
}

