/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tests;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.CommitParams;
import org.projectnessie.versioned.persist.adapter.ContentAndState;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitParams;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import org.projectnessie.versioned.persist.adapter.KeyList;
import org.projectnessie.versioned.persist.adapter.KeyListEntity;
import org.projectnessie.versioned.persist.adapter.KeyListEntry;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.persist.adapter.spi.AbstractDatabaseAdapter;
import org.projectnessie.versioned.persist.tests.extension.NessieDbAdapter;
import org.projectnessie.versioned.persist.tests.extension.NessieDbAdapterConfigItem;
import org.projectnessie.versioned.persist.tests.extension.NessieDbAdapterConfigItems;
import org.projectnessie.versioned.store.DefaultStoreWorker;
import org.projectnessie.versioned.testworker.OnRefOnly;

public abstract class AbstractManyKeys {
    private final DatabaseAdapter databaseAdapter;

    protected AbstractManyKeys(DatabaseAdapter databaseAdapter) {
        this.databaseAdapter = databaseAdapter;
    }

    static List<ManyKeysParams> manyKeysParams() {
        return Arrays.asList(new ManyKeysParams(1000, 25), new ManyKeysParams(100, 10), new ManyKeysParams(500, 2), new ManyKeysParams(500, 10));
    }

    @ParameterizedTest
    @MethodSource(value={"manyKeysParams"})
    void manyKeys(ManyKeysParams params) throws Exception {
        BranchName main = BranchName.of((String)"main");
        List commits = IntStream.range(0, params.commits).mapToObj(i -> ImmutableCommitParams.builder().commitMetaSerialized(ByteString.copyFromUtf8((String)("commit #" + i))).toBranch(main)).collect(Collectors.toList());
        AtomicInteger commitDist = new AtomicInteger();
        HashSet allKeys = new HashSet();
        IntStream.range(0, params.keys).mapToObj(i -> {
            ContentKey key = ContentKey.of((String[])new String[]{"some-" + i + "-long-key-value-foobarbazfoobarbazfoobarbazfoobarbazfoobarbazfoobarbaz"});
            allKeys.add(key);
            OnRefOnly val = OnRefOnly.onRef((String)("value " + i), (String)("cid-" + i));
            return KeyWithBytes.of((ContentKey)key, (ContentId)ContentId.of((String)val.getId()), (byte)DefaultStoreWorker.payloadForContent((Content)val), (ByteString)val.serialized());
        }).forEach(kb -> ((ImmutableCommitParams.Builder)commits.get(commitDist.incrementAndGet() % params.commits)).addPuts(kb));
        for (ImmutableCommitParams.Builder commit : commits) {
            this.databaseAdapter.commit((CommitParams)commit.build());
        }
        Hash mainHead = this.databaseAdapter.hashOnReference((NamedRef)main, Optional.empty());
        try (Stream keys = this.databaseAdapter.keys(mainHead, KeyFilterPredicate.ALLOW_ALL);){
            List fetchedKeys = keys.map(KeyListEntry::getKey).collect(Collectors.toList());
            List fetchedKeysStrings = fetchedKeys.stream().map(ContentKey::toString).collect(Collectors.toList());
            List allKeysStrings = allKeys.stream().map(ContentKey::toString).collect(Collectors.toList());
            ((ListAssert)Assertions.assertThat(fetchedKeysStrings).hasSize(allKeysStrings.size())).containsExactlyInAnyOrderElementsOf(allKeysStrings);
        }
    }

    @Test
    void enhanceKeyListWithCommitId(@NessieDbAdapter @NessieDbAdapterConfigItems(value={@NessieDbAdapterConfigItem(name="key.list.distance", value="5"), @NessieDbAdapterConfigItem(name="max.key.list.size", value="100"), @NessieDbAdapterConfigItem(name="max.key.list.entity.size", value="100")}) DatabaseAdapter da) throws Exception {
        Stream keyListEntityStream;
        CommitLogEntry commit;
        Assumptions.assumeThat((Object)da).extracting(Object::getClass).extracting(Class::getSimpleName).isIn(new Object[]{"InmemoryDatabaseAdapter", "RocksDatabaseAdapter"});
        AbstractDatabaseAdapter ada = (AbstractDatabaseAdapter)da;
        int keyListDistance = ada.getConfig().getKeyListDistance();
        String longString = "keykeykeykeykeykeykeykeykeykeykeykeykeykeykeykeykeykeykeykeykeykeykeykeykeykeykeykeykeykeykeykeykeykeykeykeykeykey";
        BranchName branch = BranchName.of((String)"main");
        ByteString meta = ByteString.copyFromUtf8((String)"msg");
        HashMap<ContentKey, Hash> keyToCommit = new HashMap<ContentKey, Hash>();
        for (int i = 0; i < 10 * keyListDistance; ++i) {
            ContentKey key = ContentKey.of((String[])new String[]{"k" + i + "-" + longString});
            Hash hash = da.commit((CommitParams)ImmutableCommitParams.builder().toBranch(branch).commitMetaSerialized(meta).addPuts(KeyWithBytes.of((ContentKey)key, (ContentId)ContentId.of((String)("c" + i)), (byte)DefaultStoreWorker.payloadForContent((Content.Type)OnRefOnly.ON_REF_ONLY), (ByteString)DefaultStoreWorker.instance().toStoreOnReferenceState((Content)OnRefOnly.onRef((String)("r" + i), (String)("c" + i))))).build());
            keyToCommit.put(key, hash);
        }
        Hash head = da.namedRef(branch.getName(), GetNamedRefsParams.DEFAULT).getHash();
        try (AutoCloseable ctx = ada.borrowConnection();){
            AbstractDatabaseAdapter adaSpy = (AbstractDatabaseAdapter)Mockito.spy((Object)ada);
            adaSpy.values(head, keyToCommit.keySet(), KeyFilterPredicate.ALLOW_ALL);
            commit = ada.fetchFromCommitLog(ctx, head);
            Assertions.assertThat((Object)commit).isNotNull();
            keyListEntityStream = ada.fetchKeyLists(ctx, commit.getKeyListsIds());
            try {
                List noCommitIds = keyListEntityStream.map(e -> KeyListEntity.of((Hash)e.getId(), (KeyList)KeyList.of(e.getKeys().getKeys().stream().filter(Objects::nonNull).map(k -> KeyListEntry.of((ContentKey)k.getKey(), (ContentId)k.getContentId(), (byte)k.getPayload(), null)).collect(Collectors.toList())))).collect(Collectors.toList());
                ada.writeKeyListEntities(ctx, noCommitIds);
            }
            finally {
                if (keyListEntityStream != null) {
                    keyListEntityStream.close();
                }
            }
            keyListEntityStream = ada.fetchKeyLists(ctx, commit.getKeyListsIds());
            try {
                Assertions.assertThat((Stream)keyListEntityStream).allSatisfy(kl -> Assertions.assertThat((List)kl.getKeys().getKeys()).allSatisfy(e -> Assertions.assertThat((Object)e.getCommitId()).isNull()));
            }
            finally {
                if (keyListEntityStream != null) {
                    keyListEntityStream.close();
                }
            }
        }
        for (int i = 0; i < keyListDistance; ++i) {
            ContentKey key = ContentKey.of((String[])new String[]{"pre-fix-" + i});
            Hash hash = da.commit((CommitParams)ImmutableCommitParams.builder().toBranch(branch).commitMetaSerialized(meta).addPuts(KeyWithBytes.of((ContentKey)key, (ContentId)ContentId.of((String)("c" + i)), (byte)DefaultStoreWorker.payloadForContent((Content.Type)OnRefOnly.ON_REF_ONLY), (ByteString)DefaultStoreWorker.instance().toStoreOnReferenceState((Content)OnRefOnly.onRef((String)("pf" + i), (String)("cpf" + i))))).build());
            keyToCommit.put(key, hash);
        }
        Hash fixedHead = da.namedRef(branch.getName(), GetNamedRefsParams.DEFAULT).getHash();
        try (AutoCloseable ctx = ada.borrowConnection();){
            commit = ada.fetchFromCommitLog(ctx, fixedHead);
            Assertions.assertThat((Object)commit).isNotNull();
            keyListEntityStream = ada.fetchKeyLists(ctx, commit.getKeyListsIds());
            try {
                Assertions.assertThat((Stream)keyListEntityStream).allSatisfy(kl -> ((ListAssert)Assertions.assertThat((List)kl.getKeys().getKeys()).filteredOn(Objects::nonNull)).allSatisfy(e -> Assertions.assertThat((Object)e).extracting(new Function[]{KeyListEntry::getCommitId, KeyListEntry::getKey}).containsExactly(new Object[]{keyToCommit.get(e.getKey()), e.getKey()})));
            }
            finally {
                if (keyListEntityStream != null) {
                    keyListEntityStream.close();
                }
            }
        }
    }

    @Test
    void pointContentKeyLookups(@NessieDbAdapterConfigItems(value={@NessieDbAdapterConfigItem(name="max.key.list.size", value="16384"), @NessieDbAdapterConfigItem(name="max.key.list.entity.size", value="16384"), @NessieDbAdapterConfigItem(name="key.list.distance", value="20")}) @NessieDbAdapter DatabaseAdapter databaseAdapter) throws Exception {
        String keyElement = "1234567890123456789012345678901234567890123456789012345678901234";
        IntFunction<ContentKey> keyGen = i -> ContentKey.of((String[])new String[]{"k-" + i + "-" + keyElement + "-" + keyElement});
        IntFunction<OnRefOnly> valueGen = i -> OnRefOnly.onRef((String)("value-" + i), (String)("cid-" + i));
        BranchName branch = BranchName.of((String)"main");
        Hash head = databaseAdapter.hashOnReference((NamedRef)branch, Optional.empty());
        int assumedKeyEntryLen = 160;
        int keyNum = 0;
        for (int estimatedTotalKeyLength = 98304; estimatedTotalKeyLength > 0; estimatedTotalKeyLength -= assumedKeyEntryLen) {
            OnRefOnly val = valueGen.apply(keyNum);
            head = databaseAdapter.commit((CommitParams)ImmutableCommitParams.builder().toBranch(branch).commitMetaSerialized(ByteString.EMPTY).addPuts(KeyWithBytes.of((ContentKey)keyGen.apply(keyNum), (ContentId)ContentId.of((String)val.getId()), (byte)DefaultStoreWorker.payloadForContent((Content)val), (ByteString)val.serialized())).build());
            ++keyNum;
        }
        for (int i2 = 0; i2 < keyNum; ++i2) {
            ContentKey key = keyGen.apply(i2);
            Map values = databaseAdapter.values(head, Collections.singletonList(key), KeyFilterPredicate.ALLOW_ALL);
            Assertions.assertThat((Map)values).extractingByKey((Object)key).extracting(ContentAndState::getRefState).isEqualTo((Object)valueGen.apply(i2).serialized());
        }
    }

    @Test
    void pathologicallySmallSegments(@NessieDbAdapterConfigItems(value={@NessieDbAdapterConfigItem(name="max.key.list.size", value="0"), @NessieDbAdapterConfigItem(name="max.key.list.entity.size", value="0"), @NessieDbAdapterConfigItem(name="key.list.distance", value="20"), @NessieDbAdapterConfigItem(name="key.list.hash.load.factor", value="1.0")}) @NessieDbAdapter DatabaseAdapter databaseAdapter) throws ReferenceNotFoundException, ReferenceConflictException {
        IntFunction<ContentKey> keyGen = i -> ContentKey.of((String[])new String[]{"k-" + i});
        IntFunction<OnRefOnly> valueGen = i -> OnRefOnly.onRef((String)("value-" + i), (String)("cid-" + i));
        BranchName branch = BranchName.of((String)"main");
        int keyCount = 4;
        AbstractManyKeys.commitPutsOnGeneratedKeys(databaseAdapter, branch, keyGen, valueGen, 4);
        Hash head = AbstractManyKeys.makeEmptyCommits(databaseAdapter, branch, 20);
        AbstractManyKeys.checkKeysAndValuesIndividually(databaseAdapter, head, keyGen, valueGen, 4);
    }

    @Test
    void pathologicallyFrequentCollisions(@NessieDbAdapterConfigItems(value={@NessieDbAdapterConfigItem(name="max.key.list.size", value="892"), @NessieDbAdapterConfigItem(name="max.key.list.entity.size", value="130"), @NessieDbAdapterConfigItem(name="key.list.distance", value="20"), @NessieDbAdapterConfigItem(name="key.list.hash.load.factor", value="1.0")}) @NessieDbAdapter DatabaseAdapter databaseAdapter) throws ReferenceNotFoundException, ReferenceConflictException {
        IntFunction<ContentKey> keyGen = i -> ContentKey.of((String[])new String[]{"k-" + i});
        IntFunction<OnRefOnly> valueGen = i -> OnRefOnly.onRef((String)("value-" + i), (String)("cid-" + i));
        BranchName branch = BranchName.of((String)"main");
        int keyCount = 128;
        AbstractManyKeys.commitPutsOnGeneratedKeys(databaseAdapter, branch, keyGen, valueGen, 128);
        Hash head = AbstractManyKeys.makeEmptyCommits(databaseAdapter, branch, 20);
        AbstractManyKeys.checkKeysAndValuesIndividually(databaseAdapter, head, keyGen, valueGen, 128);
    }

    private static void commitPutsOnGeneratedKeys(DatabaseAdapter databaseAdapter, BranchName branch, IntFunction<ContentKey> keyGen, IntFunction<OnRefOnly> valueGen, int keyCount) throws ReferenceNotFoundException, ReferenceConflictException {
        List keys = IntStream.range(0, keyCount).mapToObj(i -> {
            OnRefOnly val = (OnRefOnly)valueGen.apply(i);
            return KeyWithBytes.of((ContentKey)((ContentKey)keyGen.apply(i)), (ContentId)ContentId.of((String)val.getId()), (byte)DefaultStoreWorker.payloadForContent((Content)val), (ByteString)val.serialized());
        }).collect(Collectors.toCollection(() -> new ArrayList(keyCount)));
        databaseAdapter.commit((CommitParams)ImmutableCommitParams.builder().toBranch(branch).commitMetaSerialized(ByteString.EMPTY).addAllPuts((Iterable)keys).build());
    }

    private static Hash makeEmptyCommits(DatabaseAdapter databaseAdapter, BranchName toBranch, int commitCount) throws ReferenceNotFoundException, ReferenceConflictException {
        Preconditions.checkArgument((0 < commitCount ? 1 : 0) != 0);
        Hash head = null;
        for (int i = 0; i < commitCount; ++i) {
            head = databaseAdapter.commit((CommitParams)ImmutableCommitParams.builder().toBranch(toBranch).commitMetaSerialized(ByteString.EMPTY).build());
        }
        Preconditions.checkNotNull(head);
        return head;
    }

    private static void checkKeysAndValuesIndividually(DatabaseAdapter databaseAdapter, Hash head, IntFunction<ContentKey> keyGen, IntFunction<OnRefOnly> valueGen, int keyCount) throws ReferenceNotFoundException {
        for (int i = 0; i < keyCount; ++i) {
            ContentKey key = keyGen.apply(i);
            Map values = databaseAdapter.values(head, Collections.singletonList(key), KeyFilterPredicate.ALLOW_ALL);
            Assertions.assertThat((Map)values).extractingByKey((Object)key).extracting(ContentAndState::getRefState).isEqualTo((Object)valueGen.apply(i).serialized());
        }
    }

    public static Stream<List<String>> progressivelyManyKeyNames() {
        Random random = new Random(7L);
        return IntStream.range(1, 100).flatMap(i -> IntStream.of(i, i)).mapToObj(i -> IntStream.range(1, i).mapToObj(j -> Long.toString(random.nextLong() & Long.MAX_VALUE, 36)).collect(Collectors.toList()));
    }

    @ParameterizedTest
    @MethodSource(value={"progressivelyManyKeyNames"})
    @DisabledIfSystemProperty(named="nessie.integrationTest", matches="true", disabledReason="runs too long for integration tests, non-IT coverage's sufficient")
    void manyKeysProgressive(List<String> names, @NessieDbAdapterConfigItems(value={@NessieDbAdapterConfigItem(name="max.key.list.size", value="2048"), @NessieDbAdapterConfigItem(name="max.key.list.entity.size", value="1000000"), @NessieDbAdapterConfigItem(name="key.list.distance", value="20"), @NessieDbAdapterConfigItem(name="key.list.hash.load.factor", value="0.65")}) @NessieDbAdapter DatabaseAdapter databaseAdapter) throws Exception {
        this.testManyKeysProgressive(names, databaseAdapter);
    }

    @ParameterizedTest
    @MethodSource(value={"progressivelyManyKeyNames"})
    @DisabledIfSystemProperty(named="nessie.integrationTest", matches="true", disabledReason="runs too long for integration tests, non-IT coverage's sufficient")
    void manyKeysProgressiveSmallLists(List<String> names, @NessieDbAdapterConfigItems(value={@NessieDbAdapterConfigItem(name="max.key.list.size", value="0"), @NessieDbAdapterConfigItem(name="max.key.list.entity.size", value="0"), @NessieDbAdapterConfigItem(name="key.list.distance", value="20"), @NessieDbAdapterConfigItem(name="key.list.hash.load.factor", value="0.7")}) @NessieDbAdapter DatabaseAdapter databaseAdapter) throws Exception {
        this.testManyKeysProgressive(names, databaseAdapter);
    }

    private void testManyKeysProgressive(List<String> names, DatabaseAdapter databaseAdapter) throws Exception {
        BranchName main = BranchName.of((String)"main");
        Hash head = databaseAdapter.hashOnReference((NamedRef)main, Optional.empty());
        HashSet<ContentKey> activeKeys = new HashSet<ContentKey>();
        for (String name : names) {
            ContentKey key = ContentKey.of((String[])new String[]{name});
            head = databaseAdapter.commit((CommitParams)ImmutableCommitParams.builder().toBranch(main).commitMetaSerialized(ByteString.copyFromUtf8((String)"foo")).expectedHead(Optional.of(head)).addPuts(KeyWithBytes.of((ContentKey)key, (ContentId)ContentId.of((String)("id-" + name)), (byte)DefaultStoreWorker.payloadForContent((Content.Type)OnRefOnly.ON_REF_ONLY), (ByteString)DefaultStoreWorker.instance().toStoreOnReferenceState((Content)OnRefOnly.newOnRef((String)("c" + name))))).build());
            activeKeys.add(key);
        }
        Map values = databaseAdapter.values(head, activeKeys, KeyFilterPredicate.ALLOW_ALL);
        Assertions.assertThat(values.keySet()).containsExactlyInAnyOrderElementsOf(activeKeys);
    }

    static class ManyKeysParams {
        final int keys;
        final int commits;

        public ManyKeysParams(int keys, int commits) {
            this.keys = keys;
            this.commits = commits;
        }

        public String toString() {
            return "keys=" + this.keys + ", commits=" + this.commits;
        }
    }
}

