/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.persist.adapter.CommitParams;
import org.projectnessie.versioned.persist.adapter.ContentAndState;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitParams;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import org.projectnessie.versioned.persist.adapter.KeyListEntry;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.persist.tests.extension.NessieDbAdapter;
import org.projectnessie.versioned.persist.tests.extension.NessieDbAdapterConfigItem;
import org.projectnessie.versioned.store.DefaultStoreWorker;
import org.projectnessie.versioned.testworker.OnRefOnly;

public abstract class AbstractCommitScenarios {
    private final DatabaseAdapter databaseAdapter;

    protected AbstractCommitScenarios(DatabaseAdapter databaseAdapter) {
        this.databaseAdapter = databaseAdapter;
    }

    static Stream<RenameTable> commitRenameTableParams() {
        Stream<RenameTable> zero = Stream.of(new RenameTable(0, 0, 0, 0));
        Stream intervals = IntStream.of(19, 20, 21).boxed().flatMap(i -> Stream.of(new RenameTable((int)i, (int)i, (int)i, (int)i), new RenameTable(0, 0, 0, 0)));
        return Stream.concat(zero, intervals);
    }

    @ParameterizedTest
    @MethodSource(value={"commitRenameTableParams"})
    void commitRenameTable(RenameTable param) throws Exception {
        BranchName branch = BranchName.of((String)"main");
        ContentKey dummyKey = ContentKey.of((String[])new String[]{"dummy"});
        ContentKey oldKey = ContentKey.of((String[])new String[]{"hello-table"});
        ContentKey newKey = ContentKey.of((String[])new String[]{"new-name"});
        ContentId contentId = ContentId.of((String)"id-42");
        IntFunction<Hash> performDummyCommit = i -> {
            try {
                return this.databaseAdapter.commit((CommitParams)ImmutableCommitParams.builder().toBranch(branch).commitMetaSerialized(ByteString.copyFromUtf8((String)("dummy commit meta " + i))).addUnchanged(dummyKey).build()).getCommitHash();
            }
            catch (ReferenceConflictException | ReferenceNotFoundException e) {
                throw new RuntimeException(e);
            }
        };
        List beforeInitial = IntStream.range(0, param.setupCommits).mapToObj(performDummyCommit).collect(Collectors.toList());
        OnRefOnly initialContent = OnRefOnly.newOnRef((String)"initial commit content");
        OnRefOnly renamContent = OnRefOnly.onRef((String)"rename commit content", (String)initialContent.getId());
        byte payload = (byte)DefaultStoreWorker.payloadForContent((Content)initialContent);
        ImmutableCommitParams.Builder commit = ImmutableCommitParams.builder().toBranch(branch).commitMetaSerialized(ByteString.copyFromUtf8((String)"initial commit meta")).addPuts(KeyWithBytes.of((ContentKey)oldKey, (ContentId)contentId, (byte)payload, (ByteString)DefaultStoreWorker.instance().toStoreOnReferenceState((Content)initialContent)));
        Hash hashInitial = this.databaseAdapter.commit((CommitParams)commit.build()).getCommitHash();
        List beforeRename = IntStream.range(0, param.afterInitialCommits).mapToObj(performDummyCommit).collect(Collectors.toList());
        commit = ImmutableCommitParams.builder().toBranch(branch).commitMetaSerialized(ByteString.copyFromUtf8((String)"rename table")).addDeletes(oldKey).addPuts(KeyWithBytes.of((ContentKey)newKey, (ContentId)contentId, (byte)payload, (ByteString)DefaultStoreWorker.instance().toStoreOnReferenceState((Content)renamContent)));
        Hash hashRename = this.databaseAdapter.commit((CommitParams)commit.build()).getCommitHash();
        List beforeDelete = IntStream.range(0, param.afterRenameCommits).mapToObj(performDummyCommit).collect(Collectors.toList());
        commit = ImmutableCommitParams.builder().toBranch(branch).commitMetaSerialized(ByteString.copyFromUtf8((String)"delete table")).addDeletes(newKey);
        Hash hashDelete = this.databaseAdapter.commit((CommitParams)commit.build()).getCommitHash();
        List afterDelete = IntStream.range(0, param.afterDeleteCommits).mapToObj(performDummyCommit).collect(Collectors.toList());
        int expectedCommitCount = 1;
        expectedCommitCount = this.renameCommitVerify(beforeInitial.stream(), expectedCommitCount, keys -> Assertions.assertThat((Stream)keys).isEmpty());
        expectedCommitCount = this.renameCommitVerify(Stream.concat(Stream.of(hashInitial), beforeRename.stream()), expectedCommitCount, keys -> Assertions.assertThat((Stream)keys).containsExactly((Object[])new KeyListEntry[]{KeyListEntry.of((ContentKey)oldKey, (ContentId)contentId, (byte)payload, (Hash)hashInitial)}));
        expectedCommitCount = this.renameCommitVerify(Stream.concat(Stream.of(hashRename), beforeDelete.stream()), expectedCommitCount, keys -> Assertions.assertThat((Stream)keys).containsExactly((Object[])new KeyListEntry[]{KeyListEntry.of((ContentKey)newKey, (ContentId)contentId, (byte)payload, (Hash)hashRename)}));
        expectedCommitCount = this.renameCommitVerify(Stream.concat(Stream.of(hashDelete), afterDelete.stream()), expectedCommitCount, keys -> Assertions.assertThat((Stream)keys).isEmpty());
        Assertions.assertThat((int)(expectedCommitCount - 1)).isEqualTo(param.setupCommits + 1 + param.afterInitialCommits + 1 + param.afterRenameCommits + 1 + param.afterDeleteCommits);
    }

    private int renameCommitVerify(Stream<Hash> hashes, int expectedCommitCount, Consumer<Stream<KeyListEntry>> keysStreamAssert) throws Exception {
        for (Hash hash : hashes.collect(Collectors.toList())) {
            try (Stream keys = this.databaseAdapter.keys(hash, KeyFilterPredicate.ALLOW_ALL);){
                keysStreamAssert.accept(keys);
            }
            Stream log = this.databaseAdapter.commitLog(hash);
            try {
                Assertions.assertThat((Stream)log).hasSize(expectedCommitCount++);
            }
            finally {
                if (log == null) continue;
                log.close();
            }
        }
        return expectedCommitCount;
    }

    @ParameterizedTest
    @ValueSource(ints={1, 3, 5})
    void commit(int tablesPerCommit) throws Exception {
        BranchName branch = BranchName.of((String)"main");
        ArrayList<ContentKey> keys = new ArrayList<ContentKey>(tablesPerCommit);
        ImmutableCommitParams.Builder commit = ImmutableCommitParams.builder().toBranch(branch).commitMetaSerialized(ByteString.copyFromUtf8((String)"initial commit meta"));
        for (int i = 0; i < tablesPerCommit; ++i) {
            ContentKey key = ContentKey.of((String[])new String[]{"my-table-num" + i});
            keys.add(key);
            String cid = "id-" + i;
            OnRefOnly c = OnRefOnly.onRef((String)"initial commit content", (String)cid);
            commit.addPuts(KeyWithBytes.of((ContentKey)key, (ContentId)ContentId.of((String)cid), (byte)((byte)DefaultStoreWorker.payloadForContent((Content)c)), (ByteString)DefaultStoreWorker.instance().toStoreOnReferenceState((Content)c)));
        }
        Hash head = this.databaseAdapter.commit((CommitParams)commit.build()).getCommitHash();
        for (int commitNum = 0; commitNum < 3; ++commitNum) {
            commit = ImmutableCommitParams.builder().toBranch(branch).commitMetaSerialized(ByteString.copyFromUtf8((String)"initial commit meta"));
            for (int i = 0; i < tablesPerCommit; ++i) {
                String cid = "id-" + i;
                OnRefOnly newContent = OnRefOnly.onRef((String)"branch value", (String)cid);
                commit.addPuts(KeyWithBytes.of((ContentKey)((ContentKey)keys.get(i)), (ContentId)ContentId.of((String)cid), (byte)((byte)DefaultStoreWorker.payloadForContent((Content)newContent)), (ByteString)DefaultStoreWorker.instance().toStoreOnReferenceState((Content)newContent)));
            }
            Hash newHead = this.databaseAdapter.commit((CommitParams)commit.build()).getCommitHash();
            Assertions.assertThat((Object)newHead).isNotEqualTo((Object)head);
            head = newHead;
        }
    }

    @Test
    void duplicateKeys() {
        BranchName branch = BranchName.of((String)"main");
        ContentKey key = ContentKey.of((String[])new String[]{"my.awesome.table"});
        ContentId contentsId = ContentId.of((String)"cid");
        OnRefOnly tableRef = OnRefOnly.newOnRef((String)"table ref state");
        ByteString tableRefState = tableRef.serialized();
        OnRefOnly noNo = OnRefOnly.onRef((String)"no no", (String)contentsId.getId());
        KeyWithBytes createPut1 = KeyWithBytes.of((ContentKey)key, (ContentId)contentsId, (byte)((byte)DefaultStoreWorker.payloadForContent((Content)noNo)), (ByteString)noNo.serialized());
        KeyWithBytes createPut2 = KeyWithBytes.of((ContentKey)key, (ContentId)contentsId, (byte)((byte)DefaultStoreWorker.payloadForContent((Content)tableRef)), (ByteString)tableRefState);
        ImmutableCommitParams.Builder commit1 = ImmutableCommitParams.builder().toBranch(branch).commitMetaSerialized(ByteString.copyFromUtf8((String)"initial")).addPuts(createPut1).addPuts(createPut2);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.databaseAdapter.commit((CommitParams)commit1.build())).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(key.toString());
        ImmutableCommitParams.Builder commit2 = ImmutableCommitParams.builder().toBranch(branch).commitMetaSerialized(ByteString.copyFromUtf8((String)"initial")).addDeletes(key).addPuts(createPut2);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.databaseAdapter.commit((CommitParams)commit2.build())).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(key.toString());
        ImmutableCommitParams.Builder commit3 = ImmutableCommitParams.builder().toBranch(branch).commitMetaSerialized(ByteString.copyFromUtf8((String)"initial")).addDeletes(key).addUnchanged(key);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.databaseAdapter.commit((CommitParams)commit3.build())).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(key.toString());
        ImmutableCommitParams.Builder commit4 = ImmutableCommitParams.builder().toBranch(branch).commitMetaSerialized(ByteString.copyFromUtf8((String)"initial")).addUnchanged(key).addPuts(createPut2);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.databaseAdapter.commit((CommitParams)commit4.build())).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(key.toString());
    }

    @Test
    public void smallEmbeddedKeyLists(@NessieDbAdapterConfigItem(name="key.list.distance", value="1") @NessieDbAdapter DatabaseAdapter mine) throws Exception {
        BranchName branchName = BranchName.of((String)"foo");
        Hash head = mine.noAncestorHash();
        mine.create((NamedRef)branchName, head);
        ContentKey keyNation = ContentKey.of((String[])new String[]{"tpch-nation"});
        ContentKey keyRegion = ContentKey.of((String[])new String[]{"tpch-region"});
        ContentId idNation = ContentId.of((String)"id-nation");
        ContentId idRegion = ContentId.of((String)"id-region");
        OnRefOnly onRefNation = OnRefOnly.onRef((String)"nation", (String)idNation.getId());
        OnRefOnly onRefRegion = OnRefOnly.onRef((String)"region", (String)idRegion.getId());
        ByteString stateNation = DefaultStoreWorker.instance().toStoreOnReferenceState((Content)onRefNation);
        ByteString stateRegion = DefaultStoreWorker.instance().toStoreOnReferenceState((Content)onRefRegion);
        Hash commitNation = mine.commit((CommitParams)ImmutableCommitParams.builder().toBranch(branchName).expectedHead(Optional.of(head)).commitMetaSerialized(ByteString.copyFromUtf8((String)"commit nation")).addPuts(KeyWithBytes.of((ContentKey)keyNation, (ContentId)idNation, (byte)((byte)DefaultStoreWorker.payloadForContent((Content)onRefNation)), (ByteString)stateNation)).build()).getCommitHash();
        Hash commitRegion = mine.commit((CommitParams)ImmutableCommitParams.builder().toBranch(branchName).expectedHead(Optional.of(commitNation)).commitMetaSerialized(ByteString.copyFromUtf8((String)"commit region")).addPuts(KeyWithBytes.of((ContentKey)keyRegion, (ContentId)idRegion, (byte)((byte)DefaultStoreWorker.payloadForContent((Content)onRefRegion)), (ByteString)stateRegion)).build()).getCommitHash();
        List<ContentKey> nonExistentKey = Collections.singletonList(ContentKey.of((String[])new String[]{"non_existent"}));
        Assertions.assertThat((Map)mine.values(commitNation, nonExistentKey, KeyFilterPredicate.ALLOW_ALL)).isEmpty();
        Assertions.assertThat((Map)mine.values(commitNation, Collections.singletonList(keyNation), KeyFilterPredicate.ALLOW_ALL)).containsEntry((Object)keyNation, (Object)ContentAndState.of((byte)((byte)DefaultStoreWorker.payloadForContent((Content)onRefNation)), (ByteString)stateNation));
        Assertions.assertThat((Map)mine.values(commitNation, Collections.singletonList(keyRegion), KeyFilterPredicate.ALLOW_ALL)).isEmpty();
        Assertions.assertThat((Map)mine.values(commitRegion, Collections.singletonList(keyNation), KeyFilterPredicate.ALLOW_ALL)).containsEntry((Object)keyNation, (Object)ContentAndState.of((byte)((byte)DefaultStoreWorker.payloadForContent((Content)onRefNation)), (ByteString)stateNation));
        Assertions.assertThat((Map)mine.values(commitNation, nonExistentKey, KeyFilterPredicate.ALLOW_ALL)).isEmpty();
        Assertions.assertThat((Map)mine.values(commitRegion, nonExistentKey, KeyFilterPredicate.ALLOW_ALL)).isEmpty();
        ((MapAssert)Assertions.assertThat((Map)mine.values(commitRegion, Arrays.asList(keyNation, keyRegion), KeyFilterPredicate.ALLOW_ALL)).containsEntry((Object)keyNation, (Object)ContentAndState.of((byte)((byte)DefaultStoreWorker.payloadForContent((Content)onRefNation)), (ByteString)stateNation))).containsEntry((Object)keyRegion, (Object)ContentAndState.of((byte)((byte)DefaultStoreWorker.payloadForContent((Content)onRefRegion)), (ByteString)stateRegion));
    }

    static class RenameTable {
        final int setupCommits;
        final int afterInitialCommits;
        final int afterRenameCommits;
        final int afterDeleteCommits;

        RenameTable(int setupCommits, int afterInitialCommits, int afterRenameCommits, int afterDeleteCommits) {
            this.setupCommits = setupCommits;
            this.afterInitialCommits = afterInitialCommits;
            this.afterRenameCommits = afterRenameCommits;
            this.afterDeleteCommits = afterDeleteCommits;
        }

        public String toString() {
            return "setupCommits=" + this.setupCommits + ", afterInitialCommits=" + this.afterInitialCommits + ", afterRenameCommits=" + this.afterRenameCommits + ", afterDeleteCommits=" + this.afterDeleteCommits;
        }
    }
}

