/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.MetadataRewriter;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.CommitParams;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitParams;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.persist.adapter.MergeParams;
import org.projectnessie.versioned.persist.adapter.TransplantParams;
import org.projectnessie.versioned.persist.adapter.events.AdapterEvent;
import org.projectnessie.versioned.persist.adapter.events.AdapterEventConsumer;
import org.projectnessie.versioned.persist.adapter.events.CommitEvent;
import org.projectnessie.versioned.persist.adapter.events.CommittingEvent;
import org.projectnessie.versioned.persist.adapter.events.MergeEvent;
import org.projectnessie.versioned.persist.adapter.events.OperationType;
import org.projectnessie.versioned.persist.adapter.events.ReferenceAssignedEvent;
import org.projectnessie.versioned.persist.adapter.events.ReferenceCreatedEvent;
import org.projectnessie.versioned.persist.adapter.events.ReferenceDeletedEvent;
import org.projectnessie.versioned.persist.adapter.events.ReferenceEvent;
import org.projectnessie.versioned.persist.adapter.events.RepositoryErasedEvent;
import org.projectnessie.versioned.persist.adapter.events.RepositoryInitializedEvent;
import org.projectnessie.versioned.persist.adapter.events.TransplantEvent;
import org.projectnessie.versioned.persist.adapter.spi.AbstractDatabaseAdapter;
import org.projectnessie.versioned.persist.tests.extension.NessieDbAdapter;
import org.projectnessie.versioned.store.DefaultStoreWorker;
import org.projectnessie.versioned.testworker.OnRefOnly;

public abstract class AbstractEvents {
    protected AbstractEvents() {
    }

    @Test
    public void eventRepoInit(@NessieDbAdapter(initializeRepo=false, eventConsumer=EventCollector.class) AbstractDatabaseAdapter<?, ?> adapter) {
        EventCollector events = (EventCollector)adapter.getEventConsumer();
        adapter.initializeRepo("main");
        Assertions.assertThat(events.events).isEmpty();
        adapter.eraseRepo();
        ((ObjectAssert)((ObjectAssert)((ListAssert)Assertions.assertThat(events.events).hasSize(1)).last()).asInstanceOf(InstanceOfAssertFactories.type(RepositoryErasedEvent.class))).extracting(RepositoryErasedEvent::getOperationType).isEqualTo((Object)OperationType.REPOSITORY_ERASED);
        events.events.clear();
        adapter.initializeRepo("main");
        ((ListAssert)Assertions.assertThat(events.events).asInstanceOf(InstanceOfAssertFactories.list(AdapterEvent.class))).satisfiesExactly(new ThrowingConsumer[]{repoInit -> ((ObjectAssert)Assertions.assertThat((Object)repoInit).asInstanceOf(InstanceOfAssertFactories.type(RepositoryInitializedEvent.class))).extracting(new Function[]{RepositoryInitializedEvent::getOperationType, RepositoryInitializedEvent::getDefaultBranch}).containsExactly(new Object[]{OperationType.REPOSITORY_INITIALIZED, "main"}), createRef -> ((ObjectAssert)Assertions.assertThat((Object)createRef).asInstanceOf(InstanceOfAssertFactories.type(ReferenceCreatedEvent.class))).extracting(new Function[]{ReferenceCreatedEvent::getOperationType, ReferenceEvent::getCurrentHash, ReferenceEvent::getRef}).containsExactly(new Object[]{OperationType.CRETE_REF, adapter.noAncestorHash(), BranchName.of((String)"main")})});
    }

    @Test
    public void eventCreateRef(@NessieDbAdapter(initializeRepo=false, eventConsumer=EventCollector.class) AbstractDatabaseAdapter<?, ?> adapter) throws Exception {
        EventCollector events = (EventCollector)adapter.getEventConsumer();
        BranchName branch = BranchName.of((String)"events-create");
        adapter.create((NamedRef)branch, adapter.noAncestorHash());
        ((ObjectAssert)((ObjectAssert)((ListAssert)Assertions.assertThat(events.events).hasSize(1)).last()).asInstanceOf(InstanceOfAssertFactories.type(ReferenceCreatedEvent.class))).extracting(new Function[]{ReferenceCreatedEvent::getOperationType, ReferenceEvent::getCurrentHash, ReferenceEvent::getRef}).containsExactly(new Object[]{OperationType.CRETE_REF, adapter.noAncestorHash(), branch});
    }

    @Test
    public void eventDeleteRef(@NessieDbAdapter(initializeRepo=false, eventConsumer=EventCollector.class) AbstractDatabaseAdapter<?, ?> adapter) throws Exception {
        EventCollector events = (EventCollector)adapter.getEventConsumer();
        BranchName branch = BranchName.of((String)"events-delete");
        adapter.create((NamedRef)branch, adapter.noAncestorHash());
        events.events.clear();
        adapter.delete((NamedRef)branch, Optional.empty());
        ((ObjectAssert)((ObjectAssert)((ListAssert)Assertions.assertThat(events.events).hasSize(1)).last()).asInstanceOf(InstanceOfAssertFactories.type(ReferenceDeletedEvent.class))).extracting(new Function[]{ReferenceDeletedEvent::getOperationType, ReferenceEvent::getCurrentHash, ReferenceEvent::getRef}).containsExactly(new Object[]{OperationType.DELETE_REF, adapter.noAncestorHash(), branch});
    }

    @Test
    public void eventAssignRef(@NessieDbAdapter(initializeRepo=false, eventConsumer=EventCollector.class) AbstractDatabaseAdapter<?, ?> adapter) throws Exception {
        EventCollector events = (EventCollector)adapter.getEventConsumer();
        BranchName branch = BranchName.of((String)"events-assign");
        adapter.create((NamedRef)branch, adapter.noAncestorHash());
        KeyWithBytes put = KeyWithBytes.of((ContentKey)ContentKey.of((String[])new String[]{"one-two"}), (ContentId)ContentId.of((String)"cid-events-assign"), (byte)((byte)DefaultStoreWorker.payloadForContent((Content.Type)OnRefOnly.ON_REF_ONLY)), (ByteString)DefaultStoreWorker.instance().toStoreOnReferenceState((Content)OnRefOnly.onRef((String)"foo", (String)"cid-events-assign")));
        ByteString meta = ByteString.copyFromUtf8((String)"foo bar baz");
        Hash committed = adapter.commit((CommitParams)ImmutableCommitParams.builder().toBranch(branch).commitMetaSerialized(meta).addPuts(put).build()).getCommitHash();
        events.events.clear();
        adapter.assign((NamedRef)branch, Optional.empty(), adapter.noAncestorHash());
        ((ObjectAssert)((ObjectAssert)((ListAssert)Assertions.assertThat(events.events).hasSize(1)).last()).asInstanceOf(InstanceOfAssertFactories.type(ReferenceAssignedEvent.class))).extracting(new Function[]{ReferenceAssignedEvent::getOperationType, ReferenceEvent::getCurrentHash, ReferenceAssignedEvent::getPreviousHash, ReferenceEvent::getRef}).containsExactly(new Object[]{OperationType.ASSIGN_REF, adapter.noAncestorHash(), committed, branch});
    }

    @Test
    public void eventCommit(@NessieDbAdapter(initializeRepo=false, eventConsumer=EventCollector.class) AbstractDatabaseAdapter<?, ?> adapter) throws Exception {
        EventCollector events = (EventCollector)adapter.getEventConsumer();
        BranchName branch = BranchName.of((String)"events-commit");
        adapter.create((NamedRef)branch, adapter.noAncestorHash());
        events.events.clear();
        KeyWithBytes put = KeyWithBytes.of((ContentKey)ContentKey.of((String[])new String[]{"one-two"}), (ContentId)ContentId.of((String)"cid-events-commit"), (byte)((byte)DefaultStoreWorker.payloadForContent((Content.Type)OnRefOnly.ON_REF_ONLY)), (ByteString)DefaultStoreWorker.instance().toStoreOnReferenceState((Content)OnRefOnly.onRef((String)"foo", (String)"cid-events-commit")));
        ByteString meta = ByteString.copyFromUtf8((String)"foo bar baz");
        Hash committed = adapter.commit((CommitParams)ImmutableCommitParams.builder().toBranch(branch).commitMetaSerialized(meta).addPuts(put).build()).getCommitHash();
        ((ObjectAssert)((ObjectAssert)((ListAssert)Assertions.assertThat(events.events).hasSize(1)).last()).asInstanceOf(InstanceOfAssertFactories.type(CommitEvent.class))).satisfies(new ThrowingConsumer[]{commit -> Assertions.assertThat((Object)commit).extracting(new Function[]{CommitEvent::getOperationType, CommittingEvent::getHash, CommittingEvent::getPreviousHash, CommittingEvent::getBranch}).containsExactly(new Object[]{OperationType.COMMIT, committed, adapter.noAncestorHash(), branch}), commit -> ((ObjectAssert)((ListAssert)Assertions.assertThat((List)commit.getCommits()).hasSize(1)).last()).extracting(new Function[]{CommitLogEntry::getHash, CommitLogEntry::getPuts, CommitLogEntry::getMetadata}).containsExactly(new Object[]{committed, Collections.singletonList(put), meta})});
    }

    @Test
    public void eventMerge(@NessieDbAdapter(initializeRepo=false, eventConsumer=EventCollector.class) AbstractDatabaseAdapter<?, ?> adapter) throws Exception {
        EventCollector events = (EventCollector)adapter.getEventConsumer();
        BranchName main = BranchName.of((String)"main");
        KeyWithBytes put = KeyWithBytes.of((ContentKey)ContentKey.of((String[])new String[]{"one-two"}), (ContentId)ContentId.of((String)"cid-events-merge"), (byte)((byte)DefaultStoreWorker.payloadForContent((Content.Type)OnRefOnly.ON_REF_ONLY)), (ByteString)DefaultStoreWorker.instance().toStoreOnReferenceState((Content)OnRefOnly.onRef((String)"foo", (String)"cid-events-merge")));
        ByteString meta = ByteString.copyFromUtf8((String)"merge me");
        BranchName source = BranchName.of((String)"events-merge");
        adapter.create((NamedRef)source, adapter.noAncestorHash());
        Hash committed = adapter.commit((CommitParams)ImmutableCommitParams.builder().toBranch(source).commitMetaSerialized(meta).addPuts(put).build()).getCommitHash();
        events.events.clear();
        MetadataRewriter<ByteString> updater = AbstractEvents.createMetadataUpdater();
        MergeResult mergeResult = adapter.merge(((MergeParams.Builder)((MergeParams.Builder)((MergeParams.Builder)MergeParams.builder().mergeFromHash(committed).fromRef((NamedRef)source)).toBranch(main)).updateCommitMetadata(updater)).build());
        ((ObjectAssert)((ObjectAssert)((ListAssert)Assertions.assertThat(events.events).hasSize(1)).last()).asInstanceOf(InstanceOfAssertFactories.type(MergeEvent.class))).satisfies(new ThrowingConsumer[]{merge -> Assertions.assertThat((Object)merge).extracting(new Function[]{MergeEvent::getOperationType, CommittingEvent::getHash, CommittingEvent::getPreviousHash, CommittingEvent::getBranch}).containsExactly(new Object[]{OperationType.MERGE, mergeResult.getResultantTargetHash(), adapter.noAncestorHash(), main}), merge -> ((ObjectAssert)((ListAssert)Assertions.assertThat((List)merge.getCommits()).hasSize(1)).last()).extracting(new Function[]{CommitLogEntry::getHash, CommitLogEntry::getPuts, CommitLogEntry::getMetadata}).containsExactly(new Object[]{mergeResult.getResultantTargetHash(), Collections.singletonList(put), updater.rewriteSingle((Object)meta)})});
    }

    @Test
    public void eventTransplant(@NessieDbAdapter(initializeRepo=false, eventConsumer=EventCollector.class) AbstractDatabaseAdapter<?, ?> adapter) throws Exception {
        EventCollector events = (EventCollector)adapter.getEventConsumer();
        BranchName main = BranchName.of((String)"main");
        KeyWithBytes put = KeyWithBytes.of((ContentKey)ContentKey.of((String[])new String[]{"one-two"}), (ContentId)ContentId.of((String)"cid-events-transplant"), (byte)((byte)DefaultStoreWorker.payloadForContent((Content.Type)OnRefOnly.ON_REF_ONLY)), (ByteString)DefaultStoreWorker.instance().toStoreOnReferenceState((Content)OnRefOnly.onRef((String)"foo", (String)"cid-events-transplant")));
        ByteString meta = ByteString.copyFromUtf8((String)"transplant me");
        BranchName source = BranchName.of((String)"events-transplant");
        adapter.create((NamedRef)source, adapter.noAncestorHash());
        Hash committed = adapter.commit((CommitParams)ImmutableCommitParams.builder().toBranch(source).commitMetaSerialized(meta).addPuts(put).build()).getCommitHash();
        events.events.clear();
        MetadataRewriter<ByteString> updater = AbstractEvents.createMetadataUpdater();
        MergeResult mergeResult = adapter.transplant(((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)TransplantParams.builder().addSequenceToTransplant(new Hash[]{committed}).updateCommitMetadata(updater)).fromRef((NamedRef)source)).toBranch(main)).build());
        ((ObjectAssert)((ObjectAssert)((ListAssert)Assertions.assertThat(events.events).hasSize(1)).last()).asInstanceOf(InstanceOfAssertFactories.type(TransplantEvent.class))).satisfies(new ThrowingConsumer[]{transplant -> Assertions.assertThat((Object)transplant).extracting(new Function[]{TransplantEvent::getOperationType, CommittingEvent::getHash, CommittingEvent::getPreviousHash, CommittingEvent::getBranch}).containsExactly(new Object[]{OperationType.TRANSPLANT, mergeResult.getResultantTargetHash(), adapter.noAncestorHash(), main}), tranplant -> ((ObjectAssert)((ListAssert)Assertions.assertThat((List)tranplant.getCommits()).hasSize(1)).last()).extracting(new Function[]{CommitLogEntry::getHash, CommitLogEntry::getPuts, CommitLogEntry::getMetadata}).containsExactly(new Object[]{mergeResult.getResultantTargetHash(), Collections.singletonList(put), updater.rewriteSingle((Object)meta)})});
    }

    private static MetadataRewriter<ByteString> createMetadataUpdater() {
        return new MetadataRewriter<ByteString>(){

            public ByteString rewriteSingle(ByteString metadata) {
                return ByteString.copyFromUtf8((String)(metadata.toStringUtf8() + " updated"));
            }

            public ByteString squash(List<ByteString> metadata) {
                return this.rewriteSingle(metadata.get(0));
            }
        };
    }

    static class EventCollector
    implements AdapterEventConsumer {
        final List<AdapterEvent> events = new ArrayList<AdapterEvent>();

        EventCollector() {
        }

        public void accept(AdapterEvent event) {
            this.events.add(event);
        }
    }
}

