/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tests;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.projectnessie.model.Conflict;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ImmutableKeyDetails;
import org.projectnessie.versioned.ImmutableMergeResult;
import org.projectnessie.versioned.MergeConflictException;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.MetadataRewriter;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.ResultType;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.CommitParams;
import org.projectnessie.versioned.persist.adapter.ContentAndState;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitParams;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.persist.adapter.MergeParams;
import org.projectnessie.versioned.persist.adapter.MetadataRewriteParams;
import org.projectnessie.versioned.persist.adapter.TransplantParams;
import org.projectnessie.versioned.store.DefaultStoreWorker;
import org.projectnessie.versioned.testworker.OnRefOnly;

public abstract class AbstractMergeTransplant {
    private final DatabaseAdapter databaseAdapter;

    protected AbstractMergeTransplant(DatabaseAdapter databaseAdapter) {
        this.databaseAdapter = databaseAdapter;
    }

    @ParameterizedTest
    @CsvSource(value={"3,true", "3,false", "20,true", "20,false", "21,true", "21,false"})
    void merge(int numCommits, boolean keepIndividualCommits) throws Exception {
        AtomicInteger unifier = new AtomicInteger();
        MetadataRewriter<ByteString> metadataUpdater = AbstractMergeTransplant.createMetadataUpdater(unifier, "merged");
        BranchName sourceBranch = BranchName.of((String)"branch");
        this.mergeTransplant(numCommits, (commitHashes, i) -> ((MergeParams.Builder)((MergeParams.Builder)((MergeParams.Builder)MergeParams.builder().fromRef((NamedRef)sourceBranch)).updateCommitMetadata(metadataUpdater)).keepIndividualCommits(keepIndividualCommits)).mergeFromHash(commitHashes[i]), params -> this.databaseAdapter.merge(params.build()), keepIndividualCommits, true);
        BranchName branch2 = BranchName.of((String)"branch2");
        this.databaseAdapter.create((NamedRef)branch2, this.databaseAdapter.hashOnReference((NamedRef)sourceBranch, Optional.empty()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.databaseAdapter.merge(((MergeParams.Builder)((MergeParams.Builder)((MergeParams.Builder)((MergeParams.Builder)MergeParams.builder().fromRef((NamedRef)sourceBranch)).toBranch(branch2)).mergeFromHash(this.databaseAdapter.hashOnReference((NamedRef)sourceBranch, Optional.empty())).updateCommitMetadata(metadataUpdater)).keepIndividualCommits(keepIndividualCommits)).build())).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("No hashes to merge from '");
    }

    private static MetadataRewriter<ByteString> createMetadataUpdater(final AtomicInteger unifier, final String suffix) {
        return new MetadataRewriter<ByteString>(){

            public ByteString rewriteSingle(ByteString metadata) {
                return ByteString.copyFromUtf8((String)(metadata.toStringUtf8() + " " + suffix + " " + unifier.getAndIncrement()));
            }

            public ByteString squash(List<ByteString> metadata) {
                return ByteString.copyFromUtf8((String)(metadata.stream().map(ByteString::toStringUtf8).collect(Collectors.joining(";")) + " " + suffix + " " + unifier.getAndIncrement()));
            }
        };
    }

    @ParameterizedTest
    @CsvSource(value={"3,true", "3,false", "20,true", "20,false", "21,true", "21,false"})
    void transplant(int numCommits, boolean keepIndividualCommits) throws Exception {
        AtomicInteger unifier = new AtomicInteger();
        MetadataRewriter<ByteString> metadataUpdater = AbstractMergeTransplant.createMetadataUpdater(unifier, "transplanted");
        BranchName sourceBranch = BranchName.of((String)"branch");
        Hash[] commits = this.mergeTransplant(numCommits, (commitHashes, i) -> ((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)TransplantParams.builder().fromRef((NamedRef)sourceBranch)).updateCommitMetadata(metadataUpdater)).keepIndividualCommits(keepIndividualCommits)).sequenceToTransplant(Arrays.asList(commitHashes).subList(0, i + 1)), params -> this.databaseAdapter.transplant(params.build()), keepIndividualCommits, false);
        BranchName conflict = BranchName.of((String)"conflict");
        Hash noConflictHead = this.databaseAdapter.hashOnReference((NamedRef)conflict, Optional.empty());
        Hash transplanted = this.databaseAdapter.transplant(((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)TransplantParams.builder().fromRef((NamedRef)sourceBranch)).toBranch(conflict)).expectedHead(Optional.of(noConflictHead))).addSequenceToTransplant(commits).updateCommitMetadata(metadataUpdater)).keepIndividualCommits(keepIndividualCommits)).build()).getResultantTargetHash();
        int offset = unifier.get();
        this.checkTransplantedCommits(keepIndividualCommits, commits, transplanted, offset);
        transplanted = this.databaseAdapter.transplant(((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)TransplantParams.builder().fromRef((NamedRef)sourceBranch)).toBranch(conflict)).addSequenceToTransplant(commits).updateCommitMetadata(metadataUpdater)).keepIndividualCommits(keepIndividualCommits)).build()).getResultantTargetHash();
        offset = unifier.get();
        this.checkTransplantedCommits(keepIndividualCommits, commits, transplanted, offset);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.databaseAdapter.transplant(((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)((TransplantParams.Builder)TransplantParams.builder().fromRef((NamedRef)sourceBranch)).toBranch(conflict)).updateCommitMetadata(metadataUpdater)).keepIndividualCommits(keepIndividualCommits)).build())).isInstanceOf(IllegalArgumentException.class)).hasMessage("No hashes to transplant given.");
    }

    private void checkTransplantedCommits(boolean keepIndividualCommits, Hash[] commits, Hash transplanted, int offset) throws ReferenceNotFoundException {
        if (keepIndividualCommits) {
            try (Stream<CommitLogEntry> log = this.databaseAdapter.commitLog(transplanted).limit(commits.length);){
                AtomicInteger testOffset = new AtomicInteger(offset);
                Assertions.assertThat(log.map(CommitLogEntry::getMetadata).map(ByteString::toStringUtf8)).containsExactlyElementsOf((Iterable)IntStream.range(0, commits.length).map(i -> commits.length - i - 1).mapToObj(i -> "commit " + i + " transplanted " + testOffset.decrementAndGet()).collect(Collectors.toList()));
            }
        }
        try (Stream log = this.databaseAdapter.commitLog(transplanted).limit(1L);){
            AtomicInteger testOffset = new AtomicInteger(offset);
            ((ObjectAssert)Assertions.assertThat(log).first()).extracting(CommitLogEntry::getMetadata).extracting(ByteString::toStringUtf8).asString().contains(new CharSequence[]{IntStream.range(0, commits.length).mapToObj(i -> "commit " + i).collect(Collectors.joining(";")) + " transplanted " + testOffset.decrementAndGet()});
        }
    }

    private <PARAMS_BUILDER extends MetadataRewriteParams.Builder<PARAMS_BUILDER>> Hash[] mergeTransplant(int numCommits, BiFunction<Hash[], Integer, PARAMS_BUILDER> configurer, MergeOrTransplant<PARAMS_BUILDER> mergeOrTransplant, boolean individualCommits, boolean merge) throws Exception {
        List<CommitLogEntry> commitLogEntries;
        BranchName main = BranchName.of((String)"main");
        BranchName branch = BranchName.of((String)"branch");
        this.databaseAdapter.create((NamedRef)branch, this.databaseAdapter.hashOnReference((NamedRef)main, Optional.empty()));
        HashMap<ContentKey, ContentAndState> keysAndValue = new HashMap<ContentKey, ContentAndState>();
        Hash[] commits = new Hash[numCommits];
        for (int i = 0; i < commits.length; ++i) {
            ImmutableCommitParams.Builder commit = ImmutableCommitParams.builder().toBranch(branch).commitMetaSerialized(ByteString.copyFromUtf8((String)("commit " + i)));
            for (int k = 0; k < 3; ++k) {
                ContentKey key = ContentKey.of((String[])new String[]{"key-" + k});
                OnRefOnly value = OnRefOnly.newOnRef((String)("value " + i + " for " + k));
                ByteString onRef = DefaultStoreWorker.instance().toStoreOnReferenceState((Content)value);
                keysAndValue.put(key, ContentAndState.of((byte)((byte)DefaultStoreWorker.payloadForContent((Content)value)), (ByteString)onRef));
                commit.addPuts(KeyWithBytes.of((ContentKey)key, (ContentId)ContentId.of((String)("C" + k)), (byte)((byte)DefaultStoreWorker.payloadForContent((Content)value)), (ByteString)onRef));
            }
            commits[i] = this.databaseAdapter.commit((CommitParams)commit.build()).getCommitHash();
        }
        try (Stream log = this.databaseAdapter.commitLog(commits[commits.length - 1]).limit(commits.length);){
            commitLogEntries = log.collect(Collectors.toList());
        }
        Hash mainHead = this.databaseAdapter.hashOnReference((NamedRef)main, Optional.empty());
        Hash targetHead = this.mergeTransplantSuccess(configurer, mergeOrTransplant, merge, commits, commitLogEntries, mainHead, individualCommits);
        Assertions.assertThat((Map)this.databaseAdapter.values(targetHead, keysAndValue.keySet(), KeyFilterPredicate.ALLOW_ALL)).isEqualTo(keysAndValue);
        this.mergeTransplantConflict(configurer, mergeOrTransplant, merge, commits, commitLogEntries, mainHead);
        return commits;
    }

    private <PARAMS_BUILDER extends MetadataRewriteParams.Builder<PARAMS_BUILDER>> Hash mergeTransplantSuccess(BiFunction<Hash[], Integer, PARAMS_BUILDER> configurer, MergeOrTransplant<PARAMS_BUILDER> mergeOrTransplant, boolean merge, Hash[] commits, List<CommitLogEntry> commitLogEntries, Hash mainHead, boolean individualCommits) throws Exception {
        Hash targetHead = null;
        for (int i = 0; i < commits.length; ++i) {
            BranchName target = BranchName.of((String)("merge-transplant-" + i));
            this.databaseAdapter.create((NamedRef)target, mainHead);
            List<CommitLogEntry> expectedSourceCommits = commitLogEntries.subList(commits.length - 1 - i, commits.length);
            ImmutableMergeResult.Builder<CommitLogEntry> expectedMergeResult = AbstractMergeTransplant.successExpectedMergeResult(merge, target, mainHead, expectedSourceCommits);
            MergeResult<CommitLogEntry> mergeResult = mergeOrTransplant.apply((MetadataRewriteParams.Builder)((MetadataRewriteParams.Builder)((MetadataRewriteParams.Builder)((MetadataRewriteParams.Builder)configurer.apply(commits, i)).toBranch(target)).expectedHead(Optional.empty())).isDryRun(true));
            BranchName source = BranchName.of((String)"branch");
            Assertions.assertThat(mergeResult).isEqualTo((Object)expectedMergeResult.resultType(merge ? ResultType.MERGE : ResultType.TRANSPLANT).sourceRef((NamedRef)source).targetBranch(target).resultantTargetHash(mainHead).createdCommits((Iterable)mergeResult.getCreatedCommits()).build());
            mergeResult = mergeOrTransplant.apply((MetadataRewriteParams.Builder)((MetadataRewriteParams.Builder)((MetadataRewriteParams.Builder)configurer.apply(commits, i)).toBranch(target)).expectedHead(Optional.empty()));
            targetHead = this.databaseAdapter.hashOnReference((NamedRef)target, Optional.empty());
            Assertions.assertThat(mergeResult).isEqualTo((Object)expectedMergeResult.resultType(merge ? ResultType.MERGE : ResultType.TRANSPLANT).sourceRef((NamedRef)source).targetBranch(target).resultantTargetHash(targetHead).wasApplied(true).createdCommits((Iterable)mergeResult.getCreatedCommits()).build());
            if (individualCommits) {
                Assertions.assertThat((List)mergeResult.getCreatedCommits()).hasSize(expectedSourceCommits.size());
            } else {
                Assertions.assertThat((List)mergeResult.getCreatedCommits()).hasSize(1);
            }
            try (Stream targetLog = this.databaseAdapter.commitLog(targetHead);){
                Assertions.assertThat((Stream)targetLog).hasSize(individualCommits ? i + 1 : 1);
                continue;
            }
        }
        return targetHead;
    }

    private <PARAMS_BUILDER extends MetadataRewriteParams.Builder<PARAMS_BUILDER>> void mergeTransplantConflict(BiFunction<Hash[], Integer, PARAMS_BUILDER> configurer, MergeOrTransplant<PARAMS_BUILDER> mergeOrTransplant, boolean merge, Hash[] commits, List<CommitLogEntry> commitLogEntries, Hash mainHead) throws Exception {
        BranchName conflict = BranchName.of((String)"conflict");
        Hash conflictBase = this.databaseAdapter.create((NamedRef)conflict, mainHead).getHash();
        ImmutableCommitParams.Builder commit = ImmutableCommitParams.builder().toBranch(conflict).commitMetaSerialized(ByteString.copyFromUtf8((String)"commit conflict"));
        for (int k = 0; k < 2; ++k) {
            OnRefOnly conflictValue = OnRefOnly.newOnRef((String)("conflict value for " + k));
            commit.addPuts(KeyWithBytes.of((ContentKey)ContentKey.of((String[])new String[]{"key-" + k}), (ContentId)ContentId.of((String)("C" + k)), (byte)((byte)DefaultStoreWorker.payloadForContent((Content)conflictValue)), (ByteString)DefaultStoreWorker.instance().toStoreOnReferenceState((Content)conflictValue)));
        }
        Hash conflictHead = this.databaseAdapter.commit((CommitParams)commit.build()).getCommitHash();
        List<CommitLogEntry> expectedSourceCommits = commitLogEntries.subList(commits.length - 1 - 2, commits.length);
        MergeResult<CommitLogEntry> expectedMergeResult = this.conflictExpectedMergeResult(merge, conflict, conflictBase, conflictHead, expectedSourceCommits);
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> mergeOrTransplant.apply((MetadataRewriteParams.Builder)((MetadataRewriteParams.Builder)((MetadataRewriteParams.Builder)((MetadataRewriteParams.Builder)configurer.apply(commits, 2)).toBranch(conflict)).expectedHead(Optional.of(conflictBase))).isDryRun(true))).isInstanceOf(MergeConflictException.class)).hasMessage("The following keys have been changed in conflict: 'key-0', 'key-1'").asInstanceOf(InstanceOfAssertFactories.throwable(MergeConflictException.class))).extracting(MergeConflictException::getMergeResult).isEqualTo(expectedMergeResult);
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> mergeOrTransplant.apply((MetadataRewriteParams.Builder)((MetadataRewriteParams.Builder)((MetadataRewriteParams.Builder)configurer.apply(commits, 2)).toBranch(conflict)).expectedHead(Optional.of(conflictBase)))).isInstanceOf(MergeConflictException.class)).hasMessage("The following keys have been changed in conflict: 'key-0', 'key-1'").asInstanceOf(InstanceOfAssertFactories.throwable(MergeConflictException.class))).extracting(MergeConflictException::getMergeResult).isEqualTo(expectedMergeResult);
    }

    private MergeResult<CommitLogEntry> conflictExpectedMergeResult(boolean merge, BranchName conflict, Hash conflictBase, Hash conflictHead, List<CommitLogEntry> expectedSourceCommits) throws ReferenceNotFoundException {
        List conflictLogEntries;
        try (Stream log = this.databaseAdapter.commitLog(conflictHead).limit(1L);){
            conflictLogEntries = log.collect(Collectors.toList());
        }
        ImmutableMergeResult.Builder expectedMergeResult = MergeResult.builder().resultType(merge ? ResultType.MERGE : ResultType.TRANSPLANT).resultantTargetHash(conflictHead).sourceRef((NamedRef)BranchName.of((String)"branch")).targetBranch(conflict).effectiveTargetHash(conflictHead).expectedHash(conflictBase).commonAncestor((Hash)(merge ? conflictBase : null)).addAllSourceCommits(expectedSourceCommits).addAllTargetCommits(conflictLogEntries);
        for (int k = 0; k < 3; ++k) {
            ContentKey key = ContentKey.of((String[])new String[]{"key-" + k});
            ImmutableKeyDetails.Builder details = MergeResult.KeyDetails.builder().mergeBehavior(MergeBehavior.NORMAL).addAllSourceCommits((Iterable)expectedSourceCommits.stream().map(CommitLogEntry::getHash).collect(Collectors.toList()));
            if (k < 2) {
                details.conflict(Conflict.conflict((Conflict.ConflictType)Conflict.ConflictType.UNKNOWN, (ContentKey)key, (String)"UNRESOLVABLE")).conflictType(MergeResult.ConflictType.UNRESOLVABLE).addTargetCommits(conflictHead);
            }
            expectedMergeResult.putDetails(key, (MergeResult.KeyDetails)details.build());
        }
        return expectedMergeResult.build();
    }

    private static ImmutableMergeResult.Builder<CommitLogEntry> successExpectedMergeResult(boolean merge, BranchName targetBranch, Hash mainHead, List<CommitLogEntry> expectedSourceCommits) {
        ImmutableMergeResult.Builder expectedMergeResult = MergeResult.builder().wasSuccessful(true).targetBranch(targetBranch).effectiveTargetHash(mainHead).expectedHash(null).commonAncestor((Hash)(merge ? mainHead : null)).addAllSourceCommits(expectedSourceCommits);
        for (int k = 0; k < 3; ++k) {
            ContentKey key = ContentKey.of((String[])new String[]{"key-" + k});
            ImmutableKeyDetails.Builder details = MergeResult.KeyDetails.builder().conflictType(MergeResult.ConflictType.NONE).mergeBehavior(MergeBehavior.NORMAL).addAllSourceCommits((Iterable)expectedSourceCommits.stream().map(CommitLogEntry::getHash).collect(Collectors.toList()));
            expectedMergeResult.putDetails(key, (MergeResult.KeyDetails)details.build());
        }
        return expectedMergeResult;
    }

    @FunctionalInterface
    static interface MergeOrTransplant<PARAMS_BUILDER extends MetadataRewriteParams.Builder<PARAMS_BUILDER>> {
        public MergeResult<CommitLogEntry> apply(PARAMS_BUILDER var1) throws Exception;
    }
}

