/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.Test;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.RefLogNotFoundException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.persist.adapter.CommitParams;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitParams;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.persist.adapter.RefLog;
import org.projectnessie.versioned.persist.tests.extension.NessieDbAdapter;
import org.projectnessie.versioned.persist.tests.extension.NessieDbAdapterConfigItem;
import org.projectnessie.versioned.store.DefaultStoreWorker;
import org.projectnessie.versioned.testworker.OnRefOnly;

public abstract class AbstractRefLog {
    private final DatabaseAdapter databaseAdapter;

    protected AbstractRefLog(DatabaseAdapter databaseAdapter) {
        this.databaseAdapter = databaseAdapter;
    }

    @Test
    void increaseRefLogSplits(@NessieDbAdapter(initializeRepo=false) @NessieDbAdapterConfigItem(name="ref.log.stripes", value="50") DatabaseAdapter moreRefLogStripes) throws Exception {
        List all;
        IntFunction<BranchName> ref = i -> BranchName.of((String)("branch-" + i));
        for (int i2 = 0; i2 < 50; ++i2) {
            this.databaseAdapter.create((NamedRef)ref.apply(i2), this.databaseAdapter.noAncestorHash());
        }
        try (Stream refs = this.databaseAdapter.namedRefs(GetNamedRefsParams.DEFAULT);){
            List all2 = IntStream.range(0, 50).mapToObj(ref).collect(Collectors.toList());
            Assertions.assertThat(refs.filter(r -> r.getNamedRef().getName().startsWith("branch-"))).map(ReferenceInfo::getNamedRef).containsExactlyInAnyOrderElementsOf(all2);
        }
        IntFunction<List> branchNames = num -> IntStream.range(0, num).mapToObj(ref).map(NamedRef::getName).collect(Collectors.toList());
        Function<Stream, Stream> filterCreateBranches = refLog -> refLog.filter(l -> l.getOperation().equals("CREATE_REFERENCE")).filter(l -> l.getRefName().startsWith("branch-"));
        try (Stream refLog2 = this.databaseAdapter.refLog(null);){
            all = branchNames.apply(50);
            Assertions.assertThat((Stream)filterCreateBranches.apply(refLog2)).map(RefLog::getRefName).containsExactlyInAnyOrderElementsOf((Iterable)all);
        }
        refLog2 = moreRefLogStripes.refLog(null);
        try {
            all = branchNames.apply(50);
            Assertions.assertThat((Stream)filterCreateBranches.apply(refLog2)).map(RefLog::getRefName).containsExactlyInAnyOrderElementsOf((Iterable)all);
        }
        finally {
            if (refLog2 != null) {
                refLog2.close();
            }
        }
        for (int i3 = 50; i3 < 100; ++i3) {
            moreRefLogStripes.create((NamedRef)ref.apply(i3), moreRefLogStripes.noAncestorHash());
        }
        try (Stream refs = moreRefLogStripes.namedRefs(GetNamedRefsParams.DEFAULT);){
            all = IntStream.range(0, 100).mapToObj(ref).collect(Collectors.toList());
            Assertions.assertThat(refs.filter(r -> r.getNamedRef().getName().startsWith("branch-"))).map(ReferenceInfo::getNamedRef).containsExactlyInAnyOrderElementsOf(all);
        }
        refLog = moreRefLogStripes.refLog(null);
        try {
            all = branchNames.apply(100);
            Assertions.assertThat((Stream)filterCreateBranches.apply(refLog)).map(RefLog::getRefName).containsExactlyInAnyOrderElementsOf((Iterable)all);
        }
        finally {
            if (refLog != null) {
                refLog.close();
            }
        }
    }

    @Test
    void emptyRefLog() throws Exception {
        try (Stream refLog = this.databaseAdapter.refLog(null);){
            ((ObjectAssert)((ListAssert)Assertions.assertThat((Stream)refLog).hasSize(1)).first()).extracting(new Function[]{RefLog::getRefName, RefLog::getOperation, RefLog::getCommitHash, RefLog::getParents}).containsExactly(new Object[]{"main", "CREATE_REFERENCE", this.databaseAdapter.noAncestorHash(), Collections.singletonList(this.databaseAdapter.noAncestorHash())});
        }
    }

    @Test
    void nonExitingRefLogEntry() {
        Assertions.assertThatThrownBy(() -> this.databaseAdapter.refLog(Hash.of((String)"000000"))).isInstanceOf(RefLogNotFoundException.class);
    }

    @Test
    void splitRefLog() throws Exception {
        int i2;
        IntFunction<NamedRef> refGen = i -> {
            String name = "splitRefLogTest-" + i;
            return (i & 1) == 1 ? TagName.of((String)name) : BranchName.of((String)name);
        };
        HashMap<NamedRef, List> refLogOpsPerRef = new HashMap<NamedRef, List>();
        for (i2 = 0; i2 < 50; ++i2) {
            NamedRef ref2 = refGen.apply(i2);
            Assertions.assertThat((Object)this.databaseAdapter.create(ref2, this.databaseAdapter.noAncestorHash()).getHash()).isEqualTo((Object)this.databaseAdapter.noAncestorHash());
            refLogOpsPerRef.computeIfAbsent(ref2, x -> new ArrayList()).add(Tuple.tuple((Object[])new Object[]{"CREATE_REFERENCE", this.databaseAdapter.noAncestorHash()}));
        }
        for (int commit = 0; commit < 50; ++commit) {
            for (int i3 = 0; i3 < 50; ++i3) {
                NamedRef ref3 = refGen.apply(i3);
                if (!(ref3 instanceof BranchName)) continue;
                this.databaseAdapter.commit((CommitParams)ImmutableCommitParams.builder().toBranch((BranchName)ref3).commitMetaSerialized(ByteString.copyFromUtf8((String)("foo on " + ref3.getName()))).addPuts(KeyWithBytes.of((ContentKey)ContentKey.of((String[])new String[]{"table-" + commit}), (ContentId)ContentId.of((String)("c" + commit)), (byte)((byte)DefaultStoreWorker.payloadForContent((Content.Type)OnRefOnly.ON_REF_ONLY)), (ByteString)DefaultStoreWorker.instance().toStoreOnReferenceState((Content)OnRefOnly.newOnRef((String)("c" + commit))))).build());
            }
        }
        for (i2 = 2; i2 < 50; i2 += 3) {
            NamedRef ref4 = refGen.apply(i2);
            ReferenceInfo refInfo = this.databaseAdapter.namedRef(ref4.getName(), GetNamedRefsParams.DEFAULT);
            this.databaseAdapter.delete(ref4, Optional.empty());
            Assertions.assertThatThrownBy(() -> this.databaseAdapter.namedRef(ref4.getName(), GetNamedRefsParams.DEFAULT)).isInstanceOf(ReferenceNotFoundException.class);
            refLogOpsPerRef.computeIfAbsent(ref4, x -> new ArrayList()).add(Tuple.tuple((Object[])new Object[]{"DELETE_REFERENCE", refInfo.getHash()}));
        }
        try (Stream refLog = this.databaseAdapter.refLog(null);){
            refLog.filter(l -> l.getRefName().startsWith("splitRefLogTest-")).forEach(l -> {
                BranchName ref = "Branch".equals(l.getRefType()) ? BranchName.of((String)l.getRefName()) : TagName.of((String)l.getRefName());
                List refOps = (List)refLogOpsPerRef.get(ref);
                ((ObjectAssert)((ListAssert)((ListAssert)Assertions.assertThat((List)refOps).describedAs("RefLog operations %s for %s", new Object[]{refOps, l})).isNotNull()).last()).isEqualTo((Object)Tuple.tuple((Object[])new Object[]{l.getOperation(), l.getCommitHash()}));
                refOps.remove(refOps.size() - 1);
            });
        }
        Assertions.assertThat(refLogOpsPerRef).allSatisfy((ref, ops) -> Assertions.assertThat((List)ops).isEmpty());
    }
}

