/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tests;

import com.google.common.base.Strings;
import io.opentracing.mock.MockSpan;
import io.opentracing.mock.MockTracer;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.persist.tests.extension.NessieDbTracer;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;

public abstract class AbstractTracing
extends AbstractNestedVersionStore {
    @NessieDbTracer
    MockTracer tracer;

    protected AbstractTracing(VersionStore store) {
        super(store);
    }

    @Test
    void createBranch() throws Exception {
        this.store().create((NamedRef)BranchName.of((String)"traceCreateBranch"), Optional.empty());
        Assertions.assertThat((Object)this.tracer.activeSpan()).isNull();
        List<MockSpanHierarchy> hierarchy = this.spanHierarchy();
        Assertions.assertThat(hierarchy).hasSize(1);
        MockSpanHierarchy root = hierarchy.get(0);
        Assertions.assertThat((Object)root.asOperationHierarchy(null)).satisfiesAnyOf(new ThrowingConsumer[]{h -> Assertions.assertThat((Object)h).isEqualTo((Object)OperationHierarchy.create().child("DatabaseAdapter.create", dbCreate -> dbCreate.child("DatabaseAdapter.try-loop.createRef", tryLoop -> tryLoop.child("DatabaseAdapter.fetchNamedReference", c -> c.add("DatabaseAdapter.fetchGlobalPointer")).child("DatabaseAdapter.createNamedReference", c -> c.add("DatabaseAdapter.fetchReferenceNames")).add("DatabaseAdapter.fetchRefLogParentsForReference").add("DatabaseAdapter.writeRefLog").add("DatabaseAdapter.refLogParentsCas")))), h -> Assertions.assertThat((Object)h).isEqualTo((Object)OperationHierarchy.create().child("DatabaseAdapter.create", dbCreate -> dbCreate.child("DatabaseAdapter.try-loop.createRef", tryLoop -> tryLoop.add("DatabaseAdapter.checkNamedRefExistence").add("DatabaseAdapter.insertNewReference").add("DatabaseAdapter.getRefLogHead").add("DatabaseAdapter.updateRefLogHead"))))});
    }

    private List<MockSpanHierarchy> spanHierarchy() {
        HashMap<Long, MockSpanHierarchy> byId = new HashMap<Long, MockSpanHierarchy>();
        for (Object span : this.tracer.finishedSpans()) {
            byId.computeIfAbsent(span.context().spanId(), id -> new MockSpanHierarchy()).span = span;
            byId.computeIfAbsent(span.parentId(), id -> new MockSpanHierarchy()).childSpans.add(span);
        }
        for (Object span : byId.values()) {
            if (((MockSpanHierarchy)span).span != null) {
                ((MockSpanHierarchy)span).parent = (MockSpanHierarchy)byId.get(((MockSpanHierarchy)span).span.parentId());
            }
            ((MockSpanHierarchy)span).childSpans.stream().map(MockSpan::context).mapToLong(MockSpan.MockContext::spanId).mapToObj(byId::get).forEach(((MockSpanHierarchy)span).children::add);
        }
        return byId.values().stream().filter(h -> ((MockSpanHierarchy)h).parent == null).collect(Collectors.toList());
    }

    static class MockSpanHierarchy {
        private MockSpanHierarchy parent;
        private MockSpan span;
        private final List<MockSpan> childSpans = new ArrayList<MockSpan>();
        private final List<MockSpanHierarchy> children = new ArrayList<MockSpanHierarchy>();

        private MockSpanHierarchy() {
        }

        public OperationHierarchy asOperationHierarchy(OperationHierarchy parent) {
            OperationHierarchy op = new OperationHierarchy(parent, this.span != null ? this.span.operationName() : "<root>");
            for (MockSpanHierarchy child : this.children) {
                op.children.add(child.asOperationHierarchy(op));
            }
            return op;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public String toString() {
            try (StringWriter sw = new StringWriter();){
                PrintWriter pw = new PrintWriter(sw);
                try {
                    this.toString(pw, 0);
                    String string = sw.toString();
                    pw.close();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        pw.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        void toString(PrintWriter w, int indent) {
            if (this.span != null) {
                w.printf("%5d (%5d\u00b5s) %s %-20s %s%n", this.span.context().spanId(), this.span.finishMicros() - this.span.startMicros(), Strings.repeat((String)"    ", (int)indent), this.span.operationName(), this.span.tags());
            }
            for (MockSpanHierarchy child : this.children) {
                child.toString(w, indent + 1);
            }
        }
    }

    static class OperationHierarchy {
        private final OperationHierarchy parent;
        private final String name;
        private final List<OperationHierarchy> children = new ArrayList<OperationHierarchy>();

        OperationHierarchy(OperationHierarchy parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public static OperationHierarchy create() {
            return new OperationHierarchy(null, "<root>");
        }

        public OperationHierarchy child(String name, Consumer<OperationHierarchy> childConsumer) {
            OperationHierarchy ch = new OperationHierarchy(this, name);
            this.children.add(ch);
            childConsumer.accept(ch);
            return this;
        }

        public OperationHierarchy add(String name) {
            this.child(name, c -> {});
            return this;
        }

        public OperationHierarchy parent() {
            return this.parent;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OperationHierarchy)) {
                return false;
            }
            OperationHierarchy that = (OperationHierarchy)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.children, that.children);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.children);
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public String toString() {
            try (StringWriter sw = new StringWriter();){
                PrintWriter pw = new PrintWriter(sw);
                try {
                    this.toString(pw, 0);
                    String string = sw.toString();
                    pw.close();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        pw.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        void toString(PrintWriter w, int indent) {
            w.printf("%s %s%n", Strings.repeat((String)"    ", (int)indent), this.name);
            for (OperationHierarchy child : this.children) {
                child.toString(w, indent + 1);
            }
        }
    }
}

