/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.tests;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitLogEntry;

public abstract class AbstractWriteUpdateCommits {
    private final DatabaseAdapter databaseAdapter;
    private final boolean commitWritesValidated;

    protected AbstractWriteUpdateCommits(DatabaseAdapter databaseAdapter, boolean commitWritesValidated) {
        this.databaseAdapter = databaseAdapter;
        this.commitWritesValidated = commitWritesValidated;
    }

    Hash intAsHash(int i) {
        return Hash.of((String)String.format("%08x", i));
    }

    private CommitLogEntry helloCommit(int i) {
        return CommitLogEntry.of((long)i, (Hash)this.intAsHash(i), (long)i, Collections.singletonList(this.intAsHash(i - 1)), (ByteString)ByteString.copyFromUtf8((String)("hello " + i)), Collections.emptyList(), Collections.emptyList(), (int)0, null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @Test
    void writeMultipleCommits() throws Exception {
        List hashes = IntStream.rangeClosed(1, 10).mapToObj(this::intAsHash).collect(Collectors.toList());
        List commits = hashes.stream().mapToInt(h -> Integer.parseInt(h.asString(), 16)).mapToObj(this::helloCommit).collect(Collectors.toList());
        this.databaseAdapter.writeMultipleCommits(commits);
        try (Stream retrieved = this.databaseAdapter.fetchCommitLogEntries(hashes.stream());){
            Assertions.assertThat((Stream)retrieved).containsExactlyInAnyOrderElementsOf(commits);
        }
        List updatedCommits = commits.stream().map(commit -> ImmutableCommitLogEntry.builder().from(commit).metadata(ByteString.copyFromUtf8((String)("updated " + commit.getHash().asString()))).build()).collect(Collectors.toList());
        this.databaseAdapter.updateMultipleCommits(updatedCommits);
        try (Stream retrieved = this.databaseAdapter.fetchCommitLogEntries(hashes.stream());){
            Assertions.assertThat((Stream)retrieved).containsExactlyInAnyOrderElementsOf(updatedCommits);
        }
    }

    @Test
    void validateWriteUpdateCommitPreconditions() throws Exception {
        Assumptions.assumeThat((boolean)this.commitWritesValidated).isTrue();
        List hashes = IntStream.rangeClosed(1, 10).mapToObj(this::intAsHash).collect(Collectors.toList());
        List commits = hashes.stream().mapToInt(h -> Integer.parseInt(h.asString(), 16)).mapToObj(this::helloCommit).collect(Collectors.toList());
        this.databaseAdapter.writeMultipleCommits(commits.subList(0, 2));
        Assertions.assertThatThrownBy(() -> this.databaseAdapter.writeMultipleCommits(commits.subList(0, 2))).isInstanceOf(ReferenceConflictException.class);
        Assertions.assertThatThrownBy(() -> this.databaseAdapter.updateMultipleCommits(commits)).isInstanceOf(ReferenceNotFoundException.class);
    }
}

