/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.ContentKey;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.MergeTransplantResultBase;
import org.projectnessie.versioned.NamedRef;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MergeResult", generator="Immutables")
@Immutable
public final class ImmutableMergeResult
implements MergeResult {
    private final boolean wasApplied;
    private final boolean wasSuccessful;
    @Nullable
    private final Hash resultantTargetHash;
    @Nullable
    private final Hash commonAncestor;
    private final NamedRef sourceRef;
    private final BranchName targetBranch;
    private final Hash effectiveTargetHash;
    @Nullable
    private final Hash expectedHash;
    private final ImmutableList<Commit> createdCommits;
    private final ImmutableMap<ContentKey, MergeTransplantResultBase.KeyDetails> details;
    private final Hash sourceHash;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMergeResult(Builder builder) {
        this.resultantTargetHash = builder.resultantTargetHash;
        this.commonAncestor = builder.commonAncestor;
        this.sourceRef = builder.sourceRef;
        this.targetBranch = builder.targetBranch;
        this.effectiveTargetHash = builder.effectiveTargetHash;
        this.expectedHash = builder.expectedHash;
        this.createdCommits = builder.createdCommits.build();
        this.details = builder.details.build();
        this.sourceHash = builder.sourceHash;
        if (builder.wasAppliedIsSet()) {
            this.initShim.wasApplied(builder.wasApplied);
        }
        if (builder.wasSuccessfulIsSet()) {
            this.initShim.wasSuccessful(builder.wasSuccessful);
        }
        this.wasApplied = this.initShim.wasApplied();
        this.wasSuccessful = this.initShim.wasSuccessful();
        this.initShim = null;
    }

    private ImmutableMergeResult(boolean wasApplied, boolean wasSuccessful, @Nullable Hash resultantTargetHash, @Nullable Hash commonAncestor, NamedRef sourceRef, BranchName targetBranch, Hash effectiveTargetHash, @Nullable Hash expectedHash, ImmutableList<Commit> createdCommits, ImmutableMap<ContentKey, MergeTransplantResultBase.KeyDetails> details, Hash sourceHash) {
        this.wasApplied = wasApplied;
        this.wasSuccessful = wasSuccessful;
        this.resultantTargetHash = resultantTargetHash;
        this.commonAncestor = commonAncestor;
        this.sourceRef = sourceRef;
        this.targetBranch = targetBranch;
        this.effectiveTargetHash = effectiveTargetHash;
        this.expectedHash = expectedHash;
        this.createdCommits = createdCommits;
        this.details = details;
        this.sourceHash = sourceHash;
        this.initShim = null;
    }

    private boolean wasAppliedInitialize() {
        return MergeResult.super.wasApplied();
    }

    private boolean wasSuccessfulInitialize() {
        return MergeResult.super.wasSuccessful();
    }

    @Override
    public boolean wasApplied() {
        InitShim shim = this.initShim;
        return shim != null ? shim.wasApplied() : this.wasApplied;
    }

    @Override
    public boolean wasSuccessful() {
        InitShim shim = this.initShim;
        return shim != null ? shim.wasSuccessful() : this.wasSuccessful;
    }

    @Override
    @Nullable
    public Hash getResultantTargetHash() {
        return this.resultantTargetHash;
    }

    @Override
    @Nullable
    public Hash getCommonAncestor() {
        return this.commonAncestor;
    }

    @Override
    public NamedRef getSourceRef() {
        return this.sourceRef;
    }

    @Override
    public BranchName getTargetBranch() {
        return this.targetBranch;
    }

    @Override
    public Hash getEffectiveTargetHash() {
        return this.effectiveTargetHash;
    }

    @Override
    @Nullable
    public Hash getExpectedHash() {
        return this.expectedHash;
    }

    public ImmutableList<Commit> getCreatedCommits() {
        return this.createdCommits;
    }

    public ImmutableMap<ContentKey, MergeTransplantResultBase.KeyDetails> getDetails() {
        return this.details;
    }

    @Override
    public Hash getSourceHash() {
        return this.sourceHash;
    }

    public final ImmutableMergeResult withWasApplied(boolean value) {
        if (this.wasApplied == value) {
            return this;
        }
        return new ImmutableMergeResult(value, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.createdCommits, this.details, this.sourceHash);
    }

    public final ImmutableMergeResult withWasSuccessful(boolean value) {
        if (this.wasSuccessful == value) {
            return this;
        }
        return new ImmutableMergeResult(this.wasApplied, value, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.createdCommits, this.details, this.sourceHash);
    }

    public final ImmutableMergeResult withResultantTargetHash(@Nullable Hash value) {
        if (this.resultantTargetHash == value) {
            return this;
        }
        return new ImmutableMergeResult(this.wasApplied, this.wasSuccessful, value, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.createdCommits, this.details, this.sourceHash);
    }

    public final ImmutableMergeResult withCommonAncestor(@Nullable Hash value) {
        if (this.commonAncestor == value) {
            return this;
        }
        return new ImmutableMergeResult(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, value, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.createdCommits, this.details, this.sourceHash);
    }

    public final ImmutableMergeResult withSourceRef(NamedRef value) {
        if (this.sourceRef == value) {
            return this;
        }
        NamedRef newValue = Objects.requireNonNull(value, "sourceRef");
        return new ImmutableMergeResult(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, newValue, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.createdCommits, this.details, this.sourceHash);
    }

    public final ImmutableMergeResult withTargetBranch(BranchName value) {
        if (this.targetBranch == value) {
            return this;
        }
        BranchName newValue = Objects.requireNonNull(value, "targetBranch");
        return new ImmutableMergeResult(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, newValue, this.effectiveTargetHash, this.expectedHash, this.createdCommits, this.details, this.sourceHash);
    }

    public final ImmutableMergeResult withEffectiveTargetHash(Hash value) {
        if (this.effectiveTargetHash == value) {
            return this;
        }
        Hash newValue = Objects.requireNonNull(value, "effectiveTargetHash");
        return new ImmutableMergeResult(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, newValue, this.expectedHash, this.createdCommits, this.details, this.sourceHash);
    }

    public final ImmutableMergeResult withExpectedHash(@Nullable Hash value) {
        if (this.expectedHash == value) {
            return this;
        }
        return new ImmutableMergeResult(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, value, this.createdCommits, this.details, this.sourceHash);
    }

    public final ImmutableMergeResult withCreatedCommits(Commit ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMergeResult(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, (ImmutableList<Commit>)newValue, this.details, this.sourceHash);
    }

    public final ImmutableMergeResult withCreatedCommits(Iterable<? extends Commit> elements) {
        if (this.createdCommits == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMergeResult(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, (ImmutableList<Commit>)newValue, this.details, this.sourceHash);
    }

    public final ImmutableMergeResult withDetails(Map<? extends ContentKey, ? extends MergeTransplantResultBase.KeyDetails> entries) {
        if (this.details == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableMergeResult(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.createdCommits, (ImmutableMap<ContentKey, MergeTransplantResultBase.KeyDetails>)newValue, this.sourceHash);
    }

    public final ImmutableMergeResult withSourceHash(Hash value) {
        if (this.sourceHash == value) {
            return this;
        }
        Hash newValue = Objects.requireNonNull(value, "sourceHash");
        return new ImmutableMergeResult(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.createdCommits, this.details, newValue);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMergeResult && this.equalTo(0, (ImmutableMergeResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableMergeResult another) {
        return this.wasApplied == another.wasApplied && this.wasSuccessful == another.wasSuccessful && Objects.equals(this.resultantTargetHash, another.resultantTargetHash) && Objects.equals(this.commonAncestor, another.commonAncestor) && this.sourceRef.equals(another.sourceRef) && this.targetBranch.equals(another.targetBranch) && this.effectiveTargetHash.equals(another.effectiveTargetHash) && Objects.equals(this.expectedHash, another.expectedHash) && this.createdCommits.equals(another.createdCommits) && this.details.equals(another.details) && this.sourceHash.equals(another.sourceHash);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.wasApplied);
        h += (h << 5) + Booleans.hashCode((boolean)this.wasSuccessful);
        h += (h << 5) + Objects.hashCode(this.resultantTargetHash);
        h += (h << 5) + Objects.hashCode(this.commonAncestor);
        h += (h << 5) + this.sourceRef.hashCode();
        h += (h << 5) + this.targetBranch.hashCode();
        h += (h << 5) + this.effectiveTargetHash.hashCode();
        h += (h << 5) + Objects.hashCode(this.expectedHash);
        h += (h << 5) + this.createdCommits.hashCode();
        h += (h << 5) + this.details.hashCode();
        h += (h << 5) + this.sourceHash.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MergeResult").omitNullValues().add("wasApplied", this.wasApplied).add("wasSuccessful", this.wasSuccessful).add("resultantTargetHash", (Object)this.resultantTargetHash).add("commonAncestor", (Object)this.commonAncestor).add("sourceRef", (Object)this.sourceRef).add("targetBranch", (Object)this.targetBranch).add("effectiveTargetHash", (Object)this.effectiveTargetHash).add("expectedHash", (Object)this.expectedHash).add("createdCommits", this.createdCommits).add("details", this.details).add("sourceHash", (Object)this.sourceHash).toString();
    }

    public static ImmutableMergeResult copyOf(MergeResult instance) {
        if (instance instanceof ImmutableMergeResult) {
            return (ImmutableMergeResult)instance;
        }
        return ImmutableMergeResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MergeResult", generator="Immutables")
    private final class InitShim {
        private byte wasAppliedBuildStage = 0;
        private boolean wasApplied;
        private byte wasSuccessfulBuildStage = 0;
        private boolean wasSuccessful;

        private InitShim() {
        }

        boolean wasApplied() {
            if (this.wasAppliedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.wasAppliedBuildStage == 0) {
                this.wasAppliedBuildStage = (byte)-1;
                this.wasApplied = ImmutableMergeResult.this.wasAppliedInitialize();
                this.wasAppliedBuildStage = 1;
            }
            return this.wasApplied;
        }

        void wasApplied(boolean wasApplied) {
            this.wasApplied = wasApplied;
            this.wasAppliedBuildStage = 1;
        }

        boolean wasSuccessful() {
            if (this.wasSuccessfulBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.wasSuccessfulBuildStage == 0) {
                this.wasSuccessfulBuildStage = (byte)-1;
                this.wasSuccessful = ImmutableMergeResult.this.wasSuccessfulInitialize();
                this.wasSuccessfulBuildStage = 1;
            }
            return this.wasSuccessful;
        }

        void wasSuccessful(boolean wasSuccessful) {
            this.wasSuccessful = wasSuccessful;
            this.wasSuccessfulBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.wasAppliedBuildStage == -1) {
                attributes.add("wasApplied");
            }
            if (this.wasSuccessfulBuildStage == -1) {
                attributes.add("wasSuccessful");
            }
            return "Cannot build MergeResult, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="MergeResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements MergeResult.Builder {
        private static final long INIT_BIT_SOURCE_REF = 1L;
        private static final long INIT_BIT_TARGET_BRANCH = 2L;
        private static final long INIT_BIT_EFFECTIVE_TARGET_HASH = 4L;
        private static final long INIT_BIT_SOURCE_HASH = 8L;
        private static final long OPT_BIT_WAS_APPLIED = 1L;
        private static final long OPT_BIT_WAS_SUCCESSFUL = 2L;
        private long initBits = 15L;
        private long optBits;
        private boolean wasApplied;
        private boolean wasSuccessful;
        @javax.annotation.Nullable
        private Hash resultantTargetHash;
        @javax.annotation.Nullable
        private Hash commonAncestor;
        @javax.annotation.Nullable
        private NamedRef sourceRef;
        @javax.annotation.Nullable
        private BranchName targetBranch;
        @javax.annotation.Nullable
        private Hash effectiveTargetHash;
        @javax.annotation.Nullable
        private Hash expectedHash;
        private ImmutableList.Builder<Commit> createdCommits = ImmutableList.builder();
        private ImmutableMap.Builder<ContentKey, MergeTransplantResultBase.KeyDetails> details = ImmutableMap.builder();
        @javax.annotation.Nullable
        private Hash sourceHash;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MergeResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(MergeTransplantResultBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Hash expectedHashValue;
            Hash commonAncestorValue;
            Hash resultantTargetHashValue;
            MergeTransplantResultBase instance;
            long bits = 0L;
            if (object instanceof MergeResult) {
                instance = (MergeResult)object;
                if ((bits & 1L) == 0L) {
                    this.targetBranch(instance.getTargetBranch());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.effectiveTargetHash(instance.getEffectiveTargetHash());
                    bits |= 2L;
                }
                this.sourceHash(instance.getSourceHash());
                if ((bits & 4L) == 0L) {
                    this.addAllCreatedCommits(instance.getCreatedCommits());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    resultantTargetHashValue = instance.getResultantTargetHash();
                    if (resultantTargetHashValue != null) {
                        this.resultantTargetHash(resultantTargetHashValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.wasSuccessful(instance.wasSuccessful());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    commonAncestorValue = instance.getCommonAncestor();
                    if (commonAncestorValue != null) {
                        this.commonAncestor(commonAncestorValue);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    expectedHashValue = instance.getExpectedHash();
                    if (expectedHashValue != null) {
                        this.expectedHash(expectedHashValue);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.putAllDetails(instance.getDetails());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.sourceRef(instance.getSourceRef());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.wasApplied(instance.wasApplied());
                    bits |= 0x200L;
                }
            }
            if (object instanceof MergeTransplantResultBase) {
                instance = (MergeTransplantResultBase)object;
                if ((bits & 1L) == 0L) {
                    this.targetBranch(instance.getTargetBranch());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.effectiveTargetHash(instance.getEffectiveTargetHash());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllCreatedCommits(instance.getCreatedCommits());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    resultantTargetHashValue = instance.getResultantTargetHash();
                    if (resultantTargetHashValue != null) {
                        this.resultantTargetHash(resultantTargetHashValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.wasSuccessful(instance.wasSuccessful());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    commonAncestorValue = instance.getCommonAncestor();
                    if (commonAncestorValue != null) {
                        this.commonAncestor(commonAncestorValue);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    expectedHashValue = instance.getExpectedHash();
                    if (expectedHashValue != null) {
                        this.expectedHash(expectedHashValue);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.putAllDetails(instance.getDetails());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.sourceRef(instance.getSourceRef());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.wasApplied(instance.wasApplied());
                    bits |= 0x200L;
                }
            }
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder wasApplied(boolean wasApplied) {
            this.wasApplied = wasApplied;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder wasSuccessful(boolean wasSuccessful) {
            this.wasSuccessful = wasSuccessful;
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder resultantTargetHash(@Nullable Hash resultantTargetHash) {
            this.resultantTargetHash = resultantTargetHash;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder commonAncestor(@Nullable Hash commonAncestor) {
            this.commonAncestor = commonAncestor;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder sourceRef(NamedRef sourceRef) {
            this.sourceRef = Objects.requireNonNull(sourceRef, "sourceRef");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder targetBranch(BranchName targetBranch) {
            this.targetBranch = Objects.requireNonNull(targetBranch, "targetBranch");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder effectiveTargetHash(Hash effectiveTargetHash) {
            this.effectiveTargetHash = Objects.requireNonNull(effectiveTargetHash, "effectiveTargetHash");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder expectedHash(@Nullable Hash expectedHash) {
            this.expectedHash = expectedHash;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addCreatedCommits(Commit element) {
            this.createdCommits.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCreatedCommits(Commit ... elements) {
            this.createdCommits.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder createdCommits(Iterable<? extends Commit> elements) {
            this.createdCommits = ImmutableList.builder();
            return this.addAllCreatedCommits(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCreatedCommits(Iterable<? extends Commit> elements) {
            this.createdCommits.addAll(elements);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder putDetails(ContentKey key, MergeTransplantResultBase.KeyDetails value) {
            this.details.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putDetails(Map.Entry<? extends ContentKey, ? extends MergeTransplantResultBase.KeyDetails> entry) {
            this.details.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder details(Map<? extends ContentKey, ? extends MergeTransplantResultBase.KeyDetails> entries) {
            this.details = ImmutableMap.builder();
            return this.putAllDetails(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllDetails(Map<? extends ContentKey, ? extends MergeTransplantResultBase.KeyDetails> entries) {
            this.details.putAll(entries);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder sourceHash(Hash sourceHash) {
            this.sourceHash = Objects.requireNonNull(sourceHash, "sourceHash");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @Override
        public ImmutableMergeResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMergeResult(this);
        }

        private boolean wasAppliedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean wasSuccessfulIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceRef");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("targetBranch");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("effectiveTargetHash");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("sourceHash");
            }
            return "Cannot build MergeResult, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

