/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceCreatedResult;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReferenceCreatedResult", generator="Immutables")
@Immutable
public final class ImmutableReferenceCreatedResult
implements ReferenceCreatedResult {
    private final NamedRef namedRef;
    private final Hash hash;

    private ImmutableReferenceCreatedResult(NamedRef namedRef, Hash hash) {
        this.namedRef = namedRef;
        this.hash = hash;
    }

    @Override
    public NamedRef getNamedRef() {
        return this.namedRef;
    }

    @Override
    public Hash getHash() {
        return this.hash;
    }

    public final ImmutableReferenceCreatedResult withNamedRef(NamedRef value) {
        if (this.namedRef == value) {
            return this;
        }
        NamedRef newValue = Objects.requireNonNull(value, "namedRef");
        return new ImmutableReferenceCreatedResult(newValue, this.hash);
    }

    public final ImmutableReferenceCreatedResult withHash(Hash value) {
        if (this.hash == value) {
            return this;
        }
        Hash newValue = Objects.requireNonNull(value, "hash");
        return new ImmutableReferenceCreatedResult(this.namedRef, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReferenceCreatedResult && this.equalTo(0, (ImmutableReferenceCreatedResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableReferenceCreatedResult another) {
        return this.namedRef.equals(another.namedRef) && this.hash.equals(another.hash);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.namedRef.hashCode();
        h += (h << 5) + this.hash.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ReferenceCreatedResult").omitNullValues().add("namedRef", (Object)this.namedRef).add("hash", (Object)this.hash).toString();
    }

    public static ImmutableReferenceCreatedResult copyOf(ReferenceCreatedResult instance) {
        if (instance instanceof ImmutableReferenceCreatedResult) {
            return (ImmutableReferenceCreatedResult)instance;
        }
        return ImmutableReferenceCreatedResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ReferenceCreatedResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAMED_REF = 1L;
        private static final long INIT_BIT_HASH = 2L;
        private long initBits = 3L;
        @Nullable
        private NamedRef namedRef;
        @Nullable
        private Hash hash;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReferenceCreatedResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.namedRef(instance.getNamedRef());
            this.hash(instance.getHash());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder namedRef(NamedRef namedRef) {
            this.namedRef = Objects.requireNonNull(namedRef, "namedRef");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hash(Hash hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableReferenceCreatedResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReferenceCreatedResult(this.namedRef, this.hash);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("namedRef");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build ReferenceCreatedResult, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

