/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import org.immutables.value.Value;
import org.projectnessie.model.Conflict;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ImmutableKeyDetails;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Result;

public interface MergeTransplantResultBase
extends Result {
    @Value.Default
    default public boolean wasApplied() {
        return false;
    }

    @Value.Default
    default public boolean wasSuccessful() {
        return false;
    }

    @Nullable
    public Hash getResultantTargetHash();

    @Nullable
    public Hash getCommonAncestor();

    public NamedRef getSourceRef();

    public BranchName getTargetBranch();

    public Hash getEffectiveTargetHash();

    @Nullable
    public Hash getExpectedHash();

    public List<Commit> getCreatedCommits();

    public Map<ContentKey, KeyDetails> getDetails();

    public static interface Builder<T extends MergeTransplantResultBase, B extends Builder<T, B>> {
        @CanIgnoreReturnValue
        public B wasApplied(boolean var1);

        @CanIgnoreReturnValue
        public B wasSuccessful(boolean var1);

        @CanIgnoreReturnValue
        public B resultantTargetHash(Hash var1);

        @CanIgnoreReturnValue
        public B commonAncestor(Hash var1);

        @CanIgnoreReturnValue
        public B sourceRef(NamedRef var1);

        @CanIgnoreReturnValue
        public B targetBranch(BranchName var1);

        @CanIgnoreReturnValue
        public B effectiveTargetHash(Hash var1);

        @CanIgnoreReturnValue
        public B expectedHash(Hash var1);

        @CanIgnoreReturnValue
        public B addCreatedCommits(Commit var1);

        @CanIgnoreReturnValue
        public B putDetails(ContentKey var1, KeyDetails var2);

        public T build();
    }

    @Value.Immutable
    public static interface KeyDetails {
        @Value.Parameter(order=1)
        public MergeBehavior getMergeBehavior();

        @Nullable
        @Value.Parameter(order=2)
        public Conflict getConflict();

        public static ImmutableKeyDetails.Builder builder() {
            return ImmutableKeyDetails.builder();
        }

        public static KeyDetails keyDetails(MergeBehavior mergeBehavior, Conflict conflict) {
            return ImmutableKeyDetails.of(mergeBehavior, conflict);
        }
    }
}

