/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.CommitResult;
import org.projectnessie.versioned.Hash;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommitResult", generator="Immutables")
@Immutable
public final class ImmutableCommitResult
implements CommitResult {
    private final Commit commit;
    private final BranchName targetBranch;
    private final transient Hash commitHash;

    private ImmutableCommitResult(Commit commit, BranchName targetBranch) {
        this.commit = commit;
        this.targetBranch = targetBranch;
        this.commitHash = Objects.requireNonNull(CommitResult.super.getCommitHash(), "commitHash");
    }

    @Override
    public Commit getCommit() {
        return this.commit;
    }

    @Override
    public BranchName getTargetBranch() {
        return this.targetBranch;
    }

    @Override
    public Hash getCommitHash() {
        return this.commitHash;
    }

    public final ImmutableCommitResult withCommit(Commit value) {
        if (this.commit == value) {
            return this;
        }
        Commit newValue = Objects.requireNonNull(value, "commit");
        return new ImmutableCommitResult(newValue, this.targetBranch);
    }

    public final ImmutableCommitResult withTargetBranch(BranchName value) {
        if (this.targetBranch == value) {
            return this;
        }
        BranchName newValue = Objects.requireNonNull(value, "targetBranch");
        return new ImmutableCommitResult(this.commit, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitResult && this.equalTo(0, (ImmutableCommitResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommitResult another) {
        return this.commit.equals(another.commit) && this.targetBranch.equals(another.targetBranch) && this.commitHash.equals(another.commitHash);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.commit.hashCode();
        h += (h << 5) + this.targetBranch.hashCode();
        h += (h << 5) + this.commitHash.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CommitResult").omitNullValues().add("commit", (Object)this.commit).add("targetBranch", (Object)this.targetBranch).add("commitHash", (Object)this.commitHash).toString();
    }

    public static ImmutableCommitResult copyOf(CommitResult instance) {
        if (instance instanceof ImmutableCommitResult) {
            return (ImmutableCommitResult)instance;
        }
        return ImmutableCommitResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommitResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COMMIT = 1L;
        private static final long INIT_BIT_TARGET_BRANCH = 2L;
        private long initBits = 3L;
        @Nullable
        private Commit commit;
        @Nullable
        private BranchName targetBranch;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.commit(instance.getCommit());
            this.targetBranch(instance.getTargetBranch());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commit(Commit commit) {
            this.commit = Objects.requireNonNull(commit, "commit");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder targetBranch(BranchName targetBranch) {
            this.targetBranch = Objects.requireNonNull(targetBranch, "targetBranch");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableCommitResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitResult(this.commit, this.targetBranch);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("commit");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("targetBranch");
            }
            return "Cannot build CommitResult, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

