/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Value;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IdentifiedContentKey;
import org.projectnessie.versioned.ImmutableDiff;

@Value.Immutable
public interface Diff {
    @Nullable
    @Value.Parameter(order=1)
    public IdentifiedContentKey getFromKey();

    @Nullable
    @Value.Parameter(order=2)
    public IdentifiedContentKey getToKey();

    @Value.Parameter(order=3)
    public Optional<Content> getFromValue();

    @Value.Parameter(order=4)
    public Optional<Content> getToValue();

    @Value.NonAttribute
    default public ContentKey contentKey() {
        IdentifiedContentKey k = this.getFromKey();
        if (k == null) {
            k = this.getToKey();
        }
        return Objects.requireNonNull(k).contentKey();
    }

    @Value.Check
    default public void check() {
        IdentifiedContentKey from = this.getFromKey();
        IdentifiedContentKey to = this.getToKey();
        if (from != null && to != null) {
            Preconditions.checkArgument((boolean)from.contentKey().equals(to.contentKey()), (String)"ContentKeys for from (%s) and to (%s) keys must be equal", (Object)from.contentKey(), (Object)to.contentKey());
        }
    }

    public static Diff of(IdentifiedContentKey fromKey, IdentifiedContentKey toKey, Optional<Content> from, Optional<Content> to) {
        return ImmutableDiff.of(fromKey, toKey, from, to);
    }
}

