/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.IdentifiedContentKey;
import org.projectnessie.versioned.Diff;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Diff", generator="Immutables")
@Immutable
public final class ImmutableDiff
implements Diff {
    @jakarta.annotation.Nullable
    private final IdentifiedContentKey fromKey;
    @jakarta.annotation.Nullable
    private final IdentifiedContentKey toKey;
    @Nullable
    private final Content fromValue;
    @Nullable
    private final Content toValue;

    private ImmutableDiff(@jakarta.annotation.Nullable IdentifiedContentKey fromKey, @jakarta.annotation.Nullable IdentifiedContentKey toKey, Optional<? extends Content> fromValue, Optional<? extends Content> toValue) {
        this.fromKey = fromKey;
        this.toKey = toKey;
        this.fromValue = fromValue.orElse(null);
        this.toValue = toValue.orElse(null);
    }

    private ImmutableDiff(ImmutableDiff original, @jakarta.annotation.Nullable IdentifiedContentKey fromKey, @jakarta.annotation.Nullable IdentifiedContentKey toKey, @Nullable Content fromValue, @Nullable Content toValue) {
        this.fromKey = fromKey;
        this.toKey = toKey;
        this.fromValue = fromValue;
        this.toValue = toValue;
    }

    @Override
    @jakarta.annotation.Nullable
    public IdentifiedContentKey getFromKey() {
        return this.fromKey;
    }

    @Override
    @jakarta.annotation.Nullable
    public IdentifiedContentKey getToKey() {
        return this.toKey;
    }

    @Override
    public Optional<Content> getFromValue() {
        return Optional.ofNullable(this.fromValue);
    }

    @Override
    public Optional<Content> getToValue() {
        return Optional.ofNullable(this.toValue);
    }

    public final ImmutableDiff withFromKey(@jakarta.annotation.Nullable IdentifiedContentKey value) {
        if (this.fromKey == value) {
            return this;
        }
        return ImmutableDiff.validate(new ImmutableDiff(this, value, this.toKey, this.fromValue, this.toValue));
    }

    public final ImmutableDiff withToKey(@jakarta.annotation.Nullable IdentifiedContentKey value) {
        if (this.toKey == value) {
            return this;
        }
        return ImmutableDiff.validate(new ImmutableDiff(this, this.fromKey, value, this.fromValue, this.toValue));
    }

    public final ImmutableDiff withFromValue(Content value) {
        Content newValue = Objects.requireNonNull(value, "fromValue");
        if (this.fromValue == newValue) {
            return this;
        }
        return ImmutableDiff.validate(new ImmutableDiff(this, this.fromKey, this.toKey, newValue, this.toValue));
    }

    public final ImmutableDiff withFromValue(Optional<? extends Content> optional) {
        Content value = optional.orElse(null);
        if (this.fromValue == value) {
            return this;
        }
        return ImmutableDiff.validate(new ImmutableDiff(this, this.fromKey, this.toKey, value, this.toValue));
    }

    public final ImmutableDiff withToValue(Content value) {
        Content newValue = Objects.requireNonNull(value, "toValue");
        if (this.toValue == newValue) {
            return this;
        }
        return ImmutableDiff.validate(new ImmutableDiff(this, this.fromKey, this.toKey, this.fromValue, newValue));
    }

    public final ImmutableDiff withToValue(Optional<? extends Content> optional) {
        Content value = optional.orElse(null);
        if (this.toValue == value) {
            return this;
        }
        return ImmutableDiff.validate(new ImmutableDiff(this, this.fromKey, this.toKey, this.fromValue, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDiff && this.equalTo(0, (ImmutableDiff)another);
    }

    private boolean equalTo(int synthetic, ImmutableDiff another) {
        return Objects.equals(this.fromKey, another.fromKey) && Objects.equals(this.toKey, another.toKey) && Objects.equals(this.fromValue, another.fromValue) && Objects.equals(this.toValue, another.toValue);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.fromKey);
        h += (h << 5) + Objects.hashCode(this.toKey);
        h += (h << 5) + Objects.hashCode(this.fromValue);
        h += (h << 5) + Objects.hashCode(this.toValue);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Diff").omitNullValues().add("fromKey", (Object)this.fromKey).add("toKey", (Object)this.toKey).add("fromValue", (Object)this.fromValue).add("toValue", (Object)this.toValue).toString();
    }

    public static ImmutableDiff of(@jakarta.annotation.Nullable IdentifiedContentKey fromKey, @jakarta.annotation.Nullable IdentifiedContentKey toKey, Optional<? extends Content> fromValue, Optional<? extends Content> toValue) {
        return ImmutableDiff.validate(new ImmutableDiff(fromKey, toKey, fromValue, toValue));
    }

    private static ImmutableDiff validate(ImmutableDiff instance) {
        instance.check();
        return instance;
    }

    public static ImmutableDiff copyOf(Diff instance) {
        if (instance instanceof ImmutableDiff) {
            return (ImmutableDiff)instance;
        }
        return ImmutableDiff.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Diff", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private IdentifiedContentKey fromKey;
        @Nullable
        private IdentifiedContentKey toKey;
        @Nullable
        private Content fromValue;
        @Nullable
        private Content toValue;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Diff instance) {
            Optional<Content> toValueOptional;
            Optional<Content> fromValueOptional;
            IdentifiedContentKey toKeyValue;
            Objects.requireNonNull(instance, "instance");
            IdentifiedContentKey fromKeyValue = instance.getFromKey();
            if (fromKeyValue != null) {
                this.fromKey(fromKeyValue);
            }
            if ((toKeyValue = instance.getToKey()) != null) {
                this.toKey(toKeyValue);
            }
            if ((fromValueOptional = instance.getFromValue()).isPresent()) {
                this.fromValue(fromValueOptional);
            }
            if ((toValueOptional = instance.getToValue()).isPresent()) {
                this.toValue(toValueOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fromKey(@jakarta.annotation.Nullable IdentifiedContentKey fromKey) {
            this.fromKey = fromKey;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toKey(@jakarta.annotation.Nullable IdentifiedContentKey toKey) {
            this.toKey = toKey;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fromValue(Content fromValue) {
            this.fromValue = Objects.requireNonNull(fromValue, "fromValue");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fromValue(Optional<? extends Content> fromValue) {
            this.fromValue = fromValue.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toValue(Content toValue) {
            this.toValue = Objects.requireNonNull(toValue, "toValue");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toValue(Optional<? extends Content> toValue) {
            this.toValue = toValue.orElse(null);
            return this;
        }

        public ImmutableDiff build() {
            return ImmutableDiff.validate(new ImmutableDiff(null, this.fromKey, this.toKey, this.fromValue, this.toValue));
        }
    }
}

