/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.CommitConsistency;
import org.projectnessie.versioned.ReferenceHistory;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReferenceHistory", generator="Immutables")
@Immutable
public final class ImmutableReferenceHistory
implements ReferenceHistory {
    private final ReferenceHistory.ReferenceHistoryElement current;
    private final ImmutableList<ReferenceHistory.ReferenceHistoryElement> previous;
    private final CommitConsistency commitLogConsistency;

    private ImmutableReferenceHistory(ReferenceHistory.ReferenceHistoryElement current, ImmutableList<ReferenceHistory.ReferenceHistoryElement> previous, CommitConsistency commitLogConsistency) {
        this.current = current;
        this.previous = previous;
        this.commitLogConsistency = commitLogConsistency;
    }

    @Override
    public ReferenceHistory.ReferenceHistoryElement current() {
        return this.current;
    }

    public ImmutableList<ReferenceHistory.ReferenceHistoryElement> previous() {
        return this.previous;
    }

    @Override
    public CommitConsistency commitLogConsistency() {
        return this.commitLogConsistency;
    }

    public final ImmutableReferenceHistory withCurrent(ReferenceHistory.ReferenceHistoryElement value) {
        if (this.current == value) {
            return this;
        }
        ReferenceHistory.ReferenceHistoryElement newValue = Objects.requireNonNull(value, "current");
        return new ImmutableReferenceHistory(newValue, this.previous, this.commitLogConsistency);
    }

    public final ImmutableReferenceHistory withPrevious(ReferenceHistory.ReferenceHistoryElement ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableReferenceHistory(this.current, (ImmutableList<ReferenceHistory.ReferenceHistoryElement>)newValue, this.commitLogConsistency);
    }

    public final ImmutableReferenceHistory withPrevious(Iterable<? extends ReferenceHistory.ReferenceHistoryElement> elements) {
        if (this.previous == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableReferenceHistory(this.current, (ImmutableList<ReferenceHistory.ReferenceHistoryElement>)newValue, this.commitLogConsistency);
    }

    public final ImmutableReferenceHistory withCommitLogConsistency(CommitConsistency value) {
        CommitConsistency newValue = Objects.requireNonNull(value, "commitLogConsistency");
        if (this.commitLogConsistency == newValue) {
            return this;
        }
        return new ImmutableReferenceHistory(this.current, this.previous, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReferenceHistory && this.equalTo(0, (ImmutableReferenceHistory)another);
    }

    private boolean equalTo(int synthetic, ImmutableReferenceHistory another) {
        return this.current.equals(another.current) && this.previous.equals(another.previous) && this.commitLogConsistency.equals((Object)another.commitLogConsistency);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.current.hashCode();
        h += (h << 5) + this.previous.hashCode();
        h += (h << 5) + this.commitLogConsistency.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ReferenceHistory").omitNullValues().add("current", (Object)this.current).add("previous", this.previous).add("commitLogConsistency", (Object)this.commitLogConsistency).toString();
    }

    public static ImmutableReferenceHistory copyOf(ReferenceHistory instance) {
        if (instance instanceof ImmutableReferenceHistory) {
            return (ImmutableReferenceHistory)instance;
        }
        return ImmutableReferenceHistory.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ReferenceHistory", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CURRENT = 1L;
        private static final long INIT_BIT_COMMIT_LOG_CONSISTENCY = 2L;
        private long initBits = 3L;
        @Nullable
        private ReferenceHistory.ReferenceHistoryElement current;
        private ImmutableList.Builder<ReferenceHistory.ReferenceHistoryElement> previous = ImmutableList.builder();
        @Nullable
        private CommitConsistency commitLogConsistency;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReferenceHistory instance) {
            Objects.requireNonNull(instance, "instance");
            this.current(instance.current());
            this.addAllPrevious(instance.previous());
            this.commitLogConsistency(instance.commitLogConsistency());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder current(ReferenceHistory.ReferenceHistoryElement current) {
            this.current = Objects.requireNonNull(current, "current");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPrevious(ReferenceHistory.ReferenceHistoryElement element) {
            this.previous.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPrevious(ReferenceHistory.ReferenceHistoryElement ... elements) {
            this.previous.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previous(Iterable<? extends ReferenceHistory.ReferenceHistoryElement> elements) {
            this.previous = ImmutableList.builder();
            return this.addAllPrevious(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPrevious(Iterable<? extends ReferenceHistory.ReferenceHistoryElement> elements) {
            this.previous.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitLogConsistency(CommitConsistency commitLogConsistency) {
            this.commitLogConsistency = Objects.requireNonNull(commitLogConsistency, "commitLogConsistency");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableReferenceHistory build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReferenceHistory(this.current, (ImmutableList<ReferenceHistory.ReferenceHistoryElement>)this.previous.build(), this.commitLogConsistency);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("current");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("commitLogConsistency");
            }
            return "Cannot build ReferenceHistory, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

