/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import java.util.List;
import java.util.stream.Collectors;
import org.projectnessie.error.ReferenceConflicts;
import org.projectnessie.model.Conflict;
import org.projectnessie.model.ContentKey;
import org.projectnessie.versioned.MergeTransplantResultBase;
import org.projectnessie.versioned.ReferenceConflictException;

public class MergeConflictException
extends ReferenceConflictException {
    private final MergeTransplantResultBase mergeResult;

    public MergeConflictException(String message, MergeTransplantResultBase mergeResult) {
        super(ReferenceConflicts.referenceConflicts(MergeConflictException.asReferenceConflicts(mergeResult)), message);
        this.mergeResult = mergeResult;
    }

    private static List<Conflict> asReferenceConflicts(MergeTransplantResultBase mergeResult) {
        return mergeResult.getDetails().entrySet().stream().map(e -> {
            MergeTransplantResultBase.KeyDetails keyDetails = (MergeTransplantResultBase.KeyDetails)e.getValue();
            Conflict conflict = keyDetails.getConflict();
            return conflict != null ? conflict : Conflict.conflict((Conflict.ConflictType)Conflict.ConflictType.KEY_CONFLICT, (ContentKey)((ContentKey)e.getKey()), (String)"UNKNOWN");
        }).collect(Collectors.toList());
    }

    public MergeTransplantResultBase getMergeResult() {
        return this.mergeResult;
    }
}

