/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.paging;

import java.util.Iterator;
import java.util.NoSuchElementException;

public interface PaginationIterator<T>
extends Iterator<T>,
AutoCloseable {
    public String tokenForCurrent();

    public String tokenForEntry(T var1);

    @Override
    public void close();

    public static <T> PaginationIterator<T> of(final T ... values) {
        return new PaginationIterator<T>(){
            int idx = 0;

            @Override
            public String tokenForCurrent() {
                return null;
            }

            @Override
            public String tokenForEntry(T entry) {
                return null;
            }

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return this.idx < values.length;
            }

            @Override
            public T next() {
                return values[this.idx++];
            }
        };
    }

    public static <T> PaginationIterator<T> empty() {
        return new PaginationIterator<T>(){

            @Override
            public String tokenForCurrent() {
                return null;
            }

            @Override
            public String tokenForEntry(T entry) {
                return null;
            }

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public T next() {
                throw new NoSuchElementException();
            }
        };
    }
}

