/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.versioned.MetadataRewriter;

public class DefaultMetadataRewriter
implements MetadataRewriter<CommitMeta> {
    public static final MetadataRewriter<CommitMeta> DEFAULT_METADATA_REWRITER = new DefaultMetadataRewriter(null, null, null, numCommits -> null);
    private final String committer;
    private final Instant now;
    private final CommitMeta commitMetaOverride;
    private final IntFunction<String> squashMessage;

    public DefaultMetadataRewriter(String committer, Instant now, CommitMeta commitMetaOverride, IntFunction<String> squashMessage) {
        this.committer = committer;
        this.now = now;
        this.commitMetaOverride = commitMetaOverride;
        this.squashMessage = squashMessage;
    }

    private CommitMeta buildCommitMeta(ImmutableCommitMeta.Builder metaBuilder, Supplier<String> defaultMessage) {
        ImmutableCommitMeta pre = metaBuilder.message("").build();
        if (DefaultMetadataRewriter.hasAuthors(this.commitMetaOverride)) {
            metaBuilder.allAuthors(Collections.emptyList());
            DefaultMetadataRewriter.copyAuthors(this.commitMetaOverride, arg_0 -> ((ImmutableCommitMeta.Builder)metaBuilder).addAllAuthors(arg_0));
        } else if (!DefaultMetadataRewriter.hasAuthors((CommitMeta)pre) && this.committer != null) {
            metaBuilder.allAuthors(Collections.singletonList(this.committer));
        }
        if (this.commitMetaOverride != null && !this.commitMetaOverride.getAllSignedOffBy().isEmpty()) {
            metaBuilder.allSignedOffBy((Iterable)this.commitMetaOverride.getAllSignedOffBy());
        }
        if (this.commitMetaOverride != null && this.commitMetaOverride.getAuthorTime() != null) {
            metaBuilder.authorTime(this.commitMetaOverride.getAuthorTime());
        } else if (pre.getAuthorTime() == null) {
            metaBuilder.authorTime(this.now);
        }
        if (this.commitMetaOverride != null && !this.commitMetaOverride.getAllProperties().isEmpty()) {
            metaBuilder.allProperties(this.commitMetaOverride.getAllProperties());
        }
        if (this.commitMetaOverride != null && !this.commitMetaOverride.getMessage().isEmpty()) {
            metaBuilder.message(this.commitMetaOverride.getMessage());
        } else {
            metaBuilder.message(defaultMessage.get());
        }
        if (this.committer != null) {
            metaBuilder.committer(this.committer);
        }
        return metaBuilder.commitTime(this.now).build();
    }

    @Override
    public CommitMeta rewriteSingle(CommitMeta metadata) {
        return this.buildCommitMeta(CommitMeta.builder().from(metadata).hash(null).parentCommitHashes(Collections.emptyList()), () -> ((CommitMeta)metadata).getMessage());
    }

    @Override
    public CommitMeta squash(List<CommitMeta> metadata, int numCommits) {
        Optional<String> msg = Optional.ofNullable(this.squashMessage.apply(numCommits));
        if (numCommits == 1 && !msg.isPresent()) {
            return this.rewriteSingle(metadata.get(0));
        }
        HashMap newProperties = new HashMap();
        LinkedHashSet authors = new LinkedHashSet();
        Instant authorTime = null;
        for (CommitMeta commitMeta : metadata) {
            newProperties.putAll(commitMeta.getProperties());
            DefaultMetadataRewriter.copyAuthors(commitMeta, authors::add);
            Instant metaAuthorTime = commitMeta.getAuthorTime();
            if (authorTime != null && (metaAuthorTime == null || authorTime.compareTo(metaAuthorTime) >= 0)) continue;
            authorTime = commitMeta.getAuthorTime();
        }
        ImmutableCommitMeta.Builder newMetaBuilder = CommitMeta.builder().properties(newProperties).allAuthors(authors).authorTime(authorTime);
        return this.buildCommitMeta(newMetaBuilder, () -> msg.orElseGet(() -> {
            StringBuilder newMessage = new StringBuilder();
            for (CommitMeta commitMeta : metadata) {
                if (newMessage.length() > 0) {
                    newMessage.append("\n---------------------------------------------\n");
                }
                newMessage.append(commitMeta.getMessage());
            }
            return newMessage.toString();
        }));
    }

    private static void copyAuthors(CommitMeta commitMeta, Consumer<String> addAuthor) {
        for (String author : commitMeta.getAllAuthors()) {
            if (author == null || author.isEmpty()) continue;
            addAuthor.accept(author);
        }
    }

    private static boolean hasAuthors(CommitMeta commitMeta) {
        if (commitMeta != null) {
            for (String author : commitMeta.getAllAuthors()) {
                if (author == null || author.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }
}

