/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.model.CommitConsistency;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ReferenceHistory;

@Generated(from="ReferenceHistory.ReferenceHistoryElement", generator="Immutables")
public final class ImmutableReferenceHistoryElement
implements ReferenceHistory.ReferenceHistoryElement {
    private final Hash pointer;
    private final CommitConsistency commitConsistency;
    @Nullable
    private final CommitMeta meta;

    private ImmutableReferenceHistoryElement(Hash pointer, CommitConsistency commitConsistency, @Nullable CommitMeta meta) {
        this.pointer = Objects.requireNonNull(pointer, "pointer");
        this.commitConsistency = Objects.requireNonNull(commitConsistency, "commitConsistency");
        this.meta = meta;
    }

    private ImmutableReferenceHistoryElement(ImmutableReferenceHistoryElement original, Hash pointer, CommitConsistency commitConsistency, @Nullable CommitMeta meta) {
        this.pointer = pointer;
        this.commitConsistency = commitConsistency;
        this.meta = meta;
    }

    @Override
    public Hash pointer() {
        return this.pointer;
    }

    @Override
    public CommitConsistency commitConsistency() {
        return this.commitConsistency;
    }

    @Override
    @Nullable
    public CommitMeta meta() {
        return this.meta;
    }

    public final ImmutableReferenceHistoryElement withPointer(Hash value) {
        if (this.pointer == value) {
            return this;
        }
        Hash newValue = Objects.requireNonNull(value, "pointer");
        return new ImmutableReferenceHistoryElement(this, newValue, this.commitConsistency, this.meta);
    }

    public final ImmutableReferenceHistoryElement withCommitConsistency(CommitConsistency value) {
        CommitConsistency newValue = Objects.requireNonNull(value, "commitConsistency");
        if (this.commitConsistency == newValue) {
            return this;
        }
        return new ImmutableReferenceHistoryElement(this, this.pointer, newValue, this.meta);
    }

    public final ImmutableReferenceHistoryElement withMeta(@Nullable CommitMeta value) {
        if (this.meta == value) {
            return this;
        }
        return new ImmutableReferenceHistoryElement(this, this.pointer, this.commitConsistency, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReferenceHistoryElement && this.equalTo(0, (ImmutableReferenceHistoryElement)another);
    }

    private boolean equalTo(int synthetic, ImmutableReferenceHistoryElement another) {
        return this.pointer.equals(another.pointer) && this.commitConsistency.equals((Object)another.commitConsistency) && Objects.equals(this.meta, another.meta);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.pointer.hashCode();
        h += (h << 5) + this.commitConsistency.hashCode();
        h += (h << 5) + Objects.hashCode(this.meta);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ReferenceHistoryElement").omitNullValues().add("pointer", (Object)this.pointer).add("commitConsistency", (Object)this.commitConsistency).add("meta", (Object)this.meta).toString();
    }

    public static ImmutableReferenceHistoryElement of(Hash pointer, CommitConsistency commitConsistency, @Nullable CommitMeta meta) {
        return new ImmutableReferenceHistoryElement(pointer, commitConsistency, meta);
    }

    public static ImmutableReferenceHistoryElement copyOf(ReferenceHistory.ReferenceHistoryElement instance) {
        if (instance instanceof ImmutableReferenceHistoryElement) {
            return (ImmutableReferenceHistoryElement)instance;
        }
        return ImmutableReferenceHistoryElement.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ReferenceHistory.ReferenceHistoryElement", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_POINTER = 1L;
        private static final long INIT_BIT_COMMIT_CONSISTENCY = 2L;
        private long initBits = 3L;
        private Hash pointer;
        private CommitConsistency commitConsistency;
        private CommitMeta meta;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReferenceHistory.ReferenceHistoryElement instance) {
            Objects.requireNonNull(instance, "instance");
            this.pointer(instance.pointer());
            this.commitConsistency(instance.commitConsistency());
            CommitMeta metaValue = instance.meta();
            if (metaValue != null) {
                this.meta(metaValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pointer(Hash pointer) {
            this.pointer = Objects.requireNonNull(pointer, "pointer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitConsistency(CommitConsistency commitConsistency) {
            this.commitConsistency = Objects.requireNonNull(commitConsistency, "commitConsistency");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder meta(@Nullable CommitMeta meta) {
            this.meta = meta;
            return this;
        }

        public ImmutableReferenceHistoryElement build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReferenceHistoryElement(null, this.pointer, this.commitConsistency, this.meta);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pointer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("commitConsistency");
            }
            return "Cannot build ReferenceHistoryElement, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

