/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.versioned.RelativeCommitSpec;

@Generated(from="RelativeCommitSpec", generator="Immutables")
public final class ImmutableRelativeCommitSpec
extends RelativeCommitSpec {
    private final RelativeCommitSpec.Type type;
    private final long longValue;
    private final Instant instantValue;

    private ImmutableRelativeCommitSpec(RelativeCommitSpec.Type type, long longValue, Instant instantValue) {
        this.type = Objects.requireNonNull(type, "type");
        this.longValue = longValue;
        this.instantValue = Objects.requireNonNull(instantValue, "instantValue");
    }

    private ImmutableRelativeCommitSpec(ImmutableRelativeCommitSpec original, RelativeCommitSpec.Type type, long longValue, Instant instantValue) {
        this.type = type;
        this.longValue = longValue;
        this.instantValue = instantValue;
    }

    @Override
    public RelativeCommitSpec.Type type() {
        return this.type;
    }

    @Override
    public long longValue() {
        return this.longValue;
    }

    @Override
    public Instant instantValue() {
        return this.instantValue;
    }

    public final ImmutableRelativeCommitSpec withType(RelativeCommitSpec.Type value) {
        RelativeCommitSpec.Type newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableRelativeCommitSpec(this, newValue, this.longValue, this.instantValue);
    }

    public final ImmutableRelativeCommitSpec withLongValue(long value) {
        if (this.longValue == value) {
            return this;
        }
        return new ImmutableRelativeCommitSpec(this, this.type, value, this.instantValue);
    }

    public final ImmutableRelativeCommitSpec withInstantValue(Instant value) {
        if (this.instantValue == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "instantValue");
        return new ImmutableRelativeCommitSpec(this, this.type, this.longValue, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRelativeCommitSpec && this.equalTo(0, (ImmutableRelativeCommitSpec)another);
    }

    private boolean equalTo(int synthetic, ImmutableRelativeCommitSpec another) {
        return this.type.equals((Object)another.type) && this.longValue == another.longValue && this.instantValue.equals(another.instantValue);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.longValue);
        h += (h << 5) + this.instantValue.hashCode();
        return h;
    }

    public static ImmutableRelativeCommitSpec of(RelativeCommitSpec.Type type, long longValue, Instant instantValue) {
        return new ImmutableRelativeCommitSpec(type, longValue, instantValue);
    }

    public static ImmutableRelativeCommitSpec copyOf(RelativeCommitSpec instance) {
        if (instance instanceof ImmutableRelativeCommitSpec) {
            return (ImmutableRelativeCommitSpec)instance;
        }
        return ImmutableRelativeCommitSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RelativeCommitSpec", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_LONG_VALUE = 2L;
        private static final long INIT_BIT_INSTANT_VALUE = 4L;
        private long initBits = 7L;
        private RelativeCommitSpec.Type type;
        private long longValue;
        private Instant instantValue;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RelativeCommitSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            this.longValue(instance.longValue());
            this.instantValue(instance.instantValue());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(RelativeCommitSpec.Type type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder longValue(long longValue) {
            this.longValue = longValue;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder instantValue(Instant instantValue) {
            this.instantValue = Objects.requireNonNull(instantValue, "instantValue");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableRelativeCommitSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRelativeCommitSpec(null, this.type, this.longValue, this.instantValue);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("longValue");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("instantValue");
            }
            return "Cannot build RelativeCommitSpec, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

