/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.WithHash;

@Generated(from="WithHash", generator="Immutables")
public final class ImmutableWithHash<T>
implements WithHash<T> {
    private final Hash hash;
    private final T value;

    private ImmutableWithHash(Hash hash, T value) {
        this.hash = hash;
        this.value = value;
    }

    @Override
    public Hash getHash() {
        return this.hash;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    public final ImmutableWithHash<T> withHash(Hash value) {
        if (this.hash == value) {
            return this;
        }
        Hash newValue = Objects.requireNonNull(value, "hash");
        return new ImmutableWithHash<T>(newValue, this.value);
    }

    public final ImmutableWithHash<T> withValue(T value) {
        if (this.value == value) {
            return this;
        }
        T newValue = Objects.requireNonNull(value, "value");
        return new ImmutableWithHash<T>(this.hash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWithHash && this.equalTo(0, (ImmutableWithHash)another);
    }

    private boolean equalTo(int synthetic, ImmutableWithHash<?> another) {
        return this.hash.equals(another.hash) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WithHash").omitNullValues().add("hash", (Object)this.hash).add("value", this.value).toString();
    }

    public static <T> ImmutableWithHash<T> copyOf(WithHash<T> instance) {
        if (instance instanceof ImmutableWithHash) {
            return (ImmutableWithHash)instance;
        }
        return ImmutableWithHash.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="WithHash", generator="Immutables")
    public static final class Builder<T> {
        private static final long INIT_BIT_HASH = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        private Hash hash;
        private T value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(WithHash<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.hash(instance.getHash());
            this.value(instance.getValue());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> hash(Hash hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> value(T value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableWithHash<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWithHash<T>(this.hash, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build WithHash, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

