/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.function.BiPredicate;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.versioned.VersionStore;

@Generated(from="VersionStore.KeyRestrictions", generator="Immutables")
public final class ImmutableKeyRestrictions
implements VersionStore.KeyRestrictions {
    @Nullable
    private final ContentKey minKey;
    @Nullable
    private final ContentKey maxKey;
    @Nullable
    private final ContentKey prefixKey;
    @Nullable
    private final BiPredicate<ContentKey, Content.Type> contentKeyPredicate;

    private ImmutableKeyRestrictions(@Nullable ContentKey minKey, @Nullable ContentKey maxKey, @Nullable ContentKey prefixKey, @Nullable BiPredicate<ContentKey, Content.Type> contentKeyPredicate) {
        this.minKey = minKey;
        this.maxKey = maxKey;
        this.prefixKey = prefixKey;
        this.contentKeyPredicate = contentKeyPredicate;
    }

    @Override
    @Nullable
    public ContentKey minKey() {
        return this.minKey;
    }

    @Override
    @Nullable
    public ContentKey maxKey() {
        return this.maxKey;
    }

    @Override
    @Nullable
    public ContentKey prefixKey() {
        return this.prefixKey;
    }

    @Override
    @Nullable
    public BiPredicate<ContentKey, Content.Type> contentKeyPredicate() {
        return this.contentKeyPredicate;
    }

    public final ImmutableKeyRestrictions withMinKey(@Nullable ContentKey value) {
        if (this.minKey == value) {
            return this;
        }
        return new ImmutableKeyRestrictions(value, this.maxKey, this.prefixKey, this.contentKeyPredicate);
    }

    public final ImmutableKeyRestrictions withMaxKey(@Nullable ContentKey value) {
        if (this.maxKey == value) {
            return this;
        }
        return new ImmutableKeyRestrictions(this.minKey, value, this.prefixKey, this.contentKeyPredicate);
    }

    public final ImmutableKeyRestrictions withPrefixKey(@Nullable ContentKey value) {
        if (this.prefixKey == value) {
            return this;
        }
        return new ImmutableKeyRestrictions(this.minKey, this.maxKey, value, this.contentKeyPredicate);
    }

    public final ImmutableKeyRestrictions withContentKeyPredicate(@Nullable BiPredicate<ContentKey, Content.Type> value) {
        if (this.contentKeyPredicate == value) {
            return this;
        }
        return new ImmutableKeyRestrictions(this.minKey, this.maxKey, this.prefixKey, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyRestrictions && this.equalsByValue((ImmutableKeyRestrictions)another);
    }

    private boolean equalsByValue(ImmutableKeyRestrictions another) {
        return Objects.equals(this.minKey, another.minKey) && Objects.equals(this.maxKey, another.maxKey) && Objects.equals(this.prefixKey, another.prefixKey) && Objects.equals(this.contentKeyPredicate, another.contentKeyPredicate);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.minKey);
        h += (h << 5) + Objects.hashCode(this.maxKey);
        h += (h << 5) + Objects.hashCode(this.prefixKey);
        h += (h << 5) + Objects.hashCode(this.contentKeyPredicate);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"KeyRestrictions").omitNullValues().add("minKey", (Object)this.minKey).add("maxKey", (Object)this.maxKey).add("prefixKey", (Object)this.prefixKey).add("contentKeyPredicate", this.contentKeyPredicate).toString();
    }

    public static ImmutableKeyRestrictions copyOf(VersionStore.KeyRestrictions instance) {
        if (instance instanceof ImmutableKeyRestrictions) {
            return (ImmutableKeyRestrictions)instance;
        }
        return ImmutableKeyRestrictions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="VersionStore.KeyRestrictions", generator="Immutables")
    public static final class Builder {
        private ContentKey minKey;
        private ContentKey maxKey;
        private ContentKey prefixKey;
        private BiPredicate<ContentKey, Content.Type> contentKeyPredicate;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(VersionStore.KeyRestrictions instance) {
            BiPredicate<ContentKey, Content.Type> contentKeyPredicateValue;
            ContentKey prefixKeyValue;
            ContentKey maxKeyValue;
            Objects.requireNonNull(instance, "instance");
            ContentKey minKeyValue = instance.minKey();
            if (minKeyValue != null) {
                this.minKey(minKeyValue);
            }
            if ((maxKeyValue = instance.maxKey()) != null) {
                this.maxKey(maxKeyValue);
            }
            if ((prefixKeyValue = instance.prefixKey()) != null) {
                this.prefixKey(prefixKeyValue);
            }
            if ((contentKeyPredicateValue = instance.contentKeyPredicate()) != null) {
                this.contentKeyPredicate(contentKeyPredicateValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder minKey(@Nullable ContentKey minKey) {
            this.minKey = minKey;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maxKey(@Nullable ContentKey maxKey) {
            this.maxKey = maxKey;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder prefixKey(@Nullable ContentKey prefixKey) {
            this.prefixKey = prefixKey;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentKeyPredicate(@Nullable BiPredicate<ContentKey, Content.Type> contentKeyPredicate) {
            this.contentKeyPredicate = contentKeyPredicate;
            return this;
        }

        public ImmutableKeyRestrictions build() {
            return new ImmutableKeyRestrictions(this.minKey, this.maxKey, this.prefixKey, this.contentKeyPredicate);
        }
    }
}

