/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.model.ContentKey;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.MergeTransplantResultBase;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.TransplantResult;

@Generated(from="TransplantResult", generator="Immutables")
public final class ImmutableTransplantResult
implements TransplantResult {
    private final boolean wasApplied;
    private final boolean wasSuccessful;
    @Nullable
    private final Hash resultantTargetHash;
    @Nullable
    private final Hash commonAncestor;
    private final NamedRef sourceRef;
    private final BranchName targetBranch;
    private final Hash effectiveTargetHash;
    @Nullable
    private final Hash expectedHash;
    private final ImmutableList<Commit> createdCommits;
    private final ImmutableMap<ContentKey, MergeTransplantResultBase.KeyDetails> details;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTransplantResult(Builder builder) {
        this.resultantTargetHash = builder.resultantTargetHash;
        this.commonAncestor = builder.commonAncestor;
        this.sourceRef = builder.sourceRef;
        this.targetBranch = builder.targetBranch;
        this.effectiveTargetHash = builder.effectiveTargetHash;
        this.expectedHash = builder.expectedHash;
        this.createdCommits = builder.createdCommits.build();
        this.details = builder.details.build();
        if (builder.wasAppliedIsSet()) {
            this.initShim.wasApplied(builder.wasApplied);
        }
        if (builder.wasSuccessfulIsSet()) {
            this.initShim.wasSuccessful(builder.wasSuccessful);
        }
        this.wasApplied = this.initShim.wasApplied();
        this.wasSuccessful = this.initShim.wasSuccessful();
        this.initShim = null;
    }

    private ImmutableTransplantResult(boolean wasApplied, boolean wasSuccessful, @Nullable Hash resultantTargetHash, @Nullable Hash commonAncestor, NamedRef sourceRef, BranchName targetBranch, Hash effectiveTargetHash, @Nullable Hash expectedHash, ImmutableList<Commit> createdCommits, ImmutableMap<ContentKey, MergeTransplantResultBase.KeyDetails> details) {
        this.wasApplied = wasApplied;
        this.wasSuccessful = wasSuccessful;
        this.resultantTargetHash = resultantTargetHash;
        this.commonAncestor = commonAncestor;
        this.sourceRef = sourceRef;
        this.targetBranch = targetBranch;
        this.effectiveTargetHash = effectiveTargetHash;
        this.expectedHash = expectedHash;
        this.createdCommits = createdCommits;
        this.details = details;
        this.initShim = null;
    }

    private boolean wasAppliedInitialize() {
        return TransplantResult.super.wasApplied();
    }

    private boolean wasSuccessfulInitialize() {
        return TransplantResult.super.wasSuccessful();
    }

    @Override
    public boolean wasApplied() {
        InitShim shim = this.initShim;
        return shim != null ? shim.wasApplied() : this.wasApplied;
    }

    @Override
    public boolean wasSuccessful() {
        InitShim shim = this.initShim;
        return shim != null ? shim.wasSuccessful() : this.wasSuccessful;
    }

    @Override
    @Nullable
    public Hash getResultantTargetHash() {
        return this.resultantTargetHash;
    }

    @Override
    @Nullable
    public Hash getCommonAncestor() {
        return this.commonAncestor;
    }

    @Override
    public NamedRef getSourceRef() {
        return this.sourceRef;
    }

    @Override
    public BranchName getTargetBranch() {
        return this.targetBranch;
    }

    @Override
    public Hash getEffectiveTargetHash() {
        return this.effectiveTargetHash;
    }

    @Override
    @Nullable
    public Hash getExpectedHash() {
        return this.expectedHash;
    }

    public ImmutableList<Commit> getCreatedCommits() {
        return this.createdCommits;
    }

    public ImmutableMap<ContentKey, MergeTransplantResultBase.KeyDetails> getDetails() {
        return this.details;
    }

    public final ImmutableTransplantResult withWasApplied(boolean value) {
        if (this.wasApplied == value) {
            return this;
        }
        return new ImmutableTransplantResult(value, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.createdCommits, this.details);
    }

    public final ImmutableTransplantResult withWasSuccessful(boolean value) {
        if (this.wasSuccessful == value) {
            return this;
        }
        return new ImmutableTransplantResult(this.wasApplied, value, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.createdCommits, this.details);
    }

    public final ImmutableTransplantResult withResultantTargetHash(@Nullable Hash value) {
        if (this.resultantTargetHash == value) {
            return this;
        }
        return new ImmutableTransplantResult(this.wasApplied, this.wasSuccessful, value, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.createdCommits, this.details);
    }

    public final ImmutableTransplantResult withCommonAncestor(@Nullable Hash value) {
        if (this.commonAncestor == value) {
            return this;
        }
        return new ImmutableTransplantResult(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, value, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.createdCommits, this.details);
    }

    public final ImmutableTransplantResult withSourceRef(NamedRef value) {
        if (this.sourceRef == value) {
            return this;
        }
        NamedRef newValue = Objects.requireNonNull(value, "sourceRef");
        return new ImmutableTransplantResult(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, newValue, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.createdCommits, this.details);
    }

    public final ImmutableTransplantResult withTargetBranch(BranchName value) {
        if (this.targetBranch == value) {
            return this;
        }
        BranchName newValue = Objects.requireNonNull(value, "targetBranch");
        return new ImmutableTransplantResult(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, newValue, this.effectiveTargetHash, this.expectedHash, this.createdCommits, this.details);
    }

    public final ImmutableTransplantResult withEffectiveTargetHash(Hash value) {
        if (this.effectiveTargetHash == value) {
            return this;
        }
        Hash newValue = Objects.requireNonNull(value, "effectiveTargetHash");
        return new ImmutableTransplantResult(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, newValue, this.expectedHash, this.createdCommits, this.details);
    }

    public final ImmutableTransplantResult withExpectedHash(@Nullable Hash value) {
        if (this.expectedHash == value) {
            return this;
        }
        return new ImmutableTransplantResult(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, value, this.createdCommits, this.details);
    }

    public final ImmutableTransplantResult withCreatedCommits(Commit ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTransplantResult(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, (ImmutableList<Commit>)newValue, this.details);
    }

    public final ImmutableTransplantResult withCreatedCommits(Iterable<? extends Commit> elements) {
        if (this.createdCommits == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTransplantResult(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, (ImmutableList<Commit>)newValue, this.details);
    }

    public final ImmutableTransplantResult withDetails(Map<? extends ContentKey, ? extends MergeTransplantResultBase.KeyDetails> entries) {
        if (this.details == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableTransplantResult(this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.createdCommits, (ImmutableMap<ContentKey, MergeTransplantResultBase.KeyDetails>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransplantResult && this.equalsByValue((ImmutableTransplantResult)another);
    }

    private boolean equalsByValue(ImmutableTransplantResult another) {
        return this.wasApplied == another.wasApplied && this.wasSuccessful == another.wasSuccessful && Objects.equals(this.resultantTargetHash, another.resultantTargetHash) && Objects.equals(this.commonAncestor, another.commonAncestor) && this.sourceRef.equals(another.sourceRef) && this.targetBranch.equals(another.targetBranch) && this.effectiveTargetHash.equals(another.effectiveTargetHash) && Objects.equals(this.expectedHash, another.expectedHash) && this.createdCommits.equals(another.createdCommits) && this.details.equals(another.details);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.wasApplied);
        h += (h << 5) + Booleans.hashCode((boolean)this.wasSuccessful);
        h += (h << 5) + Objects.hashCode(this.resultantTargetHash);
        h += (h << 5) + Objects.hashCode(this.commonAncestor);
        h += (h << 5) + this.sourceRef.hashCode();
        h += (h << 5) + this.targetBranch.hashCode();
        h += (h << 5) + this.effectiveTargetHash.hashCode();
        h += (h << 5) + Objects.hashCode(this.expectedHash);
        h += (h << 5) + this.createdCommits.hashCode();
        h += (h << 5) + this.details.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TransplantResult").omitNullValues().add("wasApplied", this.wasApplied).add("wasSuccessful", this.wasSuccessful).add("resultantTargetHash", (Object)this.resultantTargetHash).add("commonAncestor", (Object)this.commonAncestor).add("sourceRef", (Object)this.sourceRef).add("targetBranch", (Object)this.targetBranch).add("effectiveTargetHash", (Object)this.effectiveTargetHash).add("expectedHash", (Object)this.expectedHash).add("createdCommits", this.createdCommits).add("details", this.details).toString();
    }

    public static ImmutableTransplantResult copyOf(TransplantResult instance) {
        if (instance instanceof ImmutableTransplantResult) {
            return (ImmutableTransplantResult)instance;
        }
        return ImmutableTransplantResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TransplantResult", generator="Immutables")
    private final class InitShim {
        private byte wasAppliedBuildStage = 0;
        private boolean wasApplied;
        private byte wasSuccessfulBuildStage = 0;
        private boolean wasSuccessful;

        private InitShim() {
        }

        boolean wasApplied() {
            if (this.wasAppliedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.wasAppliedBuildStage == 0) {
                this.wasAppliedBuildStage = (byte)-1;
                this.wasApplied = ImmutableTransplantResult.this.wasAppliedInitialize();
                this.wasAppliedBuildStage = 1;
            }
            return this.wasApplied;
        }

        void wasApplied(boolean wasApplied) {
            this.wasApplied = wasApplied;
            this.wasAppliedBuildStage = 1;
        }

        boolean wasSuccessful() {
            if (this.wasSuccessfulBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.wasSuccessfulBuildStage == 0) {
                this.wasSuccessfulBuildStage = (byte)-1;
                this.wasSuccessful = ImmutableTransplantResult.this.wasSuccessfulInitialize();
                this.wasSuccessfulBuildStage = 1;
            }
            return this.wasSuccessful;
        }

        void wasSuccessful(boolean wasSuccessful) {
            this.wasSuccessful = wasSuccessful;
            this.wasSuccessfulBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.wasAppliedBuildStage == -1) {
                attributes.add("wasApplied");
            }
            if (this.wasSuccessfulBuildStage == -1) {
                attributes.add("wasSuccessful");
            }
            return "Cannot build TransplantResult, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="TransplantResult", generator="Immutables")
    public static final class Builder
    implements TransplantResult.Builder {
        private static final long INIT_BIT_SOURCE_REF = 1L;
        private static final long INIT_BIT_TARGET_BRANCH = 2L;
        private static final long INIT_BIT_EFFECTIVE_TARGET_HASH = 4L;
        private static final long OPT_BIT_WAS_APPLIED = 1L;
        private static final long OPT_BIT_WAS_SUCCESSFUL = 2L;
        private long initBits = 7L;
        private long optBits;
        private boolean wasApplied;
        private boolean wasSuccessful;
        private Hash resultantTargetHash;
        private Hash commonAncestor;
        private NamedRef sourceRef;
        private BranchName targetBranch;
        private Hash effectiveTargetHash;
        private Hash expectedHash;
        private ImmutableList.Builder<Commit> createdCommits = ImmutableList.builder();
        private ImmutableMap.Builder<ContentKey, MergeTransplantResultBase.KeyDetails> details = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TransplantResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(MergeTransplantResultBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            Hash expectedHashValue;
            Hash commonAncestorValue;
            Hash resultantTargetHashValue;
            MergeTransplantResultBase instance;
            long bits = 0L;
            if (object instanceof TransplantResult) {
                instance = (TransplantResult)object;
                if ((bits & 1L) == 0L) {
                    this.targetBranch(instance.getTargetBranch());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.effectiveTargetHash(instance.getEffectiveTargetHash());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllCreatedCommits(instance.getCreatedCommits());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    resultantTargetHashValue = instance.getResultantTargetHash();
                    if (resultantTargetHashValue != null) {
                        this.resultantTargetHash(resultantTargetHashValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.wasSuccessful(instance.wasSuccessful());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    commonAncestorValue = instance.getCommonAncestor();
                    if (commonAncestorValue != null) {
                        this.commonAncestor(commonAncestorValue);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    expectedHashValue = instance.getExpectedHash();
                    if (expectedHashValue != null) {
                        this.expectedHash(expectedHashValue);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.putAllDetails(instance.getDetails());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.sourceRef(instance.getSourceRef());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.wasApplied(instance.wasApplied());
                    bits |= 0x200L;
                }
            }
            if (object instanceof MergeTransplantResultBase) {
                instance = (MergeTransplantResultBase)object;
                if ((bits & 1L) == 0L) {
                    this.targetBranch(instance.getTargetBranch());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.effectiveTargetHash(instance.getEffectiveTargetHash());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllCreatedCommits(instance.getCreatedCommits());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    resultantTargetHashValue = instance.getResultantTargetHash();
                    if (resultantTargetHashValue != null) {
                        this.resultantTargetHash(resultantTargetHashValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.wasSuccessful(instance.wasSuccessful());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    commonAncestorValue = instance.getCommonAncestor();
                    if (commonAncestorValue != null) {
                        this.commonAncestor(commonAncestorValue);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    expectedHashValue = instance.getExpectedHash();
                    if (expectedHashValue != null) {
                        this.expectedHash(expectedHashValue);
                    }
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.putAllDetails(instance.getDetails());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.sourceRef(instance.getSourceRef());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.wasApplied(instance.wasApplied());
                    bits |= 0x200L;
                }
            }
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder wasApplied(boolean wasApplied) {
            this.wasApplied = wasApplied;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder wasSuccessful(boolean wasSuccessful) {
            this.wasSuccessful = wasSuccessful;
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder resultantTargetHash(@Nullable Hash resultantTargetHash) {
            this.resultantTargetHash = resultantTargetHash;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder commonAncestor(@Nullable Hash commonAncestor) {
            this.commonAncestor = commonAncestor;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder sourceRef(NamedRef sourceRef) {
            this.sourceRef = Objects.requireNonNull(sourceRef, "sourceRef");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder targetBranch(BranchName targetBranch) {
            this.targetBranch = Objects.requireNonNull(targetBranch, "targetBranch");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder effectiveTargetHash(Hash effectiveTargetHash) {
            this.effectiveTargetHash = Objects.requireNonNull(effectiveTargetHash, "effectiveTargetHash");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder expectedHash(@Nullable Hash expectedHash) {
            this.expectedHash = expectedHash;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addCreatedCommits(Commit element) {
            this.createdCommits.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCreatedCommits(Commit ... elements) {
            this.createdCommits.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder createdCommits(Iterable<? extends Commit> elements) {
            this.createdCommits = ImmutableList.builder();
            return this.addAllCreatedCommits(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCreatedCommits(Iterable<? extends Commit> elements) {
            this.createdCommits.addAll(elements);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder putDetails(ContentKey key, MergeTransplantResultBase.KeyDetails value) {
            this.details.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putDetails(Map.Entry<? extends ContentKey, ? extends MergeTransplantResultBase.KeyDetails> entry) {
            this.details.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder details(Map<? extends ContentKey, ? extends MergeTransplantResultBase.KeyDetails> entries) {
            this.details = ImmutableMap.builder();
            return this.putAllDetails(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllDetails(Map<? extends ContentKey, ? extends MergeTransplantResultBase.KeyDetails> entries) {
            this.details.putAll(entries);
            return this;
        }

        @Override
        public ImmutableTransplantResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransplantResult(this);
        }

        private boolean wasAppliedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean wasSuccessfulIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceRef");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("targetBranch");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("effectiveTargetHash");
            }
            return "Cannot build TransplantResult, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

