/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.immutables.value.Value;
import org.projectnessie.model.ContentKey;
import org.projectnessie.versioned.ImmutableRequestMeta;

@Value.Immutable
@Value.Style(allParameters=true)
public interface RequestMeta {
    public static final RequestMeta API_WRITE = RequestMeta.apiWrite().build();
    public static final RequestMeta API_READ = RequestMeta.apiRead().build();

    public boolean forWrite();

    @Value.Default
    default public Map<ContentKey, Set<String>> keyActions() {
        return Map.of();
    }

    default public Set<String> keyActions(ContentKey key) {
        return this.keyActions().getOrDefault(key, Set.of());
    }

    public static RequestMetaBuilder apiWrite() {
        return new RequestMetaBuilder().forWrite(true);
    }

    public static RequestMetaBuilder apiRead() {
        return new RequestMetaBuilder().forWrite(false);
    }

    public static final class RequestMetaBuilder {
        private final Map<ContentKey, Set<String>> keyActions = new HashMap<ContentKey, Set<String>>();
        private boolean forWrite;

        public RequestMetaBuilder forWrite(boolean forWrite) {
            this.forWrite = forWrite;
            return this;
        }

        public RequestMetaBuilder addKeyAction(ContentKey key, String name) {
            this.keyActions.computeIfAbsent(key, x -> new HashSet()).add(name);
            return this;
        }

        public RequestMetaBuilder addKeyActions(ContentKey key, Set<String> names) {
            this.keyActions.computeIfAbsent(key, x -> new HashSet()).addAll(names);
            return this;
        }

        public RequestMetaBuilder newBuilder() {
            RequestMetaBuilder newBuilder = new RequestMetaBuilder().forWrite(this.forWrite);
            this.keyActions.forEach(newBuilder::addKeyActions);
            return newBuilder;
        }

        public RequestMeta build() {
            ImmutableMap.Builder immutableKeyActions = ImmutableMap.builder();
            this.keyActions.forEach((k, v) -> immutableKeyActions.put(k, Set.copyOf(v)));
            return ImmutableRequestMeta.of(this.forWrite, (Map<? extends ContentKey, ? extends Set<String>>)immutableKeyActions.build());
        }
    }
}

