/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceAssignedResult;

@Generated(from="ReferenceAssignedResult", generator="Immutables")
public final class ImmutableReferenceAssignedResult
implements ReferenceAssignedResult {
    private final NamedRef namedRef;
    private final Hash previousHash;
    private final Hash currentHash;

    private ImmutableReferenceAssignedResult(NamedRef namedRef, Hash previousHash, Hash currentHash) {
        this.namedRef = namedRef;
        this.previousHash = previousHash;
        this.currentHash = currentHash;
    }

    @Override
    public NamedRef getNamedRef() {
        return this.namedRef;
    }

    @Override
    public Hash getPreviousHash() {
        return this.previousHash;
    }

    @Override
    public Hash getCurrentHash() {
        return this.currentHash;
    }

    public final ImmutableReferenceAssignedResult withNamedRef(NamedRef value) {
        if (this.namedRef == value) {
            return this;
        }
        NamedRef newValue = Objects.requireNonNull(value, "namedRef");
        return new ImmutableReferenceAssignedResult(newValue, this.previousHash, this.currentHash);
    }

    public final ImmutableReferenceAssignedResult withPreviousHash(Hash value) {
        if (this.previousHash == value) {
            return this;
        }
        Hash newValue = Objects.requireNonNull(value, "previousHash");
        return new ImmutableReferenceAssignedResult(this.namedRef, newValue, this.currentHash);
    }

    public final ImmutableReferenceAssignedResult withCurrentHash(Hash value) {
        if (this.currentHash == value) {
            return this;
        }
        Hash newValue = Objects.requireNonNull(value, "currentHash");
        return new ImmutableReferenceAssignedResult(this.namedRef, this.previousHash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReferenceAssignedResult && this.equalsByValue((ImmutableReferenceAssignedResult)another);
    }

    private boolean equalsByValue(ImmutableReferenceAssignedResult another) {
        return this.namedRef.equals(another.namedRef) && this.previousHash.equals(another.previousHash) && this.currentHash.equals(another.currentHash);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.namedRef.hashCode();
        h += (h << 5) + this.previousHash.hashCode();
        h += (h << 5) + this.currentHash.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ReferenceAssignedResult").omitNullValues().add("namedRef", (Object)this.namedRef).add("previousHash", (Object)this.previousHash).add("currentHash", (Object)this.currentHash).toString();
    }

    public static ImmutableReferenceAssignedResult copyOf(ReferenceAssignedResult instance) {
        if (instance instanceof ImmutableReferenceAssignedResult) {
            return (ImmutableReferenceAssignedResult)instance;
        }
        return ImmutableReferenceAssignedResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ReferenceAssignedResult", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAMED_REF = 1L;
        private static final long INIT_BIT_PREVIOUS_HASH = 2L;
        private static final long INIT_BIT_CURRENT_HASH = 4L;
        private long initBits = 7L;
        private NamedRef namedRef;
        private Hash previousHash;
        private Hash currentHash;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReferenceAssignedResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.namedRef(instance.getNamedRef());
            this.previousHash(instance.getPreviousHash());
            this.currentHash(instance.getCurrentHash());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder namedRef(NamedRef namedRef) {
            this.namedRef = Objects.requireNonNull(namedRef, "namedRef");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder previousHash(Hash previousHash) {
            this.previousHash = Objects.requireNonNull(previousHash, "previousHash");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder currentHash(Hash currentHash) {
            this.currentHash = Objects.requireNonNull(currentHash, "currentHash");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableReferenceAssignedResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReferenceAssignedResult(this.namedRef, this.previousHash, this.currentHash);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("namedRef");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("previousHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("currentHash");
            }
            return "Cannot build ReferenceAssignedResult, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

