/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceInfo;

@Generated(from="ReferenceInfo", generator="Immutables")
public final class ImmutableReferenceInfo<METADATA>
implements ReferenceInfo<METADATA> {
    private final NamedRef namedRef;
    private final Hash hash;
    private final long commitSeq;
    @Nullable
    private final Hash commonAncestor;
    @Nullable
    private final ReferenceInfo.CommitsAheadBehind aheadBehind;
    @Nullable
    private final METADATA headCommitMeta;
    private final ImmutableList<Hash> parentHashes;

    private ImmutableReferenceInfo(Builder<METADATA> builder) {
        this.namedRef = builder.namedRef;
        this.hash = builder.hash;
        this.commonAncestor = builder.commonAncestor;
        this.aheadBehind = builder.aheadBehind;
        this.headCommitMeta = builder.headCommitMeta;
        this.parentHashes = builder.parentHashes.build();
        this.commitSeq = builder.commitSeqIsSet() ? builder.commitSeq : ReferenceInfo.super.getCommitSeq();
    }

    private ImmutableReferenceInfo(NamedRef namedRef, Hash hash, long commitSeq, @Nullable Hash commonAncestor, @Nullable ReferenceInfo.CommitsAheadBehind aheadBehind, @Nullable METADATA headCommitMeta, ImmutableList<Hash> parentHashes) {
        this.namedRef = namedRef;
        this.hash = hash;
        this.commitSeq = commitSeq;
        this.commonAncestor = commonAncestor;
        this.aheadBehind = aheadBehind;
        this.headCommitMeta = headCommitMeta;
        this.parentHashes = parentHashes;
    }

    @Override
    public NamedRef getNamedRef() {
        return this.namedRef;
    }

    @Override
    public Hash getHash() {
        return this.hash;
    }

    @Override
    public long getCommitSeq() {
        return this.commitSeq;
    }

    @Override
    @Nullable
    public Hash getCommonAncestor() {
        return this.commonAncestor;
    }

    @Override
    @Nullable
    public ReferenceInfo.CommitsAheadBehind getAheadBehind() {
        return this.aheadBehind;
    }

    @Override
    @Nullable
    public METADATA getHeadCommitMeta() {
        return this.headCommitMeta;
    }

    public ImmutableList<Hash> getParentHashes() {
        return this.parentHashes;
    }

    public final ImmutableReferenceInfo<METADATA> withNamedRef(NamedRef value) {
        if (this.namedRef == value) {
            return this;
        }
        NamedRef newValue = Objects.requireNonNull(value, "namedRef");
        return new ImmutableReferenceInfo<METADATA>(newValue, this.hash, this.commitSeq, this.commonAncestor, this.aheadBehind, this.headCommitMeta, this.parentHashes);
    }

    public final ImmutableReferenceInfo<METADATA> withHash(Hash value) {
        if (this.hash == value) {
            return this;
        }
        Hash newValue = Objects.requireNonNull(value, "hash");
        return new ImmutableReferenceInfo<METADATA>(this.namedRef, newValue, this.commitSeq, this.commonAncestor, this.aheadBehind, this.headCommitMeta, this.parentHashes);
    }

    public final ImmutableReferenceInfo<METADATA> withCommitSeq(long value) {
        if (this.commitSeq == value) {
            return this;
        }
        return new ImmutableReferenceInfo<METADATA>(this.namedRef, this.hash, value, this.commonAncestor, this.aheadBehind, this.headCommitMeta, this.parentHashes);
    }

    @Override
    public final ImmutableReferenceInfo<METADATA> withCommonAncestor(@Nullable Hash value) {
        if (this.commonAncestor == value) {
            return this;
        }
        return new ImmutableReferenceInfo<METADATA>(this.namedRef, this.hash, this.commitSeq, value, this.aheadBehind, this.headCommitMeta, this.parentHashes);
    }

    @Override
    public final ImmutableReferenceInfo<METADATA> withAheadBehind(@Nullable ReferenceInfo.CommitsAheadBehind value) {
        if (this.aheadBehind == value) {
            return this;
        }
        return new ImmutableReferenceInfo<METADATA>(this.namedRef, this.hash, this.commitSeq, this.commonAncestor, value, this.headCommitMeta, this.parentHashes);
    }

    @Override
    public final ImmutableReferenceInfo<METADATA> withHeadCommitMeta(@Nullable METADATA value) {
        if (this.headCommitMeta == value) {
            return this;
        }
        return new ImmutableReferenceInfo<METADATA>(this.namedRef, this.hash, this.commitSeq, this.commonAncestor, this.aheadBehind, value, this.parentHashes);
    }

    public final ImmutableReferenceInfo<METADATA> withParentHashes(Hash ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableReferenceInfo<METADATA>(this.namedRef, this.hash, this.commitSeq, this.commonAncestor, this.aheadBehind, this.headCommitMeta, (ImmutableList<Hash>)newValue);
    }

    public final ImmutableReferenceInfo<METADATA> withParentHashes(Iterable<? extends Hash> elements) {
        if (this.parentHashes == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableReferenceInfo<METADATA>(this.namedRef, this.hash, this.commitSeq, this.commonAncestor, this.aheadBehind, this.headCommitMeta, (ImmutableList<Hash>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReferenceInfo && this.equalsByValue((ImmutableReferenceInfo)another);
    }

    private boolean equalsByValue(ImmutableReferenceInfo<?> another) {
        return this.namedRef.equals(another.namedRef) && this.hash.equals(another.hash) && this.commitSeq == another.commitSeq && Objects.equals(this.commonAncestor, another.commonAncestor) && Objects.equals(this.aheadBehind, another.aheadBehind) && Objects.equals(this.headCommitMeta, another.headCommitMeta) && this.parentHashes.equals(another.parentHashes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.namedRef.hashCode();
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.commitSeq);
        h += (h << 5) + Objects.hashCode(this.commonAncestor);
        h += (h << 5) + Objects.hashCode(this.aheadBehind);
        h += (h << 5) + Objects.hashCode(this.headCommitMeta);
        h += (h << 5) + this.parentHashes.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ReferenceInfo").omitNullValues().add("namedRef", (Object)this.namedRef).add("hash", (Object)this.hash).add("commitSeq", this.commitSeq).add("commonAncestor", (Object)this.commonAncestor).add("aheadBehind", (Object)this.aheadBehind).add("headCommitMeta", this.headCommitMeta).add("parentHashes", this.parentHashes).toString();
    }

    public static <METADATA> ImmutableReferenceInfo<METADATA> copyOf(ReferenceInfo<METADATA> instance) {
        if (instance instanceof ImmutableReferenceInfo) {
            return (ImmutableReferenceInfo)instance;
        }
        return ImmutableReferenceInfo.builder().from(instance).build();
    }

    public static <METADATA> Builder<METADATA> builder() {
        return new Builder();
    }

    @Generated(from="ReferenceInfo", generator="Immutables")
    public static final class Builder<METADATA> {
        private static final long INIT_BIT_NAMED_REF = 1L;
        private static final long INIT_BIT_HASH = 2L;
        private static final long OPT_BIT_COMMIT_SEQ = 1L;
        private long initBits = 3L;
        private long optBits;
        private NamedRef namedRef;
        private Hash hash;
        private long commitSeq;
        private Hash commonAncestor;
        private ReferenceInfo.CommitsAheadBehind aheadBehind;
        private METADATA headCommitMeta;
        private ImmutableList.Builder<Hash> parentHashes = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<METADATA> from(ReferenceInfo<METADATA> instance) {
            METADATA headCommitMetaValue;
            ReferenceInfo.CommitsAheadBehind aheadBehindValue;
            Objects.requireNonNull(instance, "instance");
            this.namedRef(instance.getNamedRef());
            this.hash(instance.getHash());
            this.commitSeq(instance.getCommitSeq());
            Hash commonAncestorValue = instance.getCommonAncestor();
            if (commonAncestorValue != null) {
                this.commonAncestor(commonAncestorValue);
            }
            if ((aheadBehindValue = instance.getAheadBehind()) != null) {
                this.aheadBehind(aheadBehindValue);
            }
            if ((headCommitMetaValue = instance.getHeadCommitMeta()) != null) {
                this.headCommitMeta(headCommitMetaValue);
            }
            this.addAllParentHashes(instance.getParentHashes());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<METADATA> namedRef(NamedRef namedRef) {
            this.namedRef = Objects.requireNonNull(namedRef, "namedRef");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<METADATA> hash(Hash hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<METADATA> commitSeq(long commitSeq) {
            this.commitSeq = commitSeq;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<METADATA> commonAncestor(@Nullable Hash commonAncestor) {
            this.commonAncestor = commonAncestor;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<METADATA> aheadBehind(@Nullable ReferenceInfo.CommitsAheadBehind aheadBehind) {
            this.aheadBehind = aheadBehind;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<METADATA> headCommitMeta(@Nullable METADATA headCommitMeta) {
            this.headCommitMeta = headCommitMeta;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<METADATA> addParentHashes(Hash element) {
            this.parentHashes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<METADATA> addParentHashes(Hash ... elements) {
            this.parentHashes.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<METADATA> parentHashes(Iterable<? extends Hash> elements) {
            this.parentHashes = ImmutableList.builder();
            return this.addAllParentHashes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder<METADATA> addAllParentHashes(Iterable<? extends Hash> elements) {
            this.parentHashes.addAll(elements);
            return this;
        }

        public ImmutableReferenceInfo<METADATA> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReferenceInfo(this);
        }

        private boolean commitSeqIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("namedRef");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build ReferenceInfo, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

