/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.ContentAttachment;
import org.projectnessie.versioned.ContentAttachmentKey;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ContentAttachment", generator="Immutables")
@Immutable
public final class ImmutableContentAttachment
implements ContentAttachment {
    private final ContentAttachmentKey key;
    @jakarta.annotation.Nullable
    private final Long objectId;
    private final ContentAttachment.Format format;
    private final ContentAttachment.Compression compression;
    private final ByteString data;
    @jakarta.annotation.Nullable
    private final String version;

    private ImmutableContentAttachment(ContentAttachmentKey key, @jakarta.annotation.Nullable Long objectId, ContentAttachment.Format format, ContentAttachment.Compression compression, ByteString data, @jakarta.annotation.Nullable String version) {
        this.key = key;
        this.objectId = objectId;
        this.format = format;
        this.compression = compression;
        this.data = data;
        this.version = version;
    }

    @Override
    public ContentAttachmentKey getKey() {
        return this.key;
    }

    @Override
    @jakarta.annotation.Nullable
    public Long getObjectId() {
        return this.objectId;
    }

    @Override
    public ContentAttachment.Format getFormat() {
        return this.format;
    }

    @Override
    public ContentAttachment.Compression getCompression() {
        return this.compression;
    }

    @Override
    public ByteString getData() {
        return this.data;
    }

    @Override
    @jakarta.annotation.Nullable
    public String getVersion() {
        return this.version;
    }

    public final ImmutableContentAttachment withKey(ContentAttachmentKey value) {
        if (this.key == value) {
            return this;
        }
        ContentAttachmentKey newValue = Objects.requireNonNull(value, "key");
        return new ImmutableContentAttachment(newValue, this.objectId, this.format, this.compression, this.data, this.version);
    }

    public final ImmutableContentAttachment withObjectId(@jakarta.annotation.Nullable Long value) {
        if (Objects.equals(this.objectId, value)) {
            return this;
        }
        return new ImmutableContentAttachment(this.key, value, this.format, this.compression, this.data, this.version);
    }

    public final ImmutableContentAttachment withFormat(ContentAttachment.Format value) {
        ContentAttachment.Format newValue = Objects.requireNonNull(value, "format");
        if (this.format == newValue) {
            return this;
        }
        return new ImmutableContentAttachment(this.key, this.objectId, newValue, this.compression, this.data, this.version);
    }

    public final ImmutableContentAttachment withCompression(ContentAttachment.Compression value) {
        ContentAttachment.Compression newValue = Objects.requireNonNull(value, "compression");
        if (this.compression == newValue) {
            return this;
        }
        return new ImmutableContentAttachment(this.key, this.objectId, this.format, newValue, this.data, this.version);
    }

    public final ImmutableContentAttachment withData(ByteString value) {
        if (this.data == value) {
            return this;
        }
        ByteString newValue = Objects.requireNonNull(value, "data");
        return new ImmutableContentAttachment(this.key, this.objectId, this.format, this.compression, newValue, this.version);
    }

    public final ImmutableContentAttachment withVersion(@jakarta.annotation.Nullable String value) {
        if (Objects.equals(this.version, value)) {
            return this;
        }
        return new ImmutableContentAttachment(this.key, this.objectId, this.format, this.compression, this.data, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContentAttachment && this.equalTo(0, (ImmutableContentAttachment)another);
    }

    private boolean equalTo(int synthetic, ImmutableContentAttachment another) {
        return this.key.equals(another.key) && Objects.equals(this.objectId, another.objectId) && this.format.equals((Object)another.format) && this.compression.equals((Object)another.compression) && this.data.equals((Object)another.data) && Objects.equals(this.version, another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + Objects.hashCode(this.objectId);
        h += (h << 5) + this.format.hashCode();
        h += (h << 5) + this.compression.hashCode();
        h += (h << 5) + this.data.hashCode();
        h += (h << 5) + Objects.hashCode(this.version);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ContentAttachment").omitNullValues().add("key", (Object)this.key).add("objectId", (Object)this.objectId).add("format", (Object)this.format).add("compression", (Object)this.compression).add("data", (Object)this.data).add("version", (Object)this.version).toString();
    }

    public static ImmutableContentAttachment copyOf(ContentAttachment instance) {
        if (instance instanceof ImmutableContentAttachment) {
            return (ImmutableContentAttachment)instance;
        }
        return ImmutableContentAttachment.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ContentAttachment", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_FORMAT = 2L;
        private static final long INIT_BIT_COMPRESSION = 4L;
        private static final long INIT_BIT_DATA = 8L;
        private long initBits = 15L;
        @Nullable
        private ContentAttachmentKey key;
        @Nullable
        private Long objectId;
        @Nullable
        private ContentAttachment.Format format;
        @Nullable
        private ContentAttachment.Compression compression;
        @Nullable
        private ByteString data;
        @Nullable
        private String version;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ContentAttachment instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.getKey());
            Long objectIdValue = instance.getObjectId();
            if (objectIdValue != null) {
                this.objectId(objectIdValue);
            }
            this.format(instance.getFormat());
            this.compression(instance.getCompression());
            this.data(instance.getData());
            String versionValue = instance.getVersion();
            if (versionValue != null) {
                this.version(versionValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(ContentAttachmentKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder objectId(@jakarta.annotation.Nullable Long objectId) {
            this.objectId = objectId;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder format(ContentAttachment.Format format) {
            this.format = Objects.requireNonNull(format, "format");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder compression(ContentAttachment.Compression compression) {
            this.compression = Objects.requireNonNull(compression, "compression");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder data(ByteString data) {
            this.data = Objects.requireNonNull(data, "data");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(@jakarta.annotation.Nullable String version) {
            this.version = version;
            return this;
        }

        public ImmutableContentAttachment build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContentAttachment(this.key, this.objectId, this.format, this.compression, this.data, this.version);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("format");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("compression");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("data");
            }
            return "Cannot build ContentAttachment, some of required attributes are not set " + attributes;
        }
    }
}

