/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.annotations.VisibleForTesting;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import jakarta.annotation.Nonnull;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.KeyEntry;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.MergeType;
import org.projectnessie.versioned.MetadataRewriter;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.RefLogDetails;
import org.projectnessie.versioned.RefLogNotFoundException;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.TracingUtil;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.paging.PaginationIterator;

public class TracingVersionStore
implements VersionStore {
    private static final String TAG_OPERATION = "nessie.version-store.operation";
    private static final String TAG_REF = "nessie.version-store.ref";
    private static final String TAG_BRANCH = "nessie.version-store.branch";
    private static final String TAG_HASH = "nessie.version-store.hash";
    private static final String TAG_NUM_OPS = "nessie.version-store.num-ops";
    private static final String TAG_TARGET_BRANCH = "nessie.version-store.target-branch";
    private static final String TAG_TRANSPLANTS = "nessie.version-store.transplants";
    private static final String TAG_FROM_HASH = "nessie.version-store.from-hash";
    private static final String TAG_TO_BRANCH = "nessie.version-store.to-branch";
    private static final String TAG_EXPECTED_HASH = "nessie.version-store.expected-hash";
    private static final String TAG_TARGET_HASH = "nessie.version-store.target-hash";
    private static final String TAG_KEY = "nessie.version-store.key";
    private static final String TAG_KEYS = "nessie.version-store.keys";
    private static final String TAG_FROM = "nessie.version-store.from";
    private static final String TAG_TO = "nessie.version-store.to";
    private final VersionStore delegate;

    public TracingVersionStore(VersionStore delegate) {
        this.delegate = delegate;
    }

    @Override
    public Hash hashOnReference(NamedRef namedReference, Optional<Hash> hashOnReference) throws ReferenceNotFoundException {
        return TracingVersionStore.callWithOneException("HashOnReference", b -> b.withTag(TAG_REF, TracingVersionStore.safeRefName(namedReference)).withTag(TAG_HASH, TracingUtil.safeToString(hashOnReference)), () -> this.delegate.hashOnReference(namedReference, hashOnReference));
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public Hash noAncestorHash() {
        return this.delegate.noAncestorHash();
    }

    @Override
    public Hash commit(@javax.annotation.Nonnull @Nonnull BranchName branch, @javax.annotation.Nonnull @Nonnull Optional<Hash> referenceHash, @javax.annotation.Nonnull @Nonnull CommitMeta metadata, @javax.annotation.Nonnull @Nonnull List<Operation> operations, @javax.annotation.Nonnull @Nonnull Callable<Void> validator, @javax.annotation.Nonnull @Nonnull BiConsumer<Key, String> addedContents) throws ReferenceNotFoundException, ReferenceConflictException {
        return TracingVersionStore.callWithTwoExceptions("Commit", (Tracer.SpanBuilder b) -> b.withTag(TAG_BRANCH, TracingVersionStore.safeRefName(branch)).withTag(TAG_HASH, TracingUtil.safeToString(referenceHash)).withTag(TAG_NUM_OPS, (Number)TracingUtil.safeSize(operations)), () -> this.delegate.commit(branch, referenceHash, metadata, operations, validator, addedContents));
    }

    @Override
    public MergeResult<Commit> transplant(BranchName targetBranch, Optional<Hash> referenceHash, List<Hash> sequenceToTransplant, MetadataRewriter<CommitMeta> updateCommitMetadata, boolean keepIndividualCommits, Map<Key, MergeType> mergeTypes, MergeType defaultMergeType, boolean dryRun, boolean fetchAdditionalInfo) throws ReferenceNotFoundException, ReferenceConflictException {
        return TracingVersionStore.callWithTwoExceptions("Transplant", (Tracer.SpanBuilder b) -> b.withTag(TAG_TARGET_BRANCH, TracingVersionStore.safeRefName(targetBranch)).withTag(TAG_HASH, TracingUtil.safeToString(referenceHash)).withTag(TAG_TRANSPLANTS, (Number)TracingUtil.safeSize(sequenceToTransplant)), () -> this.delegate.transplant(targetBranch, referenceHash, sequenceToTransplant, updateCommitMetadata, keepIndividualCommits, mergeTypes, defaultMergeType, dryRun, fetchAdditionalInfo));
    }

    @Override
    public MergeResult<Commit> merge(Hash fromHash, BranchName toBranch, Optional<Hash> expectedHash, MetadataRewriter<CommitMeta> updateCommitMetadata, boolean keepIndividualCommits, Map<Key, MergeType> mergeTypes, MergeType defaultMergeType, boolean dryRun, boolean fetchAdditionalInfo) throws ReferenceNotFoundException, ReferenceConflictException {
        return TracingVersionStore.callWithTwoExceptions("Merge", (Tracer.SpanBuilder b) -> b.withTag(TAG_FROM_HASH, TracingUtil.safeToString(fromHash)).withTag(TAG_TO_BRANCH, TracingVersionStore.safeRefName(toBranch)).withTag(TAG_EXPECTED_HASH, TracingUtil.safeToString(expectedHash)), () -> this.delegate.merge(fromHash, toBranch, expectedHash, updateCommitMetadata, keepIndividualCommits, mergeTypes, defaultMergeType, dryRun, fetchAdditionalInfo));
    }

    @Override
    public void assign(NamedRef ref, Optional<Hash> expectedHash, Hash targetHash) throws ReferenceNotFoundException, ReferenceConflictException {
        TracingVersionStore.callWithTwoExceptions("Assign", (Tracer.SpanBuilder b) -> b.withTag(TAG_REF, TracingUtil.safeToString(ref)).withTag(TAG_EXPECTED_HASH, TracingUtil.safeToString(expectedHash)).withTag(TAG_TARGET_HASH, TracingUtil.safeToString(targetHash)), () -> this.delegate.assign(ref, expectedHash, targetHash));
    }

    @Override
    public Hash create(NamedRef ref, Optional<Hash> targetHash) throws ReferenceNotFoundException, ReferenceAlreadyExistsException {
        return TracingVersionStore.callWithTwoExceptions("Create", (Tracer.SpanBuilder b) -> b.withTag(TAG_REF, TracingUtil.safeToString(ref)).withTag(TAG_TARGET_HASH, TracingUtil.safeToString(targetHash)), () -> this.delegate.create(ref, targetHash));
    }

    @Override
    public Hash delete(NamedRef ref, Optional<Hash> hash) throws ReferenceNotFoundException, ReferenceConflictException {
        return TracingVersionStore.callWithTwoExceptions("Delete", (Tracer.SpanBuilder b) -> b.withTag(TAG_REF, TracingUtil.safeToString(ref)).withTag(TAG_HASH, TracingUtil.safeToString(hash)), () -> this.delegate.delete(ref, hash));
    }

    @Override
    public ReferenceInfo<CommitMeta> getNamedRef(String ref, GetNamedRefsParams params) throws ReferenceNotFoundException {
        return TracingVersionStore.callWithOneException("GetNamedRef", b -> b.withTag(TAG_REF, ref), () -> this.delegate.getNamedRef(ref, params));
    }

    @Override
    public PaginationIterator<ReferenceInfo<CommitMeta>> getNamedRefs(GetNamedRefsParams params, String pagingToken) throws ReferenceNotFoundException {
        return TracingVersionStore.callPaginationIterator("GetNamedRefs", b -> {}, () -> this.delegate.getNamedRefs(params, pagingToken));
    }

    @Override
    public PaginationIterator<Commit> getCommits(Ref ref, boolean fetchAdditionalInfo) throws ReferenceNotFoundException {
        return TracingVersionStore.callPaginationIterator("GetCommits", b -> b.withTag(TAG_REF, TracingUtil.safeToString(ref)), () -> this.delegate.getCommits(ref, fetchAdditionalInfo));
    }

    @Override
    public PaginationIterator<KeyEntry> getKeys(Ref ref, String pagingToken, boolean withContent) throws ReferenceNotFoundException {
        return TracingVersionStore.callPaginationIterator("GetKeys", b -> b.withTag(TAG_REF, TracingUtil.safeToString(ref)), () -> this.delegate.getKeys(ref, pagingToken, withContent));
    }

    @Override
    public Content getValue(Ref ref, Key key) throws ReferenceNotFoundException {
        return TracingVersionStore.callWithOneException("GetValue", b -> b.withTag(TAG_REF, TracingUtil.safeToString(ref)).withTag(TAG_KEY, TracingUtil.safeToString(key)), () -> this.delegate.getValue(ref, key));
    }

    @Override
    public Map<Key, Content> getValues(Ref ref, Collection<Key> keys) throws ReferenceNotFoundException {
        return TracingVersionStore.callWithOneException("GetValues", b -> b.withTag(TAG_REF, TracingUtil.safeToString(ref)).withTag(TAG_KEYS, TracingUtil.safeToString(keys)), () -> this.delegate.getValues(ref, keys));
    }

    @Override
    public PaginationIterator<Diff> getDiffs(Ref from, Ref to, String pagingToken) throws ReferenceNotFoundException {
        return TracingVersionStore.callPaginationIterator("GetDiffs", b -> b.withTag(TAG_FROM, TracingUtil.safeToString(from)).withTag(TAG_TO, TracingUtil.safeToString(to)), () -> this.delegate.getDiffs(from, to, pagingToken));
    }

    @Override
    public Stream<RefLogDetails> getRefLog(Hash refLogId) throws RefLogNotFoundException {
        return this.delegate.getRefLog(refLogId);
    }

    private static SpanHolder createSpan(String name, Consumer<Tracer.SpanBuilder> spanBuilder) {
        Tracer tracer = GlobalTracer.get();
        String spanName = TracingVersionStore.makeSpanName(name);
        Tracer.SpanBuilder builder = tracer.buildSpan(spanName).asChildOf(tracer.activeSpan()).withTag(TAG_OPERATION, name);
        spanBuilder.accept(builder);
        return new SpanHolder(builder.start());
    }

    private static Scope activeScope(Span span) {
        Tracer tracer = GlobalTracer.get();
        return tracer.activateSpan(span);
    }

    @VisibleForTesting
    static String makeSpanName(String name) {
        return "VersionStore." + Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    /*
     * Exception decompiling
     */
    private static <R, E1 extends VersionStoreException> PaginationIterator<R> callPaginationIterator(String spanName, Consumer<Tracer.SpanBuilder> spanBuilder, InvokerWithOneException<PaginationIterator<R>, E1> invoker) throws E1 {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static <R, E1 extends VersionStoreException> R callWithOneException(String spanName, Consumer<Tracer.SpanBuilder> spanBuilder, InvokerWithOneException<R, E1> invoker) throws E1 {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static <E1 extends VersionStoreException, E2 extends VersionStoreException> void callWithTwoExceptions(String spanName, Consumer<Tracer.SpanBuilder> spanBuilder, InvokerWithTwoExceptions<E1, E2> invoker) throws E1, E2 {
        try (SpanHolder span = TracingVersionStore.createSpan(spanName, spanBuilder);
             Scope ignore = TracingVersionStore.activeScope(span.get());){
            try {
                invoker.handle();
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw TracingUtil.traceError(span.get(), e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static <R, E1 extends VersionStoreException, E2 extends VersionStoreException> R callWithTwoExceptions(String spanName, Consumer<Tracer.SpanBuilder> spanBuilder, InvokerWithTwoExceptionsR<R, E1, E2> invoker) throws E1, E2 {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String safeRefName(NamedRef ref) {
        return ref != null ? ref.getName() : "<null>";
    }

    private static class SpanHolder
    implements Closeable {
        private final Span span;

        private SpanHolder(Span span) {
            this.span = span;
        }

        private Span get() {
            return this.span;
        }

        @Override
        public void close() {
            this.span.finish();
        }
    }

    @FunctionalInterface
    static interface InvokerWithTwoExceptionsR<R, E1 extends VersionStoreException, E2 extends VersionStoreException> {
        public R handle() throws E1, E2;
    }

    @FunctionalInterface
    static interface InvokerWithTwoExceptions<E1 extends VersionStoreException, E2 extends VersionStoreException> {
        public void handle() throws E1, E2;
    }

    @FunctionalInterface
    static interface InvokerWithOneException<R, E1 extends VersionStoreException> {
        public R handle() throws E1;
    }
}

