/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.ContentKey;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.Operation;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Delete", generator="Immutables")
@Immutable
public final class ImmutableDelete
implements Delete {
    private final boolean shouldMatchHash;
    private final ContentKey key;

    private ImmutableDelete(Builder builder) {
        this.key = builder.key;
        this.shouldMatchHash = builder.shouldMatchHashIsSet() ? builder.shouldMatchHash : Delete.super.shouldMatchHash();
    }

    private ImmutableDelete(boolean shouldMatchHash, ContentKey key) {
        this.shouldMatchHash = shouldMatchHash;
        this.key = key;
    }

    @Override
    public boolean shouldMatchHash() {
        return this.shouldMatchHash;
    }

    @Override
    public ContentKey getKey() {
        return this.key;
    }

    public final ImmutableDelete withShouldMatchHash(boolean value) {
        if (this.shouldMatchHash == value) {
            return this;
        }
        return new ImmutableDelete(value, this.key);
    }

    public final ImmutableDelete withKey(ContentKey value) {
        if (this.key == value) {
            return this;
        }
        ContentKey newValue = Objects.requireNonNull(value, "key");
        return new ImmutableDelete(this.shouldMatchHash, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDelete && this.equalTo(0, (ImmutableDelete)another);
    }

    private boolean equalTo(int synthetic, ImmutableDelete another) {
        return this.shouldMatchHash == another.shouldMatchHash && this.key.equals(another.key);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.shouldMatchHash);
        h += (h << 5) + this.key.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Delete").omitNullValues().add("shouldMatchHash", this.shouldMatchHash).add("key", (Object)this.key).toString();
    }

    public static ImmutableDelete copyOf(Delete instance) {
        if (instance instanceof ImmutableDelete) {
            return (ImmutableDelete)instance;
        }
        return ImmutableDelete.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Delete", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long OPT_BIT_SHOULD_MATCH_HASH = 1L;
        private long initBits = 1L;
        private long optBits;
        private boolean shouldMatchHash;
        @Nullable
        private ContentKey key;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Operation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Delete instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Operation instance;
            long bits = 0L;
            if (object instanceof Operation) {
                instance = (Operation)object;
                if ((bits & 1L) == 0L) {
                    this.shouldMatchHash(instance.shouldMatchHash());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.key(instance.getKey());
                    bits |= 2L;
                }
            }
            if (object instanceof Delete) {
                instance = (Delete)object;
                if ((bits & 1L) == 0L) {
                    this.shouldMatchHash(instance.shouldMatchHash());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.key(instance.getKey());
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder shouldMatchHash(boolean shouldMatchHash) {
            this.shouldMatchHash = shouldMatchHash;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(ContentKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableDelete build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDelete(this);
        }

        private boolean shouldMatchHashIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            return "Cannot build Delete, some of required attributes are not set " + attributes;
        }
    }
}

