/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.versioned.Diff;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Diff", generator="Immutables")
@Immutable
public final class ImmutableDiff
implements Diff {
    private final ContentKey key;
    @Nullable
    private final Content fromValue;
    @Nullable
    private final Content toValue;

    private ImmutableDiff(ContentKey key, @Nullable Content fromValue, @Nullable Content toValue) {
        this.key = key;
        this.fromValue = fromValue;
        this.toValue = toValue;
    }

    @Override
    public ContentKey getKey() {
        return this.key;
    }

    @Override
    public Optional<Content> getFromValue() {
        return Optional.ofNullable(this.fromValue);
    }

    @Override
    public Optional<Content> getToValue() {
        return Optional.ofNullable(this.toValue);
    }

    public final ImmutableDiff withKey(ContentKey value) {
        if (this.key == value) {
            return this;
        }
        ContentKey newValue = Objects.requireNonNull(value, "key");
        return new ImmutableDiff(newValue, this.fromValue, this.toValue);
    }

    public final ImmutableDiff withFromValue(Content value) {
        Content newValue = Objects.requireNonNull(value, "fromValue");
        if (this.fromValue == newValue) {
            return this;
        }
        return new ImmutableDiff(this.key, newValue, this.toValue);
    }

    public final ImmutableDiff withFromValue(Optional<? extends Content> optional) {
        Content value = optional.orElse(null);
        if (this.fromValue == value) {
            return this;
        }
        return new ImmutableDiff(this.key, value, this.toValue);
    }

    public final ImmutableDiff withToValue(Content value) {
        Content newValue = Objects.requireNonNull(value, "toValue");
        if (this.toValue == newValue) {
            return this;
        }
        return new ImmutableDiff(this.key, this.fromValue, newValue);
    }

    public final ImmutableDiff withToValue(Optional<? extends Content> optional) {
        Content value = optional.orElse(null);
        if (this.toValue == value) {
            return this;
        }
        return new ImmutableDiff(this.key, this.fromValue, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDiff && this.equalTo(0, (ImmutableDiff)another);
    }

    private boolean equalTo(int synthetic, ImmutableDiff another) {
        return this.key.equals(another.key) && Objects.equals(this.fromValue, another.fromValue) && Objects.equals(this.toValue, another.toValue);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + Objects.hashCode(this.fromValue);
        h += (h << 5) + Objects.hashCode(this.toValue);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Diff").omitNullValues().add("key", (Object)this.key).add("fromValue", (Object)this.fromValue).add("toValue", (Object)this.toValue).toString();
    }

    public static ImmutableDiff copyOf(Diff instance) {
        if (instance instanceof ImmutableDiff) {
            return (ImmutableDiff)instance;
        }
        return ImmutableDiff.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Diff", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private long initBits = 1L;
        @Nullable
        private ContentKey key;
        @Nullable
        private Content fromValue;
        @Nullable
        private Content toValue;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Diff instance) {
            Optional<Content> toValueOptional;
            Objects.requireNonNull(instance, "instance");
            this.key(instance.getKey());
            Optional<Content> fromValueOptional = instance.getFromValue();
            if (fromValueOptional.isPresent()) {
                this.fromValue(fromValueOptional);
            }
            if ((toValueOptional = instance.getToValue()).isPresent()) {
                this.toValue(toValueOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(ContentKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fromValue(Content fromValue) {
            this.fromValue = Objects.requireNonNull(fromValue, "fromValue");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fromValue(Optional<? extends Content> fromValue) {
            this.fromValue = fromValue.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toValue(Content toValue) {
            this.toValue = Objects.requireNonNull(toValue, "toValue");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toValue(Optional<? extends Content> toValue) {
            this.toValue = toValue.orElse(null);
            return this;
        }

        public ImmutableDiff build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDiff(this.key, this.fromValue, this.toValue);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            return "Cannot build Diff, some of required attributes are not set " + attributes;
        }
    }
}

