/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Put;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Put", generator="Immutables")
@Immutable
public final class ImmutablePut
implements Put {
    private final boolean shouldMatchHash;
    private final ContentKey key;
    private final Content value;

    private ImmutablePut(Builder builder) {
        this.key = builder.key;
        this.value = builder.value;
        this.shouldMatchHash = builder.shouldMatchHashIsSet() ? builder.shouldMatchHash : Put.super.shouldMatchHash();
    }

    private ImmutablePut(boolean shouldMatchHash, ContentKey key, Content value) {
        this.shouldMatchHash = shouldMatchHash;
        this.key = key;
        this.value = value;
    }

    @Override
    public boolean shouldMatchHash() {
        return this.shouldMatchHash;
    }

    @Override
    public ContentKey getKey() {
        return this.key;
    }

    @Override
    public Content getValue() {
        return this.value;
    }

    public final ImmutablePut withShouldMatchHash(boolean value) {
        if (this.shouldMatchHash == value) {
            return this;
        }
        return new ImmutablePut(value, this.key, this.value);
    }

    public final ImmutablePut withKey(ContentKey value) {
        if (this.key == value) {
            return this;
        }
        ContentKey newValue = Objects.requireNonNull(value, "key");
        return new ImmutablePut(this.shouldMatchHash, newValue, this.value);
    }

    public final ImmutablePut withValue(Content value) {
        if (this.value == value) {
            return this;
        }
        Content newValue = Objects.requireNonNull(value, "value");
        return new ImmutablePut(this.shouldMatchHash, this.key, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePut && this.equalTo(0, (ImmutablePut)another);
    }

    private boolean equalTo(int synthetic, ImmutablePut another) {
        return this.shouldMatchHash == another.shouldMatchHash && this.key.equals(another.key) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.shouldMatchHash);
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Put").omitNullValues().add("shouldMatchHash", this.shouldMatchHash).add("key", (Object)this.key).add("value", (Object)this.value).toString();
    }

    public static ImmutablePut copyOf(Put instance) {
        if (instance instanceof ImmutablePut) {
            return (ImmutablePut)instance;
        }
        return ImmutablePut.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Put", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private static final long OPT_BIT_SHOULD_MATCH_HASH = 1L;
        private long initBits = 3L;
        private long optBits;
        private boolean shouldMatchHash;
        @Nullable
        private ContentKey key;
        @Nullable
        private Content value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Operation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Put instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Operation instance;
            long bits = 0L;
            if (object instanceof Operation) {
                instance = (Operation)object;
                if ((bits & 1L) == 0L) {
                    this.shouldMatchHash(instance.shouldMatchHash());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.key(instance.getKey());
                    bits |= 2L;
                }
            }
            if (object instanceof Put) {
                instance = (Put)object;
                if ((bits & 1L) == 0L) {
                    this.shouldMatchHash(instance.shouldMatchHash());
                    bits |= 1L;
                }
                this.value(instance.getValue());
                if ((bits & 2L) == 0L) {
                    this.key(instance.getKey());
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder shouldMatchHash(boolean shouldMatchHash) {
            this.shouldMatchHash = shouldMatchHash;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(ContentKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(Content value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePut build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePut(this);
        }

        private boolean shouldMatchHashIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build Put, some of required attributes are not set " + attributes;
        }
    }
}

