/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.model.ContentKey;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ImmutableKeyDetails;
import org.projectnessie.versioned.ImmutableMergeResult;
import org.projectnessie.versioned.MergeType;

@Value.Immutable
public interface MergeResult<COMMIT> {
    @Value.Default
    default public boolean wasApplied() {
        return false;
    }

    @Value.Default
    default public boolean wasSuccessful() {
        return false;
    }

    @Nullable
    @jakarta.annotation.Nullable
    public Hash getResultantTargetHash();

    @Nullable
    @jakarta.annotation.Nullable
    public Hash getCommonAncestor();

    public BranchName getTargetBranch();

    public Hash getEffectiveTargetHash();

    @Nullable
    @jakarta.annotation.Nullable
    public Hash getExpectedHash();

    @Deprecated
    public List<COMMIT> getSourceCommits();

    @Nullable
    @jakarta.annotation.Nullable
    @Deprecated
    public List<COMMIT> getTargetCommits();

    public Map<ContentKey, KeyDetails> getDetails();

    public static <COMMIT> ImmutableMergeResult.Builder<COMMIT> builder() {
        return ImmutableMergeResult.builder();
    }

    public static enum ConflictType {
        NONE,
        UNRESOLVABLE;

    }

    @Value.Immutable
    public static interface KeyDetails {
        public MergeType getMergeType();

        @Value.Default
        default public ConflictType getConflictType() {
            return ConflictType.NONE;
        }

        @Deprecated
        public List<Hash> getSourceCommits();

        @Deprecated
        public List<Hash> getTargetCommits();

        public static ImmutableKeyDetails.Builder builder() {
            return ImmutableKeyDetails.builder();
        }

        public static KeyDetails keyDetails(MergeType mergeType, ConflictType conflictType) {
            return KeyDetails.builder().mergeType(mergeType).conflictType(conflictType).build();
        }
    }
}

