/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.paging;

import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.projectnessie.versioned.paging.PaginationIterator;

public abstract class FilteringPaginationIterator<S, T>
extends AbstractIterator<T>
implements PaginationIterator<T> {
    private final Iterator<S> base;
    private final Function<S, T> mapper;
    private final Predicate<S> sourcePredicate;
    private S current;

    public FilteringPaginationIterator(Iterator<S> base, Function<S, T> mapper) {
        this(base, mapper, x -> true);
    }

    public FilteringPaginationIterator(Iterator<S> base, Function<S, T> mapper, Predicate<S> sourcePredicate) {
        this.base = base;
        this.mapper = mapper;
        this.sourcePredicate = sourcePredicate;
    }

    protected T computeNext() {
        S source;
        this.current = null;
        do {
            if (this.base.hasNext()) continue;
            this.endOfData();
            return null;
        } while (!this.sourcePredicate.test(source = this.base.next()));
        this.current = source;
        return this.mapper.apply(source);
    }

    protected S current() {
        return this.current;
    }

    @Override
    public final String tokenForCurrent() {
        if (this.current != null) {
            return this.computeTokenForCurrent();
        }
        return null;
    }

    protected abstract String computeTokenForCurrent();

    @Override
    public void close() {
    }
}

