/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.model.MergeKeyBehavior;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.CommitResult;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.KeyEntry;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.MetadataRewriter;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.RefLogDetails;
import org.projectnessie.versioned.RefLogNotFoundException;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceAssignedResult;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceCreatedResult;
import org.projectnessie.versioned.ReferenceDeletedResult;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.RepositoryInformation;
import org.projectnessie.versioned.Result;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.paging.PaginationIterator;

public class EventsVersionStore
implements VersionStore {
    private final VersionStore delegate;
    private final Consumer<Result> resultSink;

    public EventsVersionStore(VersionStore delegate, Consumer<Result> resultSink) {
        this.delegate = delegate;
        this.resultSink = resultSink;
    }

    @Override
    public CommitResult<Commit> commit(@javax.annotation.Nonnull @Nonnull BranchName branch, @javax.annotation.Nonnull @Nonnull Optional<Hash> referenceHash, @javax.annotation.Nonnull @Nonnull CommitMeta metadata, @javax.annotation.Nonnull @Nonnull List<Operation> operations, @javax.annotation.Nonnull @Nonnull Callable<Void> validator, @javax.annotation.Nonnull @Nonnull BiConsumer<ContentKey, String> addedContents) throws ReferenceNotFoundException, ReferenceConflictException {
        CommitResult<Commit> result = this.delegate.commit(branch, referenceHash, metadata, operations, validator, addedContents);
        this.resultSink.accept(result);
        return result;
    }

    @Override
    public MergeResult<Commit> transplant(NamedRef sourceRef, BranchName targetBranch, Optional<Hash> referenceHash, List<Hash> sequenceToTransplant, MetadataRewriter<CommitMeta> updateCommitMetadata, boolean keepIndividualCommits, Map<ContentKey, MergeKeyBehavior> mergeKeyBehaviors, MergeBehavior defaultMergeBehavior, boolean dryRun, boolean fetchAdditionalInfo) throws ReferenceNotFoundException, ReferenceConflictException {
        MergeResult<Commit> result = this.delegate.transplant(sourceRef, targetBranch, referenceHash, sequenceToTransplant, updateCommitMetadata, keepIndividualCommits, mergeKeyBehaviors, defaultMergeBehavior, dryRun, fetchAdditionalInfo);
        if (result.wasApplied()) {
            this.resultSink.accept(result);
        }
        return result;
    }

    @Override
    public MergeResult<Commit> merge(NamedRef fromRef, Hash fromHash, BranchName toBranch, Optional<Hash> expectedHash, MetadataRewriter<CommitMeta> updateCommitMetadata, boolean keepIndividualCommits, Map<ContentKey, MergeKeyBehavior> mergeKeyBehaviors, MergeBehavior defaultMergeBehavior, boolean dryRun, boolean fetchAdditionalInfo) throws ReferenceNotFoundException, ReferenceConflictException {
        MergeResult<Commit> result = this.delegate.merge(fromRef, fromHash, toBranch, expectedHash, updateCommitMetadata, keepIndividualCommits, mergeKeyBehaviors, defaultMergeBehavior, dryRun, fetchAdditionalInfo);
        if (result.wasApplied()) {
            this.resultSink.accept(result);
        }
        return result;
    }

    @Override
    public ReferenceAssignedResult assign(NamedRef ref, Optional<Hash> expectedHash, Hash targetHash) throws ReferenceNotFoundException, ReferenceConflictException {
        ReferenceAssignedResult result = this.delegate.assign(ref, expectedHash, targetHash);
        this.resultSink.accept(result);
        return result;
    }

    @Override
    public ReferenceCreatedResult create(NamedRef ref, Optional<Hash> targetHash) throws ReferenceNotFoundException, ReferenceAlreadyExistsException {
        ReferenceCreatedResult result = this.delegate.create(ref, targetHash);
        this.resultSink.accept(result);
        return result;
    }

    @Override
    public ReferenceDeletedResult delete(NamedRef ref, Optional<Hash> hash) throws ReferenceNotFoundException, ReferenceConflictException {
        ReferenceDeletedResult result = this.delegate.delete(ref, hash);
        this.resultSink.accept(result);
        return result;
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public RepositoryInformation getRepositoryInformation() {
        return this.delegate.getRepositoryInformation();
    }

    @Override
    public Hash hashOnReference(NamedRef namedReference, Optional<Hash> hashOnReference) throws ReferenceNotFoundException {
        return this.delegate.hashOnReference(namedReference, hashOnReference);
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public Hash noAncestorHash() {
        return this.delegate.noAncestorHash();
    }

    @Override
    public ReferenceInfo<CommitMeta> getNamedRef(String ref, GetNamedRefsParams params) throws ReferenceNotFoundException {
        return this.delegate.getNamedRef(ref, params);
    }

    @Override
    public PaginationIterator<ReferenceInfo<CommitMeta>> getNamedRefs(GetNamedRefsParams params, String pagingToken) throws ReferenceNotFoundException {
        return this.delegate.getNamedRefs(params, pagingToken);
    }

    @Override
    public PaginationIterator<Commit> getCommits(Ref ref, boolean fetchAdditionalInfo) throws ReferenceNotFoundException {
        return this.delegate.getCommits(ref, fetchAdditionalInfo);
    }

    @Override
    public PaginationIterator<KeyEntry> getKeys(Ref ref, String pagingToken, boolean withContent, ContentKey minKey, ContentKey maxKey, ContentKey prefixKey, Predicate<ContentKey> contentKeyPredicate) throws ReferenceNotFoundException {
        return this.delegate.getKeys(ref, pagingToken, withContent, minKey, maxKey, prefixKey, contentKeyPredicate);
    }

    @Override
    public Content getValue(Ref ref, ContentKey key) throws ReferenceNotFoundException {
        return this.delegate.getValue(ref, key);
    }

    @Override
    public Map<ContentKey, Content> getValues(Ref ref, Collection<ContentKey> keys) throws ReferenceNotFoundException {
        return this.delegate.getValues(ref, keys);
    }

    @Override
    public PaginationIterator<Diff> getDiffs(Ref from, Ref to, String pagingToken, ContentKey minKey, ContentKey maxKey, ContentKey prefixKey, Predicate<ContentKey> contentKeyPredicate) throws ReferenceNotFoundException {
        return this.delegate.getDiffs(from, to, pagingToken, minKey, maxKey, prefixKey, contentKeyPredicate);
    }

    @Override
    @Deprecated
    public Stream<RefLogDetails> getRefLog(Hash refLogId) throws RefLogNotFoundException {
        return this.delegate.getRefLog(refLogId);
    }
}

