/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.ImmutablePut;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.store.DefaultStoreWorker;

@Value.Immutable
public abstract class Put
implements Operation {
    @Value.Lazy
    public Content getValue() {
        return this.getValueSupplier().get();
    }

    protected abstract Supplier<Content> getValueSupplier();

    @javax.annotation.Nonnull
    @Nonnull
    public static Put of(@javax.annotation.Nonnull @Nonnull ContentKey key, @javax.annotation.Nonnull @Nonnull Content value) {
        return ImmutablePut.builder().key(key).valueSupplier(() -> value).build();
    }

    @javax.annotation.Nonnull
    @Nonnull
    public static Put ofLazy(ContentKey key, int payload, ByteString value) {
        return Put.ofLazy(key, payload, value, () -> null);
    }

    @javax.annotation.Nonnull
    @Nonnull
    public static Put ofLazy(ContentKey key, int payload, ByteString value, Supplier<ByteString> globalStateSupplier) {
        return ImmutablePut.builder().key(key).valueSupplier(() -> DefaultStoreWorker.instance().valueFromStore((byte)payload, value, globalStateSupplier)).build();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Put)) {
            return false;
        }
        Put that = (Put)o;
        return this.shouldMatchHash() == that.shouldMatchHash() && this.getKey().equals(that.getKey()) && this.getValue().equals(that.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.shouldMatchHash(), this.getKey(), this.getValue());
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Put").omitNullValues().add("shouldMatchHash", this.shouldMatchHash()).add("key", (Object)this.getKey()).add("value", (Object)this.getValue()).toString();
    }
}

