/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.ContentKey;
import org.projectnessie.versioned.VersionStore;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="VersionStore.KeyRestrictions", generator="Immutables")
@Immutable
public final class ImmutableKeyRestrictions
implements VersionStore.KeyRestrictions {
    @jakarta.annotation.Nullable
    private final ContentKey minKey;
    @jakarta.annotation.Nullable
    private final ContentKey maxKey;
    @jakarta.annotation.Nullable
    private final ContentKey prefixKey;
    @jakarta.annotation.Nullable
    private final Predicate<ContentKey> contentKeyPredicate;

    private ImmutableKeyRestrictions(@jakarta.annotation.Nullable ContentKey minKey, @jakarta.annotation.Nullable ContentKey maxKey, @jakarta.annotation.Nullable ContentKey prefixKey, @jakarta.annotation.Nullable Predicate<ContentKey> contentKeyPredicate) {
        this.minKey = minKey;
        this.maxKey = maxKey;
        this.prefixKey = prefixKey;
        this.contentKeyPredicate = contentKeyPredicate;
    }

    @Override
    @jakarta.annotation.Nullable
    public ContentKey minKey() {
        return this.minKey;
    }

    @Override
    @jakarta.annotation.Nullable
    public ContentKey maxKey() {
        return this.maxKey;
    }

    @Override
    @jakarta.annotation.Nullable
    public ContentKey prefixKey() {
        return this.prefixKey;
    }

    @Override
    @jakarta.annotation.Nullable
    public Predicate<ContentKey> contentKeyPredicate() {
        return this.contentKeyPredicate;
    }

    public final ImmutableKeyRestrictions withMinKey(@jakarta.annotation.Nullable ContentKey value) {
        if (this.minKey == value) {
            return this;
        }
        return new ImmutableKeyRestrictions(value, this.maxKey, this.prefixKey, this.contentKeyPredicate);
    }

    public final ImmutableKeyRestrictions withMaxKey(@jakarta.annotation.Nullable ContentKey value) {
        if (this.maxKey == value) {
            return this;
        }
        return new ImmutableKeyRestrictions(this.minKey, value, this.prefixKey, this.contentKeyPredicate);
    }

    public final ImmutableKeyRestrictions withPrefixKey(@jakarta.annotation.Nullable ContentKey value) {
        if (this.prefixKey == value) {
            return this;
        }
        return new ImmutableKeyRestrictions(this.minKey, this.maxKey, value, this.contentKeyPredicate);
    }

    public final ImmutableKeyRestrictions withContentKeyPredicate(@jakarta.annotation.Nullable Predicate<ContentKey> value) {
        if (this.contentKeyPredicate == value) {
            return this;
        }
        return new ImmutableKeyRestrictions(this.minKey, this.maxKey, this.prefixKey, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyRestrictions && this.equalTo(0, (ImmutableKeyRestrictions)another);
    }

    private boolean equalTo(int synthetic, ImmutableKeyRestrictions another) {
        return Objects.equals(this.minKey, another.minKey) && Objects.equals(this.maxKey, another.maxKey) && Objects.equals(this.prefixKey, another.prefixKey) && Objects.equals(this.contentKeyPredicate, another.contentKeyPredicate);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.minKey);
        h += (h << 5) + Objects.hashCode(this.maxKey);
        h += (h << 5) + Objects.hashCode(this.prefixKey);
        h += (h << 5) + Objects.hashCode(this.contentKeyPredicate);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"KeyRestrictions").omitNullValues().add("minKey", (Object)this.minKey).add("maxKey", (Object)this.maxKey).add("prefixKey", (Object)this.prefixKey).add("contentKeyPredicate", this.contentKeyPredicate).toString();
    }

    public static ImmutableKeyRestrictions copyOf(VersionStore.KeyRestrictions instance) {
        if (instance instanceof ImmutableKeyRestrictions) {
            return (ImmutableKeyRestrictions)instance;
        }
        return ImmutableKeyRestrictions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="VersionStore.KeyRestrictions", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private ContentKey minKey;
        @Nullable
        private ContentKey maxKey;
        @Nullable
        private ContentKey prefixKey;
        @Nullable
        private Predicate<ContentKey> contentKeyPredicate;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(VersionStore.KeyRestrictions instance) {
            Predicate<ContentKey> contentKeyPredicateValue;
            ContentKey prefixKeyValue;
            ContentKey maxKeyValue;
            Objects.requireNonNull(instance, "instance");
            ContentKey minKeyValue = instance.minKey();
            if (minKeyValue != null) {
                this.minKey(minKeyValue);
            }
            if ((maxKeyValue = instance.maxKey()) != null) {
                this.maxKey(maxKeyValue);
            }
            if ((prefixKeyValue = instance.prefixKey()) != null) {
                this.prefixKey(prefixKeyValue);
            }
            if ((contentKeyPredicateValue = instance.contentKeyPredicate()) != null) {
                this.contentKeyPredicate(contentKeyPredicateValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder minKey(@jakarta.annotation.Nullable ContentKey minKey) {
            this.minKey = minKey;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maxKey(@jakarta.annotation.Nullable ContentKey maxKey) {
            this.maxKey = maxKey;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder prefixKey(@jakarta.annotation.Nullable ContentKey prefixKey) {
            this.prefixKey = prefixKey;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentKeyPredicate(@jakarta.annotation.Nullable Predicate<ContentKey> contentKeyPredicate) {
            this.contentKeyPredicate = contentKeyPredicate;
            return this;
        }

        public ImmutableKeyRestrictions build() {
            return new ImmutableKeyRestrictions(this.minKey, this.maxKey, this.prefixKey, this.contentKeyPredicate);
        }
    }
}

