/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IdentifiedContentKey;
import org.projectnessie.model.RepositoryConfig;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.CommitResult;
import org.projectnessie.versioned.ContentResult;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.KeyEntry;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.RefLogDetails;
import org.projectnessie.versioned.RefLogNotFoundException;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceAssignedResult;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceCreatedResult;
import org.projectnessie.versioned.ReferenceDeletedResult;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.RelativeCommitSpec;
import org.projectnessie.versioned.RepositoryInformation;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.paging.PaginationIterator;

public final class MetricsVersionStore
implements VersionStore {
    private final VersionStore delegate;
    private final MeterRegistry registry;
    private final Clock clock;

    public MetricsVersionStore(VersionStore delegate, MeterRegistry registry, Clock clock) {
        this.delegate = delegate;
        this.registry = registry;
        this.clock = clock;
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public RepositoryInformation getRepositoryInformation() {
        return this.delegate("repositoryInformation", this.delegate::getRepositoryInformation);
    }

    @Override
    public Hash hashOnReference(NamedRef namedReference, Optional<Hash> hashOnReference, List<RelativeCommitSpec> relativeLookups) throws ReferenceNotFoundException {
        return this.delegate1Ex("hashonreference", () -> this.delegate.hashOnReference(namedReference, hashOnReference, relativeLookups));
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public Hash noAncestorHash() {
        return this.delegate.noAncestorHash();
    }

    @Override
    public CommitResult<Commit> commit(@javax.annotation.Nonnull @Nonnull BranchName branch, @javax.annotation.Nonnull @Nonnull Optional<Hash> referenceHash, @javax.annotation.Nonnull @Nonnull CommitMeta metadata, @javax.annotation.Nonnull @Nonnull List<Operation> operations, @javax.annotation.Nonnull @Nonnull VersionStore.CommitValidator validator, @javax.annotation.Nonnull @Nonnull BiConsumer<ContentKey, String> addedContents) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.delegate2ExR("commit", () -> this.delegate.commit(branch, referenceHash, metadata, operations, validator, addedContents));
    }

    @Override
    public MergeResult<Commit> transplant(VersionStore.TransplantOp transplantOp) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.delegate2ExR("transplant", () -> this.delegate.transplant(transplantOp));
    }

    @Override
    public MergeResult<Commit> merge(VersionStore.MergeOp mergeOp) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.delegate2ExR("merge", () -> this.delegate.merge(mergeOp));
    }

    @Override
    public ReferenceAssignedResult assign(NamedRef ref, Optional<Hash> expectedHash, Hash targetHash) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.delegate2ExR("assign", () -> this.delegate.assign(ref, expectedHash, targetHash));
    }

    @Override
    public ReferenceCreatedResult create(NamedRef ref, Optional<Hash> targetHash) throws ReferenceNotFoundException, ReferenceAlreadyExistsException {
        return this.delegate2ExR("create", () -> this.delegate.create(ref, targetHash));
    }

    @Override
    public ReferenceDeletedResult delete(NamedRef ref, Optional<Hash> hash) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.delegate2ExR("delete", () -> this.delegate.delete(ref, hash));
    }

    @Override
    public ReferenceInfo<CommitMeta> getNamedRef(String ref, GetNamedRefsParams params) throws ReferenceNotFoundException {
        return this.delegate1Ex("getnamedref", () -> this.delegate.getNamedRef(ref, params));
    }

    @Override
    public PaginationIterator<ReferenceInfo<CommitMeta>> getNamedRefs(GetNamedRefsParams params, String pagingToken) throws ReferenceNotFoundException {
        return this.delegatePaginationIterator("getnamedrefs", () -> this.delegate.getNamedRefs(params, pagingToken));
    }

    @Override
    public PaginationIterator<Commit> getCommits(Ref ref, boolean fetchAdditionalInfo) throws ReferenceNotFoundException {
        return this.delegatePaginationIterator("getcommits", () -> this.delegate.getCommits(ref, fetchAdditionalInfo));
    }

    @Override
    public PaginationIterator<KeyEntry> getKeys(Ref ref, String pagingToken, boolean withContent, VersionStore.KeyRestrictions keyRestrictions) throws ReferenceNotFoundException {
        return this.delegatePaginationIterator("getkeys", () -> this.delegate.getKeys(ref, pagingToken, withContent, keyRestrictions));
    }

    @Override
    public List<IdentifiedContentKey> getIdentifiedKeys(Ref ref, Collection<ContentKey> keys) throws ReferenceNotFoundException {
        return this.delegate1Ex("identifiedKeys", () -> this.delegate.getIdentifiedKeys(ref, keys));
    }

    @Override
    public ContentResult getValue(Ref ref, ContentKey key) throws ReferenceNotFoundException {
        return this.delegate1Ex("getvalue", () -> this.delegate.getValue(ref, key));
    }

    @Override
    public Map<ContentKey, ContentResult> getValues(Ref ref, Collection<ContentKey> keys) throws ReferenceNotFoundException {
        return this.delegate1Ex("getvalues", () -> this.delegate.getValues(ref, keys));
    }

    @Override
    public PaginationIterator<Diff> getDiffs(Ref from, Ref to, String pagingToken, VersionStore.KeyRestrictions keyRestrictions) throws ReferenceNotFoundException {
        return this.delegatePaginationIterator("getdiffs", () -> this.delegate.getDiffs(from, to, pagingToken, keyRestrictions));
    }

    @Override
    @Deprecated
    public Stream<RefLogDetails> getRefLog(Hash refLogId) throws RefLogNotFoundException {
        return this.delegateStream1Ex("getreflog", () -> this.delegate.getRefLog(refLogId));
    }

    @Override
    public List<RepositoryConfig> getRepositoryConfig(Set<RepositoryConfig.Type> repositoryConfigTypes) {
        return this.delegate("getrepositoryconfig", () -> this.delegate.getRepositoryConfig(repositoryConfigTypes));
    }

    @Override
    public RepositoryConfig updateRepositoryConfig(RepositoryConfig repositoryConfig) throws ReferenceConflictException {
        return this.delegate1Ex("updaterepositoryconfig", () -> this.delegate.updateRepositoryConfig(repositoryConfig));
    }

    private void measure(String requestName, Timer.Sample sample, Exception failure) {
        Timer timer = Timer.builder((String)"nessie.versionstore.request").tag("request", requestName).tag("error", Boolean.toString(failure != null)).publishPercentileHistogram().register(this.registry);
        sample.stop(timer);
    }

    private <R, E extends VersionStoreException> PaginationIterator<R> delegatePaginationIterator(final String requestName, DelegateWith1<PaginationIterator<R>, E> delegate) throws E {
        final Timer.Sample sample = Timer.start((Clock)this.clock);
        try {
            final PaginationIterator<R> r = delegate.handle();
            return new PaginationIterator<R>(){

                @Override
                public String tokenForCurrent() {
                    return r.tokenForCurrent();
                }

                @Override
                public String tokenForEntry(R entry) {
                    return r.tokenForEntry(entry);
                }

                @Override
                public void close() {
                    try {
                        r.close();
                    }
                    finally {
                        MetricsVersionStore.this.measure(requestName, sample, null);
                    }
                }

                @Override
                public boolean hasNext() {
                    return r.hasNext();
                }

                @Override
                public R next() {
                    return r.next();
                }
            };
        }
        catch (IllegalArgumentException | VersionStoreException e) {
            this.measure(requestName, sample, null);
            throw e;
        }
        catch (RuntimeException e) {
            this.measure(requestName, sample, e);
            throw e;
        }
    }

    private <R, E extends VersionStoreException> Stream<R> delegateStream1Ex(String requestName, DelegateWith1<Stream<R>, E> delegate) throws E {
        Timer.Sample sample = Timer.start((Clock)this.clock);
        try {
            return (Stream)delegate.handle().onClose(() -> this.measure(requestName, sample, null));
        }
        catch (IllegalArgumentException | VersionStoreException e) {
            this.measure(requestName, sample, null);
            throw e;
        }
        catch (RuntimeException e) {
            this.measure(requestName, sample, e);
            throw e;
        }
    }

    private <R> R delegate(String requestName, Supplier<R> delegate) {
        try {
            return (R)this.delegate2ExR(requestName, delegate::get);
        }
        catch (VersionStoreException e) {
            throw new RuntimeException(e);
        }
    }

    private <R, E1 extends VersionStoreException> R delegate1Ex(String requestName, DelegateWith1<R, E1> delegate) throws E1 {
        return (R)this.delegate2ExR(requestName, delegate::handle);
    }

    private <R, E1 extends VersionStoreException, E2 extends VersionStoreException> R delegate2ExR(String requestName, DelegateWith2R<R, E1, E2> delegate) throws E1, E2 {
        Timer.Sample sample = Timer.start((Clock)this.clock);
        RuntimeException failure = null;
        try {
            R r = delegate.handle();
            return r;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            failure = e;
            throw e;
        }
        finally {
            this.measure(requestName, sample, failure);
        }
    }

    @FunctionalInterface
    static interface DelegateWith2R<R, E1 extends VersionStoreException, E2 extends VersionStoreException> {
        public R handle() throws E1, E2;
    }

    @FunctionalInterface
    static interface DelegateWith1<R, E1 extends VersionStoreException> {
        public R handle() throws E1;
    }
}

