/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.annotations.VisibleForTesting;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import jakarta.annotation.Nonnull;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IdentifiedContentKey;
import org.projectnessie.model.RepositoryConfig;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.CommitResult;
import org.projectnessie.versioned.ContentResult;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.KeyEntry;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.RefLogDetails;
import org.projectnessie.versioned.RefLogNotFoundException;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceAssignedResult;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceCreatedResult;
import org.projectnessie.versioned.ReferenceDeletedResult;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.RelativeCommitSpec;
import org.projectnessie.versioned.RepositoryInformation;
import org.projectnessie.versioned.TracingUtil;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.paging.PaginationIterator;

public class TracingVersionStore
implements VersionStore {
    private static final String TAG_OPERATION = "nessie.version-store.operation";
    private static final String TAG_REF = "nessie.version-store.ref";
    private static final String TAG_BRANCH = "nessie.version-store.branch";
    private static final String TAG_HASH = "nessie.version-store.hash";
    private static final String TAG_NUM_OPS = "nessie.version-store.num-ops";
    private static final String TAG_TARGET_BRANCH = "nessie.version-store.target-branch";
    private static final String TAG_TRANSPLANTS = "nessie.version-store.transplants";
    private static final String TAG_FROM_HASH = "nessie.version-store.from-hash";
    private static final String TAG_TO_BRANCH = "nessie.version-store.to-branch";
    private static final String TAG_EXPECTED_HASH = "nessie.version-store.expected-hash";
    private static final String TAG_TARGET_HASH = "nessie.version-store.target-hash";
    private static final String TAG_KEY = "nessie.version-store.key";
    private static final String TAG_KEYS = "nessie.version-store.keys";
    private static final String TAG_FROM = "nessie.version-store.from";
    private static final String TAG_TO = "nessie.version-store.to";
    private final VersionStore delegate;
    private final Tracer tracer;

    public TracingVersionStore(VersionStore delegate) {
        this(GlobalOpenTelemetry.getTracer((String)"database-adapter"), delegate);
    }

    public TracingVersionStore(Tracer tracer, VersionStore delegate) {
        this.tracer = tracer;
        this.delegate = delegate;
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public RepositoryInformation getRepositoryInformation() {
        return this.callWithNoException(this.tracer, "RepositoryInformation", b -> {}, this.delegate::getRepositoryInformation);
    }

    @Override
    public Hash hashOnReference(NamedRef namedReference, Optional<Hash> hashOnReference, List<RelativeCommitSpec> relativeLookups) throws ReferenceNotFoundException {
        return TracingVersionStore.callWithOneException(this.tracer, "HashOnReference", b -> b.setAttribute(TAG_REF, TracingVersionStore.safeRefName(namedReference)).setAttribute(TAG_HASH, TracingUtil.safeToString(hashOnReference)), () -> this.delegate.hashOnReference(namedReference, hashOnReference, relativeLookups));
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public Hash noAncestorHash() {
        return this.delegate.noAncestorHash();
    }

    @Override
    public CommitResult<Commit> commit(@javax.annotation.Nonnull @Nonnull BranchName branch, @javax.annotation.Nonnull @Nonnull Optional<Hash> referenceHash, @javax.annotation.Nonnull @Nonnull CommitMeta metadata, @javax.annotation.Nonnull @Nonnull List<Operation> operations, @javax.annotation.Nonnull @Nonnull VersionStore.CommitValidator validator, @javax.annotation.Nonnull @Nonnull BiConsumer<ContentKey, String> addedContents) throws ReferenceNotFoundException, ReferenceConflictException {
        return TracingVersionStore.callWithTwoExceptions(this.tracer, "Commit", b -> b.setAttribute(TAG_BRANCH, TracingVersionStore.safeRefName(branch)).setAttribute(TAG_HASH, TracingUtil.safeToString(referenceHash)).setAttribute(TAG_NUM_OPS, (long)TracingUtil.safeSize(operations)), () -> this.delegate.commit(branch, referenceHash, metadata, operations, validator, addedContents));
    }

    @Override
    public MergeResult<Commit> transplant(VersionStore.TransplantOp transplantOp) throws ReferenceNotFoundException, ReferenceConflictException {
        return TracingVersionStore.callWithTwoExceptions(this.tracer, "Transplant", b -> b.setAttribute(TAG_TARGET_BRANCH, TracingVersionStore.safeRefName(transplantOp.toBranch())).setAttribute(TAG_HASH, TracingUtil.safeToString(transplantOp.expectedHash())).setAttribute(TAG_TRANSPLANTS, (long)TracingUtil.safeSize(transplantOp.sequenceToTransplant())), () -> this.delegate.transplant(transplantOp));
    }

    @Override
    public MergeResult<Commit> merge(VersionStore.MergeOp mergeOp) throws ReferenceNotFoundException, ReferenceConflictException {
        return TracingVersionStore.callWithTwoExceptions(this.tracer, "Merge", b -> b.setAttribute(TAG_FROM_HASH, TracingUtil.safeToString(mergeOp.fromHash())).setAttribute(TAG_TO_BRANCH, TracingVersionStore.safeRefName(mergeOp.toBranch())).setAttribute(TAG_EXPECTED_HASH, TracingUtil.safeToString(mergeOp.expectedHash())), () -> this.delegate.merge(mergeOp));
    }

    @Override
    public ReferenceAssignedResult assign(NamedRef ref, Optional<Hash> expectedHash, Hash targetHash) throws ReferenceNotFoundException, ReferenceConflictException {
        return TracingVersionStore.callWithTwoExceptions(this.tracer, "Assign", b -> b.setAttribute(TAG_REF, TracingUtil.safeToString(ref)).setAttribute(TAG_EXPECTED_HASH, TracingUtil.safeToString(expectedHash)).setAttribute(TAG_TARGET_HASH, TracingUtil.safeToString(targetHash)), () -> this.delegate.assign(ref, expectedHash, targetHash));
    }

    @Override
    public ReferenceCreatedResult create(NamedRef ref, Optional<Hash> targetHash) throws ReferenceNotFoundException, ReferenceAlreadyExistsException {
        return TracingVersionStore.callWithTwoExceptions(this.tracer, "Create", b -> b.setAttribute(TAG_REF, TracingUtil.safeToString(ref)).setAttribute(TAG_TARGET_HASH, TracingUtil.safeToString(targetHash)), () -> this.delegate.create(ref, targetHash));
    }

    @Override
    public ReferenceDeletedResult delete(NamedRef ref, Optional<Hash> hash) throws ReferenceNotFoundException, ReferenceConflictException {
        return TracingVersionStore.callWithTwoExceptions(this.tracer, "Delete", b -> b.setAttribute(TAG_REF, TracingUtil.safeToString(ref)).setAttribute(TAG_HASH, TracingUtil.safeToString(hash)), () -> this.delegate.delete(ref, hash));
    }

    @Override
    public ReferenceInfo<CommitMeta> getNamedRef(String ref, GetNamedRefsParams params) throws ReferenceNotFoundException {
        return TracingVersionStore.callWithOneException(this.tracer, "GetNamedRef", b -> b.setAttribute(TAG_REF, ref), () -> this.delegate.getNamedRef(ref, params));
    }

    @Override
    public PaginationIterator<ReferenceInfo<CommitMeta>> getNamedRefs(GetNamedRefsParams params, String pagingToken) throws ReferenceNotFoundException {
        return TracingVersionStore.callPaginationIterator(this.tracer, "GetNamedRefs", b -> {}, () -> this.delegate.getNamedRefs(params, pagingToken));
    }

    @Override
    public PaginationIterator<Commit> getCommits(Ref ref, boolean fetchAdditionalInfo) throws ReferenceNotFoundException {
        return TracingVersionStore.callPaginationIterator(this.tracer, "GetCommits", b -> b.setAttribute(TAG_REF, TracingUtil.safeToString(ref)), () -> this.delegate.getCommits(ref, fetchAdditionalInfo));
    }

    @Override
    public PaginationIterator<KeyEntry> getKeys(Ref ref, String pagingToken, boolean withContent, VersionStore.KeyRestrictions keyRestrictions) throws ReferenceNotFoundException {
        return TracingVersionStore.callPaginationIterator(this.tracer, "GetKeys", b -> b.setAttribute(TAG_REF, TracingUtil.safeToString(ref)), () -> this.delegate.getKeys(ref, pagingToken, withContent, keyRestrictions));
    }

    @Override
    public List<IdentifiedContentKey> getIdentifiedKeys(Ref ref, Collection<ContentKey> keys) throws ReferenceNotFoundException {
        return TracingVersionStore.callWithOneException(this.tracer, "IdentifiedKeys", b -> b.setAttribute(TAG_REF, TracingUtil.safeToString(ref)), () -> this.delegate.getIdentifiedKeys(ref, keys));
    }

    @Override
    public ContentResult getValue(Ref ref, ContentKey key) throws ReferenceNotFoundException {
        return TracingVersionStore.callWithOneException(this.tracer, "GetValue", b -> b.setAttribute(TAG_REF, TracingUtil.safeToString(ref)).setAttribute(TAG_KEY, TracingUtil.safeToString(key)), () -> this.delegate.getValue(ref, key));
    }

    @Override
    public Map<ContentKey, ContentResult> getValues(Ref ref, Collection<ContentKey> keys) throws ReferenceNotFoundException {
        return TracingVersionStore.callWithOneException(this.tracer, "GetValues", b -> b.setAttribute(TAG_REF, TracingUtil.safeToString(ref)).setAttribute(TAG_KEYS, TracingUtil.safeToString(keys)), () -> this.delegate.getValues(ref, keys));
    }

    @Override
    public PaginationIterator<Diff> getDiffs(Ref from, Ref to, String pagingToken, VersionStore.KeyRestrictions keyRestrictions) throws ReferenceNotFoundException {
        return TracingVersionStore.callPaginationIterator(this.tracer, "GetDiffs", b -> b.setAttribute(TAG_FROM, TracingUtil.safeToString(from)).setAttribute(TAG_TO, TracingUtil.safeToString(to)), () -> this.delegate.getDiffs(from, to, pagingToken, keyRestrictions));
    }

    @Override
    @Deprecated
    public Stream<RefLogDetails> getRefLog(Hash refLogId) throws RefLogNotFoundException {
        return this.delegate.getRefLog(refLogId);
    }

    @Override
    public List<RepositoryConfig> getRepositoryConfig(Set<RepositoryConfig.Type> repositoryConfigTypes) {
        return this.callWithNoException(this.tracer, "GetRepositoryConfig", b -> {}, () -> this.delegate.getRepositoryConfig(repositoryConfigTypes));
    }

    @Override
    public RepositoryConfig updateRepositoryConfig(RepositoryConfig repositoryConfig) throws ReferenceConflictException {
        return TracingVersionStore.callWithOneException(this.tracer, "UpdateRepositoryConfig", b -> {}, () -> this.delegate.updateRepositoryConfig(repositoryConfig));
    }

    private static SpanHolder createSpan(Tracer tracer, String name, Consumer<SpanBuilder> spanBuilder) {
        String spanName = TracingVersionStore.makeSpanName(name);
        SpanBuilder builder = tracer.spanBuilder(spanName).setAttribute(TAG_OPERATION, name);
        spanBuilder.accept(builder);
        return new SpanHolder(builder.startSpan());
    }

    @VisibleForTesting
    static String makeSpanName(String name) {
        return "VersionStore." + Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    private static <R, E1 extends VersionStoreException> PaginationIterator<R> callPaginationIterator(Tracer tracer, String spanName, Consumer<SpanBuilder> spanBuilder, InvokerWithOneException<PaginationIterator<R>, E1> invoker) throws E1 {
        SpanHolder span = TracingVersionStore.createSpan(tracer, spanName + ".stream", spanBuilder);
        try {
            PaginationIterator<R> paginationIterator = invoker.handle();
            return paginationIterator;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw TracingUtil.traceError(span.get(), e);
        }
        finally {
            if (span != null) {
                try {
                    span.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private <R> R callWithNoException(Tracer tracer, String spanName, Consumer<SpanBuilder> spanBuilder, Supplier<R> invoker) {
        SpanHolder span = TracingVersionStore.createSpan(tracer, spanName, spanBuilder);
        try {
            R r = invoker.get();
            return r;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw TracingUtil.traceError(span.get(), e);
        }
        finally {
            if (span != null) {
                try {
                    span.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private static <R, E1 extends VersionStoreException> R callWithOneException(Tracer tracer, String spanName, Consumer<SpanBuilder> spanBuilder, InvokerWithOneException<R, E1> invoker) throws E1 {
        SpanHolder span = TracingVersionStore.createSpan(tracer, spanName, spanBuilder);
        try {
            R r = invoker.handle();
            return r;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw TracingUtil.traceError(span.get(), e);
        }
        finally {
            if (span != null) {
                try {
                    span.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private static <R, E1 extends VersionStoreException, E2 extends VersionStoreException> R callWithTwoExceptions(Tracer tracer, String spanName, Consumer<SpanBuilder> spanBuilder, InvokerWithTwoExceptionsR<R, E1, E2> invoker) throws E1, E2 {
        SpanHolder span = TracingVersionStore.createSpan(tracer, spanName, spanBuilder);
        try {
            R r = invoker.handle();
            return r;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw TracingUtil.traceError(span.get(), e);
        }
        finally {
            if (span != null) {
                try {
                    span.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private static String safeRefName(NamedRef ref) {
        return ref != null ? ref.getName() : "<null>";
    }

    private static class SpanHolder
    implements Closeable {
        private final Span span;
        private final Scope scope;

        private SpanHolder(Span span) {
            this.span = span;
            this.scope = span.makeCurrent();
        }

        private Span get() {
            return this.span;
        }

        @Override
        public void close() {
            try {
                this.scope.close();
            }
            finally {
                this.span.end();
            }
        }
    }

    @FunctionalInterface
    static interface InvokerWithTwoExceptionsR<R, E1 extends VersionStoreException, E2 extends VersionStoreException> {
        public R handle() throws E1, E2;
    }

    @FunctionalInterface
    static interface InvokerWithOneException<R, E1 extends VersionStoreException> {
        public R handle() throws E1;
    }
}

