/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import io.micrometer.core.annotation.Counted;
import io.micrometer.core.annotation.Timed;
import io.opentelemetry.instrumentation.annotations.SpanAttribute;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IdentifiedContentKey;
import org.projectnessie.model.RepositoryConfig;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.CommitResult;
import org.projectnessie.versioned.ContentResult;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.KeyEntry;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceAssignedResult;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceCreatedResult;
import org.projectnessie.versioned.ReferenceDeletedResult;
import org.projectnessie.versioned.ReferenceHistory;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.RelativeCommitSpec;
import org.projectnessie.versioned.RepositoryInformation;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.paging.PaginationIterator;

public class ObservingVersionStore
implements VersionStore {
    private final VersionStore delegate;
    private static final String PREFIX = "nessie.versionstore.request";
    private static final String TAG_REF = "ref";
    private static final String TAG_BRANCH = "branch";
    private static final String TAG_HASH = "hash";
    private static final String TAG_EXPECTED_HASH = "expected-hash";
    private static final String TAG_TARGET_HASH = "target-hash";
    private static final String TAG_FROM = "from";
    private static final String TAG_TO = "to";

    public ObservingVersionStore(VersionStore delegate) {
        this.delegate = delegate;
    }

    @Override
    @Nonnull
    @WithSpan
    @Counted(value="nessie.versionstore.request")
    @Timed(value="nessie.versionstore.request", histogram=true)
    public RepositoryInformation getRepositoryInformation() {
        return this.delegate.getRepositoryInformation();
    }

    @Override
    @WithSpan
    @Counted(value="nessie.versionstore.request")
    @Timed(value="nessie.versionstore.request", histogram=true)
    public Hash hashOnReference(@SpanAttribute(value="ref") NamedRef namedReference, @SpanAttribute(value="hash") Optional<Hash> hashOnReference, List<RelativeCommitSpec> relativeLookups) throws ReferenceNotFoundException {
        return this.delegate.hashOnReference(namedReference, hashOnReference, relativeLookups);
    }

    @Override
    @Nonnull
    public Hash noAncestorHash() {
        return this.delegate.noAncestorHash();
    }

    @Override
    @WithSpan
    @Counted(value="nessie.versionstore.request")
    @Timed(value="nessie.versionstore.request", histogram=true)
    public CommitResult<Commit> commit(@SpanAttribute(value="branch") @Nonnull BranchName branch, @SpanAttribute(value="hash") @Nonnull Optional<Hash> referenceHash, @Nonnull CommitMeta metadata, @Nonnull List<Operation> operations, @Nonnull VersionStore.CommitValidator validator, @Nonnull BiConsumer<ContentKey, String> addedContents) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.delegate.commit(branch, referenceHash, metadata, operations, validator, addedContents);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.versionstore.request")
    @Timed(value="nessie.versionstore.request", histogram=true)
    public MergeResult<Commit> transplant(VersionStore.TransplantOp transplantOp) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.delegate.transplant(transplantOp);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.versionstore.request")
    @Timed(value="nessie.versionstore.request", histogram=true)
    public MergeResult<Commit> merge(VersionStore.MergeOp mergeOp) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.delegate.merge(mergeOp);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.versionstore.request")
    @Timed(value="nessie.versionstore.request", histogram=true)
    public ReferenceAssignedResult assign(@SpanAttribute(value="ref") NamedRef ref, @SpanAttribute(value="expected-hash") Hash expectedHash, @SpanAttribute(value="target-hash") Hash targetHash) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.delegate.assign(ref, expectedHash, targetHash);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.versionstore.request")
    @Timed(value="nessie.versionstore.request", histogram=true)
    public ReferenceCreatedResult create(@SpanAttribute(value="ref") NamedRef ref, @SpanAttribute(value="target-hash") Optional<Hash> targetHash) throws ReferenceNotFoundException, ReferenceAlreadyExistsException {
        return this.delegate.create(ref, targetHash);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.versionstore.request")
    @Timed(value="nessie.versionstore.request", histogram=true)
    public ReferenceDeletedResult delete(@SpanAttribute(value="ref") NamedRef ref, @SpanAttribute(value="hash") Hash hash) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.delegate.delete(ref, hash);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.versionstore.request")
    @Timed(value="nessie.versionstore.request", histogram=true)
    public ReferenceInfo<CommitMeta> getNamedRef(@SpanAttribute(value="ref") String ref, GetNamedRefsParams params) throws ReferenceNotFoundException {
        return this.delegate.getNamedRef(ref, params);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.versionstore.request")
    @Timed(value="nessie.versionstore.request", histogram=true)
    public ReferenceHistory getReferenceHistory(String refName, Integer headCommitsToScan) throws ReferenceNotFoundException {
        return this.delegate.getReferenceHistory(refName, headCommitsToScan);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.versionstore.request")
    @Timed(value="nessie.versionstore.request", histogram=true)
    public PaginationIterator<ReferenceInfo<CommitMeta>> getNamedRefs(GetNamedRefsParams params, String pagingToken) throws ReferenceNotFoundException {
        return this.delegate.getNamedRefs(params, pagingToken);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.versionstore.request")
    @Timed(value="nessie.versionstore.request", histogram=true)
    public PaginationIterator<Commit> getCommits(@SpanAttribute(value="ref") Ref ref, boolean fetchAdditionalInfo) throws ReferenceNotFoundException {
        return this.delegate.getCommits(ref, fetchAdditionalInfo);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.versionstore.request")
    @Timed(value="nessie.versionstore.request", histogram=true)
    public PaginationIterator<KeyEntry> getKeys(@SpanAttribute(value="ref") Ref ref, String pagingToken, boolean withContent, VersionStore.KeyRestrictions keyRestrictions) throws ReferenceNotFoundException {
        return this.delegate.getKeys(ref, pagingToken, withContent, keyRestrictions);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.versionstore.request")
    @Timed(value="nessie.versionstore.request", histogram=true)
    public List<IdentifiedContentKey> getIdentifiedKeys(@SpanAttribute(value="ref") Ref ref, Collection<ContentKey> keys) throws ReferenceNotFoundException {
        return this.delegate.getIdentifiedKeys(ref, keys);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.versionstore.request")
    @Timed(value="nessie.versionstore.request", histogram=true)
    public ContentResult getValue(@SpanAttribute(value="ref") Ref ref, ContentKey key) throws ReferenceNotFoundException {
        return this.delegate.getValue(ref, key);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.versionstore.request")
    @Timed(value="nessie.versionstore.request", histogram=true)
    public Map<ContentKey, ContentResult> getValues(@SpanAttribute(value="ref") Ref ref, Collection<ContentKey> keys) throws ReferenceNotFoundException {
        return this.delegate.getValues(ref, keys);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.versionstore.request")
    @Timed(value="nessie.versionstore.request", histogram=true)
    public PaginationIterator<Diff> getDiffs(@SpanAttribute(value="from") Ref from, @SpanAttribute(value="to") Ref to, String pagingToken, VersionStore.KeyRestrictions keyRestrictions) throws ReferenceNotFoundException {
        return this.delegate.getDiffs(from, to, pagingToken, keyRestrictions);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.versionstore.request")
    @Timed(value="nessie.versionstore.request", histogram=true)
    public List<RepositoryConfig> getRepositoryConfig(Set<RepositoryConfig.Type> repositoryConfigTypes) {
        return this.delegate.getRepositoryConfig(repositoryConfigTypes);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.versionstore.request")
    @Timed(value="nessie.versionstore.request", histogram=true)
    public RepositoryConfig updateRepositoryConfig(RepositoryConfig repositoryConfig) throws ReferenceConflictException {
        return this.delegate.updateRepositoryConfig(repositoryConfig);
    }
}

