/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IdentifiedContentKey;
import org.projectnessie.model.RepositoryConfig;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.CommitResult;
import org.projectnessie.versioned.ContentResult;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.KeyEntry;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceAssignedResult;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceCreatedResult;
import org.projectnessie.versioned.ReferenceDeletedResult;
import org.projectnessie.versioned.ReferenceHistory;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.RelativeCommitSpec;
import org.projectnessie.versioned.RepositoryInformation;
import org.projectnessie.versioned.Result;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.paging.PaginationIterator;

public class EventsVersionStore
implements VersionStore {
    private final VersionStore delegate;
    private final Consumer<Result> resultSink;

    public EventsVersionStore(VersionStore delegate, Consumer<Result> resultSink) {
        this.delegate = delegate;
        this.resultSink = resultSink;
    }

    @Override
    public CommitResult<Commit> commit(@javax.annotation.Nonnull @Nonnull BranchName branch, @javax.annotation.Nonnull @Nonnull Optional<Hash> referenceHash, @javax.annotation.Nonnull @Nonnull CommitMeta metadata, @javax.annotation.Nonnull @Nonnull List<Operation> operations, @javax.annotation.Nonnull @Nonnull VersionStore.CommitValidator validator, @javax.annotation.Nonnull @Nonnull BiConsumer<ContentKey, String> addedContents) throws ReferenceNotFoundException, ReferenceConflictException {
        CommitResult<Commit> result = this.delegate.commit(branch, referenceHash, metadata, operations, validator, addedContents);
        this.resultSink.accept(result);
        return result;
    }

    @Override
    public MergeResult<Commit> transplant(VersionStore.TransplantOp transplantOp) throws ReferenceNotFoundException, ReferenceConflictException {
        MergeResult<Commit> result = this.delegate.transplant(transplantOp);
        if (result.wasApplied()) {
            this.resultSink.accept(result);
        }
        return result;
    }

    @Override
    public MergeResult<Commit> merge(VersionStore.MergeOp mergeOp) throws ReferenceNotFoundException, ReferenceConflictException {
        MergeResult<Commit> result = this.delegate.merge(mergeOp);
        if (result.wasApplied()) {
            this.resultSink.accept(result);
        }
        return result;
    }

    @Override
    public ReferenceAssignedResult assign(NamedRef ref, Hash expectedHash, Hash targetHash) throws ReferenceNotFoundException, ReferenceConflictException {
        ReferenceAssignedResult result = this.delegate.assign(ref, expectedHash, targetHash);
        this.resultSink.accept(result);
        return result;
    }

    @Override
    public ReferenceCreatedResult create(NamedRef ref, Optional<Hash> targetHash) throws ReferenceNotFoundException, ReferenceAlreadyExistsException {
        ReferenceCreatedResult result = this.delegate.create(ref, targetHash);
        this.resultSink.accept(result);
        return result;
    }

    @Override
    public ReferenceDeletedResult delete(NamedRef ref, Hash hash) throws ReferenceNotFoundException, ReferenceConflictException {
        ReferenceDeletedResult result = this.delegate.delete(ref, hash);
        this.resultSink.accept(result);
        return result;
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public RepositoryInformation getRepositoryInformation() {
        return this.delegate.getRepositoryInformation();
    }

    @Override
    public Hash hashOnReference(NamedRef namedReference, Optional<Hash> hashOnReference, List<RelativeCommitSpec> relativeLookups) throws ReferenceNotFoundException {
        return this.delegate.hashOnReference(namedReference, hashOnReference, relativeLookups);
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public Hash noAncestorHash() {
        return this.delegate.noAncestorHash();
    }

    @Override
    public ReferenceInfo<CommitMeta> getNamedRef(String ref, GetNamedRefsParams params) throws ReferenceNotFoundException {
        return this.delegate.getNamedRef(ref, params);
    }

    @Override
    public ReferenceHistory getReferenceHistory(String refName, Integer headCommitsToScan) throws ReferenceNotFoundException {
        return this.delegate.getReferenceHistory(refName, headCommitsToScan);
    }

    @Override
    public PaginationIterator<ReferenceInfo<CommitMeta>> getNamedRefs(GetNamedRefsParams params, String pagingToken) throws ReferenceNotFoundException {
        return this.delegate.getNamedRefs(params, pagingToken);
    }

    @Override
    public PaginationIterator<Commit> getCommits(Ref ref, boolean fetchAdditionalInfo) throws ReferenceNotFoundException {
        return this.delegate.getCommits(ref, fetchAdditionalInfo);
    }

    @Override
    public PaginationIterator<KeyEntry> getKeys(Ref ref, String pagingToken, boolean withContent, VersionStore.KeyRestrictions keyRestrictions) throws ReferenceNotFoundException {
        return this.delegate.getKeys(ref, pagingToken, withContent, keyRestrictions);
    }

    @Override
    public List<IdentifiedContentKey> getIdentifiedKeys(Ref ref, Collection<ContentKey> keys) throws ReferenceNotFoundException {
        return this.delegate.getIdentifiedKeys(ref, keys);
    }

    @Override
    public ContentResult getValue(Ref ref, ContentKey key) throws ReferenceNotFoundException {
        return this.delegate.getValue(ref, key);
    }

    @Override
    public Map<ContentKey, ContentResult> getValues(Ref ref, Collection<ContentKey> keys) throws ReferenceNotFoundException {
        return this.delegate.getValues(ref, keys);
    }

    @Override
    public PaginationIterator<Diff> getDiffs(Ref from, Ref to, String pagingToken, VersionStore.KeyRestrictions keyRestrictions) throws ReferenceNotFoundException {
        return this.delegate.getDiffs(from, to, pagingToken, keyRestrictions);
    }

    @Override
    public List<RepositoryConfig> getRepositoryConfig(Set<RepositoryConfig.Type> repositoryConfigTypes) {
        return this.delegate.getRepositoryConfig(repositoryConfigTypes);
    }

    @Override
    public RepositoryConfig updateRepositoryConfig(RepositoryConfig repositoryConfig) throws ReferenceConflictException {
        return this.delegate.updateRepositoryConfig(repositoryConfig);
    }
}

