/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Conflict;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.MergeResult;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MergeResult.KeyDetails", generator="Immutables")
@Immutable
public final class ImmutableKeyDetails
implements MergeResult.KeyDetails {
    private final MergeBehavior mergeBehavior;
    private final MergeResult.ConflictType conflictType;
    private final ImmutableList<Hash> sourceCommits;
    private final ImmutableList<Hash> targetCommits;
    @Nullable
    private final Conflict conflict;

    private ImmutableKeyDetails(MergeBehavior mergeBehavior, MergeResult.ConflictType conflictType, @Nullable Conflict conflict) {
        this.mergeBehavior = Objects.requireNonNull(mergeBehavior, "mergeBehavior");
        this.conflictType = Objects.requireNonNull(conflictType, "conflictType");
        this.conflict = conflict;
        this.sourceCommits = ImmutableList.of();
        this.targetCommits = ImmutableList.of();
    }

    private ImmutableKeyDetails(Builder builder) {
        this.mergeBehavior = builder.mergeBehavior;
        this.sourceCommits = builder.sourceCommits.build();
        this.targetCommits = builder.targetCommits.build();
        this.conflict = builder.conflict;
        this.conflictType = builder.conflictType != null ? builder.conflictType : Objects.requireNonNull(MergeResult.KeyDetails.super.getConflictType(), "conflictType");
    }

    private ImmutableKeyDetails(MergeBehavior mergeBehavior, MergeResult.ConflictType conflictType, ImmutableList<Hash> sourceCommits, ImmutableList<Hash> targetCommits, @Nullable Conflict conflict) {
        this.mergeBehavior = mergeBehavior;
        this.conflictType = conflictType;
        this.sourceCommits = sourceCommits;
        this.targetCommits = targetCommits;
        this.conflict = conflict;
    }

    @Override
    public MergeBehavior getMergeBehavior() {
        return this.mergeBehavior;
    }

    @Override
    @Deprecated
    public MergeResult.ConflictType getConflictType() {
        return this.conflictType;
    }

    @Deprecated
    public ImmutableList<Hash> getSourceCommits() {
        return this.sourceCommits;
    }

    @Deprecated
    public ImmutableList<Hash> getTargetCommits() {
        return this.targetCommits;
    }

    @Override
    @Nullable
    public Conflict getConflict() {
        return this.conflict;
    }

    public final ImmutableKeyDetails withMergeBehavior(MergeBehavior value) {
        MergeBehavior newValue = Objects.requireNonNull(value, "mergeBehavior");
        if (this.mergeBehavior == newValue) {
            return this;
        }
        return new ImmutableKeyDetails(newValue, this.conflictType, this.sourceCommits, this.targetCommits, this.conflict);
    }

    @Deprecated
    public final ImmutableKeyDetails withConflictType(MergeResult.ConflictType value) {
        MergeResult.ConflictType newValue = Objects.requireNonNull(value, "conflictType");
        if (this.conflictType == newValue) {
            return this;
        }
        return new ImmutableKeyDetails(this.mergeBehavior, newValue, this.sourceCommits, this.targetCommits, this.conflict);
    }

    @Deprecated
    public final ImmutableKeyDetails withSourceCommits(Hash ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableKeyDetails(this.mergeBehavior, this.conflictType, (ImmutableList<Hash>)newValue, this.targetCommits, this.conflict);
    }

    @Deprecated
    public final ImmutableKeyDetails withSourceCommits(Iterable<? extends Hash> elements) {
        if (this.sourceCommits == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableKeyDetails(this.mergeBehavior, this.conflictType, (ImmutableList<Hash>)newValue, this.targetCommits, this.conflict);
    }

    @Deprecated
    public final ImmutableKeyDetails withTargetCommits(Hash ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableKeyDetails(this.mergeBehavior, this.conflictType, this.sourceCommits, (ImmutableList<Hash>)newValue, this.conflict);
    }

    @Deprecated
    public final ImmutableKeyDetails withTargetCommits(Iterable<? extends Hash> elements) {
        if (this.targetCommits == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableKeyDetails(this.mergeBehavior, this.conflictType, this.sourceCommits, (ImmutableList<Hash>)newValue, this.conflict);
    }

    public final ImmutableKeyDetails withConflict(@Nullable Conflict value) {
        if (this.conflict == value) {
            return this;
        }
        return new ImmutableKeyDetails(this.mergeBehavior, this.conflictType, this.sourceCommits, this.targetCommits, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyDetails && this.equalTo(0, (ImmutableKeyDetails)another);
    }

    private boolean equalTo(int synthetic, ImmutableKeyDetails another) {
        return this.mergeBehavior.equals((Object)another.mergeBehavior) && this.conflictType.equals((Object)another.conflictType) && this.sourceCommits.equals(another.sourceCommits) && this.targetCommits.equals(another.targetCommits) && Objects.equals(this.conflict, another.conflict);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.mergeBehavior.hashCode();
        h += (h << 5) + this.conflictType.hashCode();
        h += (h << 5) + this.sourceCommits.hashCode();
        h += (h << 5) + this.targetCommits.hashCode();
        h += (h << 5) + Objects.hashCode(this.conflict);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"KeyDetails").omitNullValues().add("mergeBehavior", (Object)this.mergeBehavior).add("conflictType", (Object)this.conflictType).add("sourceCommits", this.sourceCommits).add("targetCommits", this.targetCommits).add("conflict", (Object)this.conflict).toString();
    }

    public static ImmutableKeyDetails of(MergeBehavior mergeBehavior, MergeResult.ConflictType conflictType, @Nullable Conflict conflict) {
        return new ImmutableKeyDetails(mergeBehavior, conflictType, conflict);
    }

    public static ImmutableKeyDetails copyOf(MergeResult.KeyDetails instance) {
        if (instance instanceof ImmutableKeyDetails) {
            return (ImmutableKeyDetails)instance;
        }
        return ImmutableKeyDetails.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MergeResult.KeyDetails", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MERGE_BEHAVIOR = 1L;
        private long initBits = 1L;
        @javax.annotation.Nullable
        private MergeBehavior mergeBehavior;
        @javax.annotation.Nullable
        private MergeResult.ConflictType conflictType;
        private ImmutableList.Builder<Hash> sourceCommits = ImmutableList.builder();
        private ImmutableList.Builder<Hash> targetCommits = ImmutableList.builder();
        @javax.annotation.Nullable
        private Conflict conflict;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MergeResult.KeyDetails instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeBehavior(instance.getMergeBehavior());
            this.conflictType(instance.getConflictType());
            this.addAllSourceCommits(instance.getSourceCommits());
            this.addAllTargetCommits(instance.getTargetCommits());
            Conflict conflictValue = instance.getConflict();
            if (conflictValue != null) {
                this.conflict(conflictValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mergeBehavior(MergeBehavior mergeBehavior) {
            this.mergeBehavior = Objects.requireNonNull(mergeBehavior, "mergeBehavior");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder conflictType(MergeResult.ConflictType conflictType) {
            this.conflictType = Objects.requireNonNull(conflictType, "conflictType");
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder addSourceCommits(Hash element) {
            this.sourceCommits.add((Object)element);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder addSourceCommits(Hash ... elements) {
            this.sourceCommits.add((Object[])elements);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder sourceCommits(Iterable<? extends Hash> elements) {
            this.sourceCommits = ImmutableList.builder();
            return this.addAllSourceCommits(elements);
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder addAllSourceCommits(Iterable<? extends Hash> elements) {
            this.sourceCommits.addAll(elements);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder addTargetCommits(Hash element) {
            this.targetCommits.add((Object)element);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder addTargetCommits(Hash ... elements) {
            this.targetCommits.add((Object[])elements);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder targetCommits(Iterable<? extends Hash> elements) {
            this.targetCommits = ImmutableList.builder();
            return this.addAllTargetCommits(elements);
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder addAllTargetCommits(Iterable<? extends Hash> elements) {
            this.targetCommits.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder conflict(@Nullable Conflict conflict) {
            this.conflict = conflict;
            return this;
        }

        public ImmutableKeyDetails build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableKeyDetails(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("mergeBehavior");
            }
            return "Cannot build KeyDetails, some of required attributes are not set " + attributes;
        }
    }
}

