/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.projectnessie.error.ReferenceConflicts;
import org.projectnessie.model.Conflict;
import org.projectnessie.versioned.VersionStoreException;

public class ReferenceConflictException
extends VersionStoreException {
    private static final long serialVersionUID = 4381980193289615523L;
    private final ReferenceConflicts referenceConflicts;

    public ReferenceConflictException(String message) {
        this(null, message);
    }

    public ReferenceConflictException(Conflict conflict) {
        this(Collections.singletonList(conflict));
    }

    public ReferenceConflictException(List<Conflict> conflicts) {
        this(ReferenceConflicts.referenceConflicts(conflicts), ReferenceConflictException.buildMessage(conflicts));
    }

    private static String buildMessage(List<Conflict> conflicts) {
        if (conflicts.size() == 1) {
            String msg = conflicts.get(0).message();
            return Character.toUpperCase(msg.charAt(0)) + msg.substring(1) + '.';
        }
        return "There are multiple conflicts that prevent committing the provided operations: " + conflicts.stream().map(Conflict::message).collect(Collectors.joining(", ")) + ".";
    }

    public ReferenceConflictException(ReferenceConflicts referenceConflicts, String message) {
        super(message);
        this.referenceConflicts = referenceConflicts;
    }

    public ReferenceConflictException(String message, Throwable t) {
        super(message, t);
        this.referenceConflicts = null;
    }

    public ReferenceConflicts getReferenceConflicts() {
        return this.referenceConflicts;
    }
}

