/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import org.immutables.value.Value;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IdentifiedContentKey;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.model.MergeKeyBehavior;
import org.projectnessie.model.RepositoryConfig;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Commit;
import org.projectnessie.versioned.CommitResult;
import org.projectnessie.versioned.CommitValidation;
import org.projectnessie.versioned.ContentResult;
import org.projectnessie.versioned.DefaultMetadataRewriter;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ImmutableKeyRestrictions;
import org.projectnessie.versioned.ImmutableMergeOp;
import org.projectnessie.versioned.ImmutableTransplantOp;
import org.projectnessie.versioned.KeyEntry;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.MetadataRewriter;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceAssignedResult;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceCreatedResult;
import org.projectnessie.versioned.ReferenceDeletedResult;
import org.projectnessie.versioned.ReferenceHistory;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.RelativeCommitSpec;
import org.projectnessie.versioned.RepositoryInformation;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.paging.PaginationIterator;

public interface VersionStore {
    @javax.annotation.Nonnull
    @Nonnull
    public RepositoryInformation getRepositoryInformation();

    public Hash hashOnReference(NamedRef var1, Optional<Hash> var2, List<RelativeCommitSpec> var3) throws ReferenceNotFoundException;

    @javax.annotation.Nonnull
    @Nonnull
    public Hash noAncestorHash();

    public CommitResult<Commit> commit(@javax.annotation.Nonnull @Nonnull BranchName var1, @javax.annotation.Nonnull @Nonnull Optional<Hash> var2, @javax.annotation.Nonnull @Nonnull CommitMeta var3, @javax.annotation.Nonnull @Nonnull List<Operation> var4, @javax.annotation.Nonnull @Nonnull CommitValidator var5, @javax.annotation.Nonnull @Nonnull BiConsumer<ContentKey, String> var6) throws ReferenceNotFoundException, ReferenceConflictException;

    default public CommitResult<Commit> commit(@javax.annotation.Nonnull @Nonnull BranchName branch, @javax.annotation.Nonnull @Nonnull Optional<Hash> referenceHash, @javax.annotation.Nonnull @Nonnull CommitMeta metadata, @javax.annotation.Nonnull @Nonnull List<Operation> operations) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.commit(branch, referenceHash, metadata, operations, x -> {}, (k, c) -> {});
    }

    public List<RepositoryConfig> getRepositoryConfig(Set<RepositoryConfig.Type> var1);

    public RepositoryConfig updateRepositoryConfig(RepositoryConfig var1) throws ReferenceConflictException;

    public MergeResult<Commit> transplant(TransplantOp var1) throws ReferenceNotFoundException, ReferenceConflictException;

    public MergeResult<Commit> merge(MergeOp var1) throws ReferenceNotFoundException, ReferenceConflictException;

    public ReferenceAssignedResult assign(NamedRef var1, Hash var2, Hash var3) throws ReferenceNotFoundException, ReferenceConflictException;

    public ReferenceCreatedResult create(NamedRef var1, Optional<Hash> var2) throws ReferenceNotFoundException, ReferenceAlreadyExistsException;

    public ReferenceDeletedResult delete(NamedRef var1, Hash var2) throws ReferenceNotFoundException, ReferenceConflictException;

    public ReferenceInfo<CommitMeta> getNamedRef(String var1, GetNamedRefsParams var2) throws ReferenceNotFoundException;

    public ReferenceHistory getReferenceHistory(String var1, Integer var2) throws ReferenceNotFoundException;

    public PaginationIterator<ReferenceInfo<CommitMeta>> getNamedRefs(GetNamedRefsParams var1, String var2) throws ReferenceNotFoundException;

    public PaginationIterator<Commit> getCommits(Ref var1, boolean var2) throws ReferenceNotFoundException;

    public PaginationIterator<KeyEntry> getKeys(Ref var1, String var2, boolean var3, KeyRestrictions var4) throws ReferenceNotFoundException;

    public List<IdentifiedContentKey> getIdentifiedKeys(Ref var1, Collection<ContentKey> var2) throws ReferenceNotFoundException;

    public ContentResult getValue(Ref var1, ContentKey var2) throws ReferenceNotFoundException;

    public Map<ContentKey, ContentResult> getValues(Ref var1, Collection<ContentKey> var2) throws ReferenceNotFoundException;

    public PaginationIterator<Diff> getDiffs(Ref var1, Ref var2, String var3, KeyRestrictions var4) throws ReferenceNotFoundException;

    @Value.Immutable
    public static interface KeyRestrictions {
        public static final KeyRestrictions NO_KEY_RESTRICTIONS = KeyRestrictions.builder().build();

        @javax.annotation.Nullable
        @Nullable
        public ContentKey minKey();

        @javax.annotation.Nullable
        @Nullable
        public ContentKey maxKey();

        @javax.annotation.Nullable
        @Nullable
        public ContentKey prefixKey();

        @javax.annotation.Nullable
        @Nullable
        public BiPredicate<ContentKey, Content.Type> contentKeyPredicate();

        public static ImmutableKeyRestrictions.Builder builder() {
            return ImmutableKeyRestrictions.builder();
        }
    }

    @Value.Immutable
    public static interface TransplantOp
    extends MergeTransplantOpBase {
        public List<Hash> sequenceToTransplant();

        public static ImmutableTransplantOp.Builder builder() {
            return ImmutableTransplantOp.builder();
        }
    }

    @Value.Immutable
    public static interface MergeOp
    extends MergeTransplantOpBase {
        public Hash fromHash();

        public static ImmutableMergeOp.Builder builder() {
            return ImmutableMergeOp.builder();
        }
    }

    public static interface MergeTransplantOpBase {
        public NamedRef fromRef();

        public BranchName toBranch();

        @Value.Default
        default public Optional<Hash> expectedHash() {
            return Optional.empty();
        }

        @Value.Default
        default public MetadataRewriter<CommitMeta> updateCommitMetadata() {
            return DefaultMetadataRewriter.DEFAULT_METADATA_REWRITER;
        }

        public Map<ContentKey, MergeKeyBehavior> mergeKeyBehaviors();

        @Value.Default
        default public MergeBehavior defaultMergeBehavior() {
            return MergeBehavior.NORMAL;
        }

        @Value.Default
        default public boolean dryRun() {
            return false;
        }

        @Value.Default
        default public boolean fetchAdditionalInfo() {
            return false;
        }

        @Value.Default
        default public CommitValidator validator() {
            return commitValidation -> {};
        }
    }

    @FunctionalInterface
    public static interface CommitValidator {
        public void validate(CommitValidation var1) throws BaseNessieClientServerException, VersionStoreException;
    }
}

