/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.ContentKey;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Result;
import org.projectnessie.versioned.ResultType;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MergeResult", generator="Immutables")
@Immutable
public final class ImmutableMergeResult<COMMIT>
implements MergeResult<COMMIT> {
    private final ResultType resultType;
    private final boolean wasApplied;
    private final boolean wasSuccessful;
    @Nullable
    private final Hash resultantTargetHash;
    @Nullable
    private final Hash commonAncestor;
    private final NamedRef sourceRef;
    private final BranchName targetBranch;
    private final Hash effectiveTargetHash;
    @Nullable
    private final Hash expectedHash;
    private final ImmutableList<COMMIT> sourceCommits;
    @Nullable
    private final ImmutableList<COMMIT> targetCommits;
    private final ImmutableList<COMMIT> createdCommits;
    private final ImmutableMap<ContentKey, MergeResult.KeyDetails> details;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMergeResult(Builder<COMMIT> builder) {
        this.resultType = builder.resultType;
        this.resultantTargetHash = builder.resultantTargetHash;
        this.commonAncestor = builder.commonAncestor;
        this.sourceRef = builder.sourceRef;
        this.targetBranch = builder.targetBranch;
        this.effectiveTargetHash = builder.effectiveTargetHash;
        this.expectedHash = builder.expectedHash;
        this.sourceCommits = builder.sourceCommits.build();
        this.targetCommits = builder.targetCommits == null ? null : builder.targetCommits.build();
        this.createdCommits = builder.createdCommits.build();
        this.details = builder.details.build();
        if (builder.wasAppliedIsSet()) {
            this.initShim.wasApplied(builder.wasApplied);
        }
        if (builder.wasSuccessfulIsSet()) {
            this.initShim.wasSuccessful(builder.wasSuccessful);
        }
        this.wasApplied = this.initShim.wasApplied();
        this.wasSuccessful = this.initShim.wasSuccessful();
        this.initShim = null;
    }

    private ImmutableMergeResult(ResultType resultType, boolean wasApplied, boolean wasSuccessful, @Nullable Hash resultantTargetHash, @Nullable Hash commonAncestor, NamedRef sourceRef, BranchName targetBranch, Hash effectiveTargetHash, @Nullable Hash expectedHash, ImmutableList<COMMIT> sourceCommits, @Nullable ImmutableList<COMMIT> targetCommits, ImmutableList<COMMIT> createdCommits, ImmutableMap<ContentKey, MergeResult.KeyDetails> details) {
        this.resultType = resultType;
        this.wasApplied = wasApplied;
        this.wasSuccessful = wasSuccessful;
        this.resultantTargetHash = resultantTargetHash;
        this.commonAncestor = commonAncestor;
        this.sourceRef = sourceRef;
        this.targetBranch = targetBranch;
        this.effectiveTargetHash = effectiveTargetHash;
        this.expectedHash = expectedHash;
        this.sourceCommits = sourceCommits;
        this.targetCommits = targetCommits;
        this.createdCommits = createdCommits;
        this.details = details;
        this.initShim = null;
    }

    private boolean wasAppliedInitialize() {
        return MergeResult.super.wasApplied();
    }

    private boolean wasSuccessfulInitialize() {
        return MergeResult.super.wasSuccessful();
    }

    @Override
    public ResultType getResultType() {
        return this.resultType;
    }

    @Override
    public boolean wasApplied() {
        InitShim shim = this.initShim;
        return shim != null ? shim.wasApplied() : this.wasApplied;
    }

    @Override
    public boolean wasSuccessful() {
        InitShim shim = this.initShim;
        return shim != null ? shim.wasSuccessful() : this.wasSuccessful;
    }

    @Override
    @Nullable
    public Hash getResultantTargetHash() {
        return this.resultantTargetHash;
    }

    @Override
    @Nullable
    public Hash getCommonAncestor() {
        return this.commonAncestor;
    }

    @Override
    public NamedRef getSourceRef() {
        return this.sourceRef;
    }

    @Override
    public BranchName getTargetBranch() {
        return this.targetBranch;
    }

    @Override
    public Hash getEffectiveTargetHash() {
        return this.effectiveTargetHash;
    }

    @Override
    @Nullable
    public Hash getExpectedHash() {
        return this.expectedHash;
    }

    @Override
    @Deprecated
    public ImmutableList<COMMIT> getSourceCommits() {
        return this.sourceCommits;
    }

    @Override
    @Deprecated
    @Nullable
    public ImmutableList<COMMIT> getTargetCommits() {
        return this.targetCommits;
    }

    @Override
    public ImmutableList<COMMIT> getCreatedCommits() {
        return this.createdCommits;
    }

    public ImmutableMap<ContentKey, MergeResult.KeyDetails> getDetails() {
        return this.details;
    }

    public final ImmutableMergeResult<COMMIT> withResultType(ResultType value) {
        ResultType newValue = Objects.requireNonNull(value, "resultType");
        if (this.resultType == newValue) {
            return this;
        }
        return new ImmutableMergeResult<COMMIT>(newValue, this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.sourceCommits, this.targetCommits, this.createdCommits, this.details);
    }

    public final ImmutableMergeResult<COMMIT> withWasApplied(boolean value) {
        if (this.wasApplied == value) {
            return this;
        }
        return new ImmutableMergeResult<COMMIT>(this.resultType, value, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.sourceCommits, this.targetCommits, this.createdCommits, this.details);
    }

    public final ImmutableMergeResult<COMMIT> withWasSuccessful(boolean value) {
        if (this.wasSuccessful == value) {
            return this;
        }
        return new ImmutableMergeResult<COMMIT>(this.resultType, this.wasApplied, value, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.sourceCommits, this.targetCommits, this.createdCommits, this.details);
    }

    public final ImmutableMergeResult<COMMIT> withResultantTargetHash(@Nullable Hash value) {
        if (this.resultantTargetHash == value) {
            return this;
        }
        return new ImmutableMergeResult<COMMIT>(this.resultType, this.wasApplied, this.wasSuccessful, value, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.sourceCommits, this.targetCommits, this.createdCommits, this.details);
    }

    public final ImmutableMergeResult<COMMIT> withCommonAncestor(@Nullable Hash value) {
        if (this.commonAncestor == value) {
            return this;
        }
        return new ImmutableMergeResult<COMMIT>(this.resultType, this.wasApplied, this.wasSuccessful, this.resultantTargetHash, value, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.sourceCommits, this.targetCommits, this.createdCommits, this.details);
    }

    public final ImmutableMergeResult<COMMIT> withSourceRef(NamedRef value) {
        if (this.sourceRef == value) {
            return this;
        }
        NamedRef newValue = Objects.requireNonNull(value, "sourceRef");
        return new ImmutableMergeResult<COMMIT>(this.resultType, this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, newValue, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.sourceCommits, this.targetCommits, this.createdCommits, this.details);
    }

    public final ImmutableMergeResult<COMMIT> withTargetBranch(BranchName value) {
        if (this.targetBranch == value) {
            return this;
        }
        BranchName newValue = Objects.requireNonNull(value, "targetBranch");
        return new ImmutableMergeResult<COMMIT>(this.resultType, this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, newValue, this.effectiveTargetHash, this.expectedHash, this.sourceCommits, this.targetCommits, this.createdCommits, this.details);
    }

    public final ImmutableMergeResult<COMMIT> withEffectiveTargetHash(Hash value) {
        if (this.effectiveTargetHash == value) {
            return this;
        }
        Hash newValue = Objects.requireNonNull(value, "effectiveTargetHash");
        return new ImmutableMergeResult<COMMIT>(this.resultType, this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, newValue, this.expectedHash, this.sourceCommits, this.targetCommits, this.createdCommits, this.details);
    }

    public final ImmutableMergeResult<COMMIT> withExpectedHash(@Nullable Hash value) {
        if (this.expectedHash == value) {
            return this;
        }
        return new ImmutableMergeResult<COMMIT>(this.resultType, this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, value, this.sourceCommits, this.targetCommits, this.createdCommits, this.details);
    }

    @SafeVarargs
    @Deprecated
    public final ImmutableMergeResult<COMMIT> withSourceCommits(COMMIT ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMergeResult<COMMIT>(this.resultType, this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, newValue, this.targetCommits, this.createdCommits, this.details);
    }

    @Deprecated
    public final ImmutableMergeResult<COMMIT> withSourceCommits(Iterable<? extends COMMIT> elements) {
        if (this.sourceCommits == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMergeResult<COMMIT>(this.resultType, this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, newValue, this.targetCommits, this.createdCommits, this.details);
    }

    @SafeVarargs
    @Deprecated
    public final ImmutableMergeResult<COMMIT> withTargetCommits(COMMIT ... elements) {
        if (elements == null) {
            return new ImmutableMergeResult<COMMIT>(this.resultType, this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.sourceCommits, null, this.createdCommits, this.details);
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf((Object[])elements);
        return new ImmutableMergeResult<COMMIT>(this.resultType, this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.sourceCommits, newValue, this.createdCommits, this.details);
    }

    @Deprecated
    public final ImmutableMergeResult<COMMIT> withTargetCommits(@Nullable Iterable<? extends COMMIT> elements) {
        if (this.targetCommits == elements) {
            return this;
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableMergeResult<COMMIT>(this.resultType, this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.sourceCommits, newValue, this.createdCommits, this.details);
    }

    @SafeVarargs
    public final ImmutableMergeResult<COMMIT> withCreatedCommits(COMMIT ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableMergeResult<COMMIT>(this.resultType, this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.sourceCommits, this.targetCommits, newValue, this.details);
    }

    public final ImmutableMergeResult<COMMIT> withCreatedCommits(Iterable<? extends COMMIT> elements) {
        if (this.createdCommits == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableMergeResult<COMMIT>(this.resultType, this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.sourceCommits, this.targetCommits, newValue, this.details);
    }

    public final ImmutableMergeResult<COMMIT> withDetails(Map<? extends ContentKey, ? extends MergeResult.KeyDetails> entries) {
        if (this.details == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableMergeResult<COMMIT>(this.resultType, this.wasApplied, this.wasSuccessful, this.resultantTargetHash, this.commonAncestor, this.sourceRef, this.targetBranch, this.effectiveTargetHash, this.expectedHash, this.sourceCommits, this.targetCommits, this.createdCommits, (ImmutableMap<ContentKey, MergeResult.KeyDetails>)newValue);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMergeResult && this.equalTo(0, (ImmutableMergeResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableMergeResult<?> another) {
        return this.resultType.equals((Object)another.resultType) && this.wasApplied == another.wasApplied && this.wasSuccessful == another.wasSuccessful && Objects.equals(this.resultantTargetHash, another.resultantTargetHash) && Objects.equals(this.commonAncestor, another.commonAncestor) && this.sourceRef.equals(another.sourceRef) && this.targetBranch.equals(another.targetBranch) && this.effectiveTargetHash.equals(another.effectiveTargetHash) && Objects.equals(this.expectedHash, another.expectedHash) && this.sourceCommits.equals(another.sourceCommits) && Objects.equals(this.targetCommits, another.targetCommits) && this.createdCommits.equals(another.createdCommits) && this.details.equals(another.details);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.resultType.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.wasApplied);
        h += (h << 5) + Booleans.hashCode((boolean)this.wasSuccessful);
        h += (h << 5) + Objects.hashCode(this.resultantTargetHash);
        h += (h << 5) + Objects.hashCode(this.commonAncestor);
        h += (h << 5) + this.sourceRef.hashCode();
        h += (h << 5) + this.targetBranch.hashCode();
        h += (h << 5) + this.effectiveTargetHash.hashCode();
        h += (h << 5) + Objects.hashCode(this.expectedHash);
        h += (h << 5) + this.sourceCommits.hashCode();
        h += (h << 5) + Objects.hashCode(this.targetCommits);
        h += (h << 5) + this.createdCommits.hashCode();
        h += (h << 5) + this.details.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MergeResult").omitNullValues().add("resultType", (Object)this.resultType).add("wasApplied", this.wasApplied).add("wasSuccessful", this.wasSuccessful).add("resultantTargetHash", (Object)this.resultantTargetHash).add("commonAncestor", (Object)this.commonAncestor).add("sourceRef", (Object)this.sourceRef).add("targetBranch", (Object)this.targetBranch).add("effectiveTargetHash", (Object)this.effectiveTargetHash).add("expectedHash", (Object)this.expectedHash).add("sourceCommits", this.sourceCommits).add("targetCommits", this.targetCommits).add("createdCommits", this.createdCommits).add("details", this.details).toString();
    }

    public static <COMMIT> ImmutableMergeResult<COMMIT> copyOf(MergeResult<COMMIT> instance) {
        if (instance instanceof ImmutableMergeResult) {
            return (ImmutableMergeResult)instance;
        }
        return ImmutableMergeResult.builder().from(instance).build();
    }

    public static <COMMIT> Builder<COMMIT> builder() {
        return new Builder();
    }

    @Generated(from="MergeResult", generator="Immutables")
    private final class InitShim {
        private byte wasAppliedBuildStage = 0;
        private boolean wasApplied;
        private byte wasSuccessfulBuildStage = 0;
        private boolean wasSuccessful;

        private InitShim() {
        }

        boolean wasApplied() {
            if (this.wasAppliedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.wasAppliedBuildStage == 0) {
                this.wasAppliedBuildStage = (byte)-1;
                this.wasApplied = ImmutableMergeResult.this.wasAppliedInitialize();
                this.wasAppliedBuildStage = 1;
            }
            return this.wasApplied;
        }

        void wasApplied(boolean wasApplied) {
            this.wasApplied = wasApplied;
            this.wasAppliedBuildStage = 1;
        }

        boolean wasSuccessful() {
            if (this.wasSuccessfulBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.wasSuccessfulBuildStage == 0) {
                this.wasSuccessfulBuildStage = (byte)-1;
                this.wasSuccessful = ImmutableMergeResult.this.wasSuccessfulInitialize();
                this.wasSuccessfulBuildStage = 1;
            }
            return this.wasSuccessful;
        }

        void wasSuccessful(boolean wasSuccessful) {
            this.wasSuccessful = wasSuccessful;
            this.wasSuccessfulBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.wasAppliedBuildStage == -1) {
                attributes.add("wasApplied");
            }
            if (this.wasSuccessfulBuildStage == -1) {
                attributes.add("wasSuccessful");
            }
            return "Cannot build MergeResult, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="MergeResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<COMMIT> {
        private static final long INIT_BIT_RESULT_TYPE = 1L;
        private static final long INIT_BIT_SOURCE_REF = 2L;
        private static final long INIT_BIT_TARGET_BRANCH = 4L;
        private static final long INIT_BIT_EFFECTIVE_TARGET_HASH = 8L;
        private static final long OPT_BIT_WAS_APPLIED = 1L;
        private static final long OPT_BIT_WAS_SUCCESSFUL = 2L;
        private long initBits = 15L;
        private long optBits;
        @javax.annotation.Nullable
        private ResultType resultType;
        private boolean wasApplied;
        private boolean wasSuccessful;
        @javax.annotation.Nullable
        private Hash resultantTargetHash;
        @javax.annotation.Nullable
        private Hash commonAncestor;
        @javax.annotation.Nullable
        private NamedRef sourceRef;
        @javax.annotation.Nullable
        private BranchName targetBranch;
        @javax.annotation.Nullable
        private Hash effectiveTargetHash;
        @javax.annotation.Nullable
        private Hash expectedHash;
        private ImmutableList.Builder<COMMIT> sourceCommits = ImmutableList.builder();
        private ImmutableList.Builder<COMMIT> targetCommits = null;
        private ImmutableList.Builder<COMMIT> createdCommits = ImmutableList.builder();
        private ImmutableMap.Builder<ContentKey, MergeResult.KeyDetails> details = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<COMMIT> from(MergeResult<COMMIT> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<COMMIT> from(Result instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Result instance;
            long bits = 0L;
            if (object instanceof MergeResult) {
                Hash commonAncestorValue;
                Hash resultantTargetHashValue;
                instance = (MergeResult)object;
                this.addAllCreatedCommits(instance.getCreatedCommits());
                this.wasSuccessful(instance.wasSuccessful());
                Hash expectedHashValue = instance.getExpectedHash();
                if (expectedHashValue != null) {
                    this.expectedHash(expectedHashValue);
                }
                this.addAllSourceCommits(instance.getSourceCommits());
                this.targetBranch(instance.getTargetBranch());
                this.effectiveTargetHash(instance.getEffectiveTargetHash());
                List targetCommitsValue = instance.getTargetCommits();
                if (targetCommitsValue != null) {
                    this.addAllTargetCommits(targetCommitsValue);
                }
                if ((resultantTargetHashValue = instance.getResultantTargetHash()) != null) {
                    this.resultantTargetHash(resultantTargetHashValue);
                }
                if ((commonAncestorValue = instance.getCommonAncestor()) != null) {
                    this.commonAncestor(commonAncestorValue);
                }
                this.putAllDetails(instance.getDetails());
                this.sourceRef(instance.getSourceRef());
                if ((bits & 1L) == 0L) {
                    this.resultType(instance.getResultType());
                    bits |= 1L;
                }
                this.wasApplied(instance.wasApplied());
            }
            if (object instanceof Result) {
                instance = (Result)object;
                if ((bits & 1L) == 0L) {
                    this.resultType(instance.getResultType());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder<COMMIT> resultType(ResultType resultType) {
            this.resultType = Objects.requireNonNull(resultType, "resultType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<COMMIT> wasApplied(boolean wasApplied) {
            this.wasApplied = wasApplied;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<COMMIT> wasSuccessful(boolean wasSuccessful) {
            this.wasSuccessful = wasSuccessful;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<COMMIT> resultantTargetHash(@Nullable Hash resultantTargetHash) {
            this.resultantTargetHash = resultantTargetHash;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<COMMIT> commonAncestor(@Nullable Hash commonAncestor) {
            this.commonAncestor = commonAncestor;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<COMMIT> sourceRef(NamedRef sourceRef) {
            this.sourceRef = Objects.requireNonNull(sourceRef, "sourceRef");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<COMMIT> targetBranch(BranchName targetBranch) {
            this.targetBranch = Objects.requireNonNull(targetBranch, "targetBranch");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<COMMIT> effectiveTargetHash(Hash effectiveTargetHash) {
            this.effectiveTargetHash = Objects.requireNonNull(effectiveTargetHash, "effectiveTargetHash");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<COMMIT> expectedHash(@Nullable Hash expectedHash) {
            this.expectedHash = expectedHash;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder<COMMIT> addSourceCommits(COMMIT element) {
            this.sourceCommits.add(element);
            return this;
        }

        @Deprecated
        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder<COMMIT> addSourceCommits(COMMIT ... elements) {
            this.sourceCommits.add((Object[])elements);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder<COMMIT> sourceCommits(Iterable<? extends COMMIT> elements) {
            this.sourceCommits = ImmutableList.builder();
            return this.addAllSourceCommits(elements);
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder<COMMIT> addAllSourceCommits(Iterable<? extends COMMIT> elements) {
            this.sourceCommits.addAll(elements);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder<COMMIT> addTargetCommits(COMMIT element) {
            if (this.targetCommits == null) {
                this.targetCommits = ImmutableList.builder();
            }
            this.targetCommits.add(element);
            return this;
        }

        @Deprecated
        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder<COMMIT> addTargetCommits(COMMIT ... elements) {
            if (this.targetCommits == null) {
                this.targetCommits = ImmutableList.builder();
            }
            this.targetCommits.add((Object[])elements);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder<COMMIT> targetCommits(@Nullable Iterable<? extends COMMIT> elements) {
            if (elements == null) {
                this.targetCommits = null;
                return this;
            }
            this.targetCommits = ImmutableList.builder();
            return this.addAllTargetCommits(elements);
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder<COMMIT> addAllTargetCommits(Iterable<? extends COMMIT> elements) {
            Objects.requireNonNull(elements, "targetCommits element");
            if (this.targetCommits == null) {
                this.targetCommits = ImmutableList.builder();
            }
            this.targetCommits.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<COMMIT> addCreatedCommits(COMMIT element) {
            this.createdCommits.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder<COMMIT> addCreatedCommits(COMMIT ... elements) {
            this.createdCommits.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<COMMIT> createdCommits(Iterable<? extends COMMIT> elements) {
            this.createdCommits = ImmutableList.builder();
            return this.addAllCreatedCommits(elements);
        }

        @CanIgnoreReturnValue
        public final Builder<COMMIT> addAllCreatedCommits(Iterable<? extends COMMIT> elements) {
            this.createdCommits.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<COMMIT> putDetails(ContentKey key, MergeResult.KeyDetails value) {
            this.details.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<COMMIT> putDetails(Map.Entry<? extends ContentKey, ? extends MergeResult.KeyDetails> entry) {
            this.details.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<COMMIT> details(Map<? extends ContentKey, ? extends MergeResult.KeyDetails> entries) {
            this.details = ImmutableMap.builder();
            return this.putAllDetails(entries);
        }

        @CanIgnoreReturnValue
        public final Builder<COMMIT> putAllDetails(Map<? extends ContentKey, ? extends MergeResult.KeyDetails> entries) {
            this.details.putAll(entries);
            return this;
        }

        public ImmutableMergeResult<COMMIT> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMergeResult(this);
        }

        private boolean wasAppliedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean wasSuccessfulIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("resultType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("sourceRef");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("targetBranch");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("effectiveTargetHash");
            }
            return "Cannot build MergeResult, some of required attributes are not set " + attributes;
        }
    }
}

