/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.Preconditions;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.immutables.value.Value;
import org.projectnessie.model.Validation;
import org.projectnessie.versioned.ImmutableRelativeCommitSpec;

@Value.Immutable
public abstract class RelativeCommitSpec {
    @Value.Parameter(order=1)
    public abstract Type type();

    @Value.Parameter(order=2)
    public abstract long longValue();

    @Value.Parameter(order=3)
    public abstract Instant instantValue();

    public String toString() {
        if (this.type() != Type.TIMESTAMP_MILLIS_EPOCH) {
            return Character.toString(this.type().mnemonic()) + this.longValue();
        }
        return this.type().mnemonic() + this.instantValue().toString();
    }

    public static List<RelativeCommitSpec> parseRelativeSpecs(String relativeSpec) {
        Matcher relatives = Validation.RELATIVE_COMMIT_SPEC_PART_PATTERN.matcher(relativeSpec);
        ArrayList<RelativeCommitSpec> relativeSpecs = new ArrayList<RelativeCommitSpec>();
        while (relatives.find()) {
            String type = relatives.group(1);
            String num = relatives.group(2);
            if (type == null && num == null) break;
            char mnemonic = type.charAt(0);
            relativeSpecs.add(RelativeCommitSpec.relativeCommitSpec(mnemonic, num));
        }
        return relativeSpecs;
    }

    public static RelativeCommitSpec relativeCommitSpec(char mnemonic, String value) {
        return RelativeCommitSpec.relativeCommitSpec(Type.typeForMnemonic(mnemonic), value);
    }

    public static RelativeCommitSpec relativeCommitSpec(Type type, String value) {
        long num = 0L;
        Instant instant = Instant.EPOCH;
        switch (type) {
            case TIMESTAMP_MILLIS_EPOCH: {
                try {
                    long v = Long.parseLong(value);
                    instant = Instant.ofEpochMilli(v);
                    break;
                }
                catch (NumberFormatException e1) {
                    try {
                        instant = Instant.parse(value);
                        break;
                    }
                    catch (DateTimeParseException e2) {
                        throw new IllegalArgumentException("'*' relative commit spec argument '" + value + "' must be represent an ISO-8601 timestamp ('Z' only) or a numeric value representing the milliseconds since epoch");
                    }
                }
            }
            case N_TH_PARENT: 
            case N_TH_PREDECESSOR: {
                try {
                    num = Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
                Preconditions.checkArgument((num > 0L && num < Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Illegal value %s for spec type %s (%s)", (Object)value, (Object)type.name(), (Object)Character.valueOf(type.mnemonic()));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return RelativeCommitSpec.relativeCommitSpec(type, num, instant);
    }

    public static RelativeCommitSpec relativeCommitSpec(Type type, long num, Instant instant) {
        return ImmutableRelativeCommitSpec.of(type, num, instant);
    }

    public static enum Type {
        TIMESTAMP_MILLIS_EPOCH('*'),
        N_TH_PREDECESSOR('~'),
        N_TH_PARENT('^');

        private final char mnemonic;

        static Type typeForMnemonic(char mnemonic) {
            switch (mnemonic) {
                case '*': {
                    return TIMESTAMP_MILLIS_EPOCH;
                }
                case '~': {
                    return N_TH_PREDECESSOR;
                }
                case '^': {
                    return N_TH_PARENT;
                }
            }
            throw new IllegalArgumentException("Illegal mnemonic '" + mnemonic + "'");
        }

        private Type(char mnemonic) {
            this.mnemonic = mnemonic;
        }

        public char mnemonic() {
            return this.mnemonic;
        }
    }
}

