/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Objects;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.nessie.relocated.protobuf.UnsafeByteOperations;
import org.projectnessie.versioned.Ref;

public abstract class Hash
implements Ref {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public abstract String asString();

    public abstract ByteString asBytes();

    public abstract int nibbleAt(int var1);

    public abstract int size();

    public static Hash of(@Nonnull String hash) {
        Objects.requireNonNull(hash);
        int len = hash.length();
        Preconditions.checkArgument((len % 2 == 0 && len > 0 ? 1 : 0) != 0, (String)"hash length needs to be a multiple of two, was %s", (int)len);
        switch (len >> 1) {
            case 32: {
                return new Hash256(hash);
            }
        }
        return new GenericHash(hash);
    }

    public static Hash of(@Nonnull ByteString bytes) {
        switch (bytes.size()) {
            case 32: {
                return new Hash256(bytes);
            }
        }
        return new GenericHash(bytes);
    }

    public String toString() {
        return "Hash " + this.asString();
    }

    @VisibleForTesting
    static byte nibble(char c) {
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48);
        }
        if (c >= 'a' && c <= 'f') {
            return (byte)(c - 97 + 10);
        }
        if (c >= 'A' && c <= 'F') {
            return (byte)(c - 65 + 10);
        }
        throw new IllegalArgumentException("Illegal hex character '" + c + "'");
    }

    @VisibleForTesting
    static long bytesToLong(ByteString bytes, int off) {
        long l = ((long)bytes.byteAt(off++) & 0xFFL) << 56;
        l |= ((long)bytes.byteAt(off++) & 0xFFL) << 48;
        l |= ((long)bytes.byteAt(off++) & 0xFFL) << 40;
        l |= ((long)bytes.byteAt(off++) & 0xFFL) << 32;
        l |= ((long)bytes.byteAt(off++) & 0xFFL) << 24;
        l |= ((long)bytes.byteAt(off++) & 0xFFL) << 16;
        l |= ((long)bytes.byteAt(off++) & 0xFFL) << 8;
        return l |= (long)bytes.byteAt(off) & 0xFFL;
    }

    @VisibleForTesting
    static void longToBytes(byte[] arr, int off, long v) {
        arr[off++] = (byte)(v >> 56);
        arr[off++] = (byte)(v >> 48);
        arr[off++] = (byte)(v >> 40);
        arr[off++] = (byte)(v >> 32);
        arr[off++] = (byte)(v >> 24);
        arr[off++] = (byte)(v >> 16);
        arr[off++] = (byte)(v >> 8);
        arr[off] = (byte)v;
    }

    @VisibleForTesting
    static long stringToLong(String s, int off) {
        long l = (long)Hash.nibble(s.charAt(off++)) << 60;
        l |= (long)Hash.nibble(s.charAt(off++)) << 56;
        l |= (long)Hash.nibble(s.charAt(off++)) << 52;
        l |= (long)Hash.nibble(s.charAt(off++)) << 48;
        l |= (long)Hash.nibble(s.charAt(off++)) << 44;
        l |= (long)Hash.nibble(s.charAt(off++)) << 40;
        l |= (long)Hash.nibble(s.charAt(off++)) << 36;
        l |= (long)Hash.nibble(s.charAt(off++)) << 32;
        l |= (long)Hash.nibble(s.charAt(off++)) << 28;
        l |= (long)Hash.nibble(s.charAt(off++)) << 24;
        l |= (long)Hash.nibble(s.charAt(off++)) << 20;
        l |= (long)Hash.nibble(s.charAt(off++)) << 16;
        l |= (long)Hash.nibble(s.charAt(off++)) << 12;
        l |= (long)Hash.nibble(s.charAt(off++)) << 8;
        l |= (long)Hash.nibble(s.charAt(off++)) << 4;
        return l |= (long)Hash.nibble(s.charAt(off));
    }

    @VisibleForTesting
    static int nibbleFromLong(long v, int index) {
        return (int)(v >> (int)(60L - (long)index * 4L)) & 0xF;
    }

    @VisibleForTesting
    static final class Hash256
    extends Hash {
        private final long l0;
        private final long l1;
        private final long l2;
        private final long l3;

        private Hash256(String hash) {
            this.l0 = Hash256.stringToLong(hash, 0);
            this.l1 = Hash256.stringToLong(hash, 16);
            this.l2 = Hash256.stringToLong(hash, 32);
            this.l3 = Hash256.stringToLong(hash, 48);
        }

        private Hash256(ByteString bytes) {
            this.l0 = Hash256.bytesToLong(bytes, 0);
            this.l1 = Hash256.bytesToLong(bytes, 8);
            this.l2 = Hash256.bytesToLong(bytes, 16);
            this.l3 = Hash256.bytesToLong(bytes, 24);
        }

        @Override
        public int nibbleAt(int nibbleIndex) {
            if (nibbleIndex >= 0) {
                if (nibbleIndex < 16) {
                    return Hash256.nibbleFromLong(this.l0, nibbleIndex);
                }
                if (nibbleIndex < 32) {
                    return Hash256.nibbleFromLong(this.l1, nibbleIndex - 16);
                }
                if (nibbleIndex < 48) {
                    return Hash256.nibbleFromLong(this.l2, nibbleIndex - 32);
                }
                if (nibbleIndex < 64) {
                    return Hash256.nibbleFromLong(this.l3, nibbleIndex - 48);
                }
            }
            throw new IllegalArgumentException("Invalid nibble index " + nibbleIndex);
        }

        @Override
        public int size() {
            return 32;
        }

        @Override
        public String asString() {
            StringBuilder sb = new StringBuilder(64);
            Hash256.longToString(sb, this.l0);
            Hash256.longToString(sb, this.l1);
            Hash256.longToString(sb, this.l2);
            Hash256.longToString(sb, this.l3);
            return sb.toString();
        }

        private static void longToString(StringBuilder sb, long v) {
            sb.append(HEX[(int)(v >> 60) & 0xF]);
            sb.append(HEX[(int)(v >> 56) & 0xF]);
            sb.append(HEX[(int)(v >> 52) & 0xF]);
            sb.append(HEX[(int)(v >> 48) & 0xF]);
            sb.append(HEX[(int)(v >> 44) & 0xF]);
            sb.append(HEX[(int)(v >> 40) & 0xF]);
            sb.append(HEX[(int)(v >> 36) & 0xF]);
            sb.append(HEX[(int)(v >> 32) & 0xF]);
            sb.append(HEX[(int)(v >> 28) & 0xF]);
            sb.append(HEX[(int)(v >> 24) & 0xF]);
            sb.append(HEX[(int)(v >> 20) & 0xF]);
            sb.append(HEX[(int)(v >> 16) & 0xF]);
            sb.append(HEX[(int)(v >> 12) & 0xF]);
            sb.append(HEX[(int)(v >> 8) & 0xF]);
            sb.append(HEX[(int)(v >> 4) & 0xF]);
            sb.append(HEX[(int)v & 0xF]);
        }

        @Override
        public ByteString asBytes() {
            byte[] bytes = new byte[32];
            Hash256.longToBytes(bytes, 0, this.l0);
            Hash256.longToBytes(bytes, 8, this.l1);
            Hash256.longToBytes(bytes, 16, this.l2);
            Hash256.longToBytes(bytes, 24, this.l3);
            return UnsafeByteOperations.unsafeWrap((byte[])bytes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Hash256)) {
                return false;
            }
            Hash256 hash256 = (Hash256)o;
            return this.l0 == hash256.l0 && this.l1 == hash256.l1 && this.l2 == hash256.l2 && this.l3 == hash256.l3;
        }

        public int hashCode() {
            return (int)(this.l0 >> 32);
        }
    }

    @VisibleForTesting
    static final class GenericHash
    extends Hash {
        private final byte[] bytes;

        private GenericHash(String hash) {
            int len = hash.length();
            byte[] bytes = new byte[len >> 1];
            int i = 0;
            int c = 0;
            while (c < len) {
                byte value = (byte)(GenericHash.nibble(hash.charAt(c++)) << 4);
                bytes[i] = value = (byte)(value | GenericHash.nibble(hash.charAt(c++)));
                ++i;
            }
            this.bytes = bytes;
        }

        private GenericHash(ByteString bytes) {
            this.bytes = bytes.toByteArray();
        }

        @Override
        public int nibbleAt(int nibbleIndex) {
            byte b = this.bytes[nibbleIndex >> 1];
            if ((nibbleIndex & 1) == 0) {
                b = (byte)(b >> 4);
            }
            return b & 0xF;
        }

        @Override
        public int size() {
            return this.bytes.length;
        }

        @Override
        public String asString() {
            StringBuilder sb = new StringBuilder(2 * this.bytes.length);
            for (byte b : this.bytes) {
                sb.append(HEX[b >> 4 & 0xF]);
                sb.append(HEX[b & 0xF]);
            }
            return sb.toString();
        }

        @Override
        public ByteString asBytes() {
            return UnsafeByteOperations.unsafeWrap((byte[])this.bytes);
        }

        public int hashCode() {
            byte[] b = this.bytes;
            int h = (this.bytes[0] & 0xFF) << 24;
            if (b.length > 1) {
                h |= (this.bytes[1] & 0xFF) << 16;
            }
            if (b.length > 2) {
                h |= (this.bytes[2] & 0xFF) << 8;
            }
            if (b.length > 3) {
                h |= this.bytes[3] & 0xFF;
            }
            return h;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof GenericHash)) {
                return false;
            }
            GenericHash that = (GenericHash)obj;
            return Arrays.equals(this.bytes, that.bytes);
        }
    }
}

