/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.IdentifiedContentKey;
import org.projectnessie.versioned.CommitValidation;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommitValidation.CommitOperation", generator="Immutables")
@Immutable
public final class ImmutableCommitOperation
implements CommitValidation.CommitOperation {
    private final IdentifiedContentKey identifiedKey;
    private final CommitValidation.CommitOperationType operationType;

    private ImmutableCommitOperation(IdentifiedContentKey identifiedKey, CommitValidation.CommitOperationType operationType) {
        this.identifiedKey = Objects.requireNonNull(identifiedKey, "identifiedKey");
        this.operationType = Objects.requireNonNull(operationType, "operationType");
    }

    private ImmutableCommitOperation(ImmutableCommitOperation original, IdentifiedContentKey identifiedKey, CommitValidation.CommitOperationType operationType) {
        this.identifiedKey = identifiedKey;
        this.operationType = operationType;
    }

    @Override
    public IdentifiedContentKey identifiedKey() {
        return this.identifiedKey;
    }

    @Override
    public CommitValidation.CommitOperationType operationType() {
        return this.operationType;
    }

    public final ImmutableCommitOperation withIdentifiedKey(IdentifiedContentKey value) {
        if (this.identifiedKey == value) {
            return this;
        }
        IdentifiedContentKey newValue = Objects.requireNonNull(value, "identifiedKey");
        return new ImmutableCommitOperation(this, newValue, this.operationType);
    }

    public final ImmutableCommitOperation withOperationType(CommitValidation.CommitOperationType value) {
        CommitValidation.CommitOperationType newValue = Objects.requireNonNull(value, "operationType");
        if (this.operationType == newValue) {
            return this;
        }
        return new ImmutableCommitOperation(this, this.identifiedKey, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitOperation && this.equalTo(0, (ImmutableCommitOperation)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommitOperation another) {
        return this.identifiedKey.equals(another.identifiedKey) && this.operationType.equals((Object)another.operationType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifiedKey.hashCode();
        h += (h << 5) + this.operationType.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CommitOperation").omitNullValues().add("identifiedKey", (Object)this.identifiedKey).add("operationType", (Object)this.operationType).toString();
    }

    public static ImmutableCommitOperation of(IdentifiedContentKey identifiedKey, CommitValidation.CommitOperationType operationType) {
        return new ImmutableCommitOperation(identifiedKey, operationType);
    }

    public static ImmutableCommitOperation copyOf(CommitValidation.CommitOperation instance) {
        if (instance instanceof ImmutableCommitOperation) {
            return (ImmutableCommitOperation)instance;
        }
        return ImmutableCommitOperation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommitValidation.CommitOperation", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_IDENTIFIED_KEY = 1L;
        private static final long INIT_BIT_OPERATION_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private IdentifiedContentKey identifiedKey;
        @Nullable
        private CommitValidation.CommitOperationType operationType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitValidation.CommitOperation instance) {
            Objects.requireNonNull(instance, "instance");
            this.identifiedKey(instance.identifiedKey());
            this.operationType(instance.operationType());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder identifiedKey(IdentifiedContentKey identifiedKey) {
            this.identifiedKey = Objects.requireNonNull(identifiedKey, "identifiedKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder operationType(CommitValidation.CommitOperationType operationType) {
            this.operationType = Objects.requireNonNull(operationType, "operationType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableCommitOperation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitOperation(null, this.identifiedKey, this.operationType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("identifiedKey");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("operationType");
            }
            return "Cannot build CommitOperation, some of required attributes are not set " + attributes;
        }
    }
}

