/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import org.immutables.value.Value;
import org.projectnessie.model.Content;
import org.projectnessie.model.IdentifiedContentKey;
import org.projectnessie.versioned.ImmutableKeyEntry;

@Value.Immutable
public interface KeyEntry {
    @Value.Parameter(order=1)
    public IdentifiedContentKey getKey();

    @Nullable
    @Value.Parameter(order=2)
    public Content getContent();

    @Value.Check
    default public void verify() {
        Content content = this.getContent();
        if (content == null) {
            return;
        }
        IdentifiedContentKey key = this.getKey();
        Preconditions.checkArgument((boolean)key.type().equals(content.getType()), (String)"Content type from key '%s' does not match actual type of content: %s", (Object)key.type(), (Object)content);
        Preconditions.checkArgument((boolean)key.lastElement().contentId().equals(content.getId()), (String)"Content id from key '%s' does not match actual id of content: %s", (Object)key, (Object)content);
    }

    public static KeyEntry of(IdentifiedContentKey key) {
        return ImmutableKeyEntry.of(key, null);
    }

    public static KeyEntry of(IdentifiedContentKey key, @NotNull Content content) {
        return ImmutableKeyEntry.of(key, content);
    }
}

